/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.DataSourceHolder;
import com.github.drinkjava2.jtransactions.ThreadConnectionManager;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxInfo;
import com.github.drinkjava2.jtransactions.TxResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;

public class TinyTxConnectionManager
extends ThreadConnectionManager {
    public static final TinyTxConnectionManager instance() {
        return InnerTinyTxCM.INSTANCE;
    }

    @Override
    public Connection getConnection(Object dsOrHolder) throws SQLException {
        DataSource ds = dsOrHolder instanceof DataSource ? (DataSource)dsOrHolder : ((DataSourceHolder)dsOrHolder).getDataSource();
        TransactionsException.assureNotNull(ds, "DataSource can not be null");
        if (this.isInTransaction()) {
            TxInfo tx = this.getThreadTxInfo();
            if (tx.getConnectionCache().size() > 1) {
                throw new TransactionsException("TinyTxConnectionManager can only support one connection in one thread");
            }
            Connection conn = tx.getConnectionCache().get(ds);
            if (conn == null && !tx.getConnectionCache().isEmpty()) {
                throw new TransactionsException("Error: TinyTx do not support get multiple connections in one thread");
            }
            if (conn == null) {
                conn = ds.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(tx.getTxIsolationLevel());
                tx.getConnectionCache().put(ds, conn);
            }
            return conn;
        }
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxResult commitTransaction() throws Exception {
        if (!this.isInTransaction()) {
            throw new TransactionsException("Transaction not opened, can not commit");
        }
        try {
            Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
            if (conns.isEmpty()) {
                TxResult txResult = TxResult.TX_SUCESS;
                return txResult;
            }
            if (conns.size() > 1) {
                throw new TransactionsException("TinyTx can only support one dataSource in one thread, can not commit");
            }
            Connection con = conns.iterator().next();
            if (con.getAutoCommit()) {
                throw new TransactionsException("Connection is auto commit status, can not commit");
            }
            con.commit();
        }
        finally {
            this.endTransaction();
        }
        return TxResult.TX_SUCESS;
    }

    @Override
    public TxResult rollbackTransaction() {
        if (!this.isInTransaction()) {
            throw new TransactionsException("Transaction not opened, can not rollback");
        }
        try {
            Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
            if (conns.isEmpty()) {
                TxResult txResult = TxResult.TX_FAIL;
                return txResult;
            }
            Connection con = conns.iterator().next();
            if (con.getAutoCommit()) {
                throw new TransactionsException("Connection is auto commit status, can not rollback");
            }
            con.rollback();
            con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new TransactionsException(e);
        }
        finally {
            this.endTransaction();
        }
        return TxResult.TX_FAIL;
    }

    private void endTransaction() {
        if (!this.isInTransaction()) {
            return;
        }
        Connection con = null;
        try {
            Collection<Connection> conns = this.getThreadTxInfo().getConnectionCache().values();
            if (conns.isEmpty()) {
                return;
            }
            if (conns.size() > 1) {
                throw new TransactionsException("TinyTx can only support one dataSource in one thread, can not end transaction");
            }
            con = conns.iterator().next();
            if (!con.getAutoCommit()) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new TransactionsException("Fail to setAutoCommit to true", e);
        }
        finally {
            this.getThreadTxInfo().getConnectionCache().clear();
            this.setThreadTxInfo(null);
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    throw new TransactionsException("Fail to close connection", e);
                }
            }
        }
    }

    private static class InnerTinyTxCM {
        private static final TinyTxConnectionManager INSTANCE = new TinyTxConnectionManager();

        private InnerTinyTxCM() {
        }
    }
}

