/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jwebbox;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class WebBox {
    public static final String JWEBBOX_ID = "jwebbox";
    private String name;
    private String prepareStaticMethod;
    private Object prepareBean;
    private String prepareBeanMethod;
    private String prepareURL;
    private String text;
    private Object page;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private WebBox fatherWebBox;
    private PageContext pageContext;

    public WebBox() {
    }

    public WebBox(String page) {
        this.setPage(page);
    }

    public static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    public void beforeShow() {
    }

    public void beforeExecute() {
    }

    public void execute() {
    }

    public void afterExecute() {
    }

    public void afterPrepared() {
    }

    public void afterShow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(PageContext pageContext) {
        try {
            this.pageContext = pageContext;
            this.beforeShow();
            this.beforeExecute();
            this.execute();
            this.afterExecute();
            this.prepareOnly(pageContext);
            this.afterPrepared();
            this.showText(pageContext);
            WebBox.showPageOrUrl(pageContext, this.page, this);
            this.afterShow();
        }
        finally {
            this.pageContext = null;
        }
    }

    private void showText(PageContext pageContext) {
        if (this.text != null && this.text.length() > 0) {
            try {
                pageContext.getOut().write(this.text);
            }
            catch (IOException e) {
                throw new WebBoxException(e);
            }
        }
    }

    public void prepareOnly(PageContext pageContext) {
        if (!WebBox.isEmptyStr(this.prepareStaticMethod)) {
            int index = this.prepareStaticMethod.lastIndexOf(46);
            String className = this.prepareStaticMethod.substring(0, index);
            String methodName = this.prepareStaticMethod.substring(index + 1, this.prepareStaticMethod.length());
            if (WebBox.isEmptyStr(className) || WebBox.isEmptyStr(methodName)) {
                throw new WebBoxException("Error#001: Can not call method: " + this.prepareStaticMethod);
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, PageContext.class, WebBox.class);
                m.invoke(c, pageContext, this);
            }
            catch (Exception e) {
                throw new WebBoxException(e);
            }
        }
        if (this.prepareBean != null) {
            this.executeBeanMethod(pageContext);
        }
        WebBox.showPageOrUrl(pageContext, this.prepareURL, this);
    }

    private void executeBeanMethod(PageContext pageContext) {
        try {
            Class<?> c = this.prepareBean.getClass();
            String methodName = WebBox.isEmptyStr(this.prepareBeanMethod) ? "prepare" : this.prepareBeanMethod;
            Method m = c.getMethod(methodName, PageContext.class, WebBox.class);
            m.invoke(this.prepareBean, pageContext, this);
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
    }

    public void showPageOnly(PageContext pageContext) {
        WebBox.showPageOrUrl(pageContext, this.page, this);
    }

    private static void showPageOrUrl(PageContext pageContext, Object page, WebBox currentBox) {
        if (page == null) {
            return;
        }
        if (page instanceof WebBox) {
            ((WebBox)page).show(pageContext);
            return;
        }
        if (!(page instanceof String)) {
            throw new WebBoxException("" + page + " is not a String or WebBox.");
        }
        String pageOrUrl = (String)page;
        if (WebBox.isEmptyStr(pageOrUrl)) {
            return;
        }
        WebBox fatherWebBox = (WebBox)pageContext.getRequest().getAttribute(JWEBBOX_ID);
        if (fatherWebBox != null) {
            currentBox.setFatherWebBox(fatherWebBox);
        }
        pageContext.getRequest().setAttribute(JWEBBOX_ID, (Object)currentBox);
        try {
            pageContext.getOut().flush();
            pageContext.getRequest().getRequestDispatcher(pageOrUrl).include(pageContext.getRequest(), pageContext.getResponse());
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
        finally {
            pageContext.getRequest().setAttribute(JWEBBOX_ID, (Object)fatherWebBox);
            currentBox.setFatherWebBox(null);
        }
    }

    public static WebBox getBox(PageContext pageContext) {
        WebBox currentBox = (WebBox)pageContext.getRequest().getAttribute(JWEBBOX_ID);
        if (currentBox == null) {
            throw new WebBoxException("Error#003: Can not find WebBox instance in pageContext");
        }
        return currentBox;
    }

    public static <T> T getAttribute(PageContext pageContext, String attributeName) {
        T obj = WebBox.getBox(pageContext).getAttribute(attributeName);
        return obj;
    }

    public static void showAttribute(PageContext pageContext, String attributeName) {
        Object obj = WebBox.getAttribute(pageContext, attributeName);
        WebBox.showTarget(pageContext, obj);
    }

    public static void showTarget(PageContext pageContext, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof WebBox) {
            ((WebBox)target).show(pageContext);
        } else if (target instanceof ArrayList) {
            for (Object item : (ArrayList)target) {
                WebBox.showTarget(pageContext, item);
            }
        } else if (target instanceof Class) {
            WebBox bx = null;
            try {
                bx = (WebBox)((Class)target).newInstance();
            }
            catch (Exception e) {
                throw new WebBoxException("Can not create WebBox instance for target class '" + target + "'", e);
            }
            bx.show(pageContext);
        } else if (target instanceof String) {
            String str = (String)target;
            if (str.startsWith("/")) {
                WebBox.showPageOrUrl(pageContext, str, WebBox.getBox(pageContext));
            } else {
                try {
                    pageContext.getOut().write(str);
                }
                catch (IOException e) {
                    throw new WebBoxException(e);
                }
            }
        } else {
            throw new WebBoxException("Can not show unknow type object " + target + " on page");
        }
    }

    public WebBox setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public <T> T getAttribute(String key) {
        Object obj = this.attributeMap.get(key);
        if (obj == null && this.pageContext != null) {
            obj = this.pageContext.getRequest().getAttribute(key);
            if (obj == null) {
                obj = this.pageContext.getRequest().getParameter(key);
            }
            if (obj == null) {
                obj = this.pageContext.getAttribute(key);
            }
            if (obj == null) {
                obj = this.pageContext.getSession().getAttribute(key);
            }
        }
        return (T)obj;
    }

    public <T> T getObject(String key) {
        if (this.pageContext == null || key == null) {
            return null;
        }
        Object obj = this.pageContext.getAttribute(key);
        if (obj == null) {
            obj = this.pageContext.getRequest().getAttribute(key);
        }
        if (obj == null) {
            obj = this.pageContext.getRequest().getParameter(key);
        }
        if (obj == null) {
            obj = this.pageContext.getSession().getAttribute(key);
        }
        return (T)obj;
    }

    public void setPageContextAttribute(String key, Object value) {
        this.pageContext.setAttribute(key, value);
    }

    public void setRequestAttribute(String key, Object value) {
        this.pageContext.getRequest().setAttribute(key, value);
    }

    public void setSessionAttribute(String key, Object value) {
        this.pageContext.getSession().setAttribute(key, value);
    }

    public String getPrepareURL() {
        return this.prepareURL;
    }

    public WebBox setPrepareURL(String prepareURL) {
        this.prepareURL = prepareURL;
        return this;
    }

    public Object getPage() {
        return this.page;
    }

    public WebBox setPage(Object page) {
        if (page != null && !(page instanceof String) && !(page instanceof WebBox)) {
            throw new WebBoxException("setPage method only accept String or WebBox instance type parameter");
        }
        this.page = page;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public WebBox setText(String text) {
        this.text = text;
        return this;
    }

    public WebBox setPrepareStaticMethod(String prepareStaticMethod) {
        this.prepareStaticMethod = prepareStaticMethod;
        return this;
    }

    public String getPrepareStaticMethod() {
        return this.prepareStaticMethod;
    }

    public Object getPrepareBean() {
        return this.prepareBean;
    }

    public WebBox setPrepareBean(Object prepareBean) {
        this.prepareBean = prepareBean;
        return this;
    }

    public String getPrepareBeanMethod() {
        return this.prepareBeanMethod;
    }

    public WebBox setPrepareBeanMethod(String prepareBeanMethod) {
        this.prepareBeanMethod = prepareBeanMethod;
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public WebBox setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebBox setName(String name) {
        this.name = name;
        return this;
    }

    public WebBox getFatherWebBox() {
        return this.fatherWebBox;
    }

    public void setFatherWebBox(WebBox fatherWebBox) {
        this.fatherWebBox = fatherWebBox;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public static class Show
    extends SimpleTagSupport {
        private String attribute;
        private Object target;

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public void doTag() throws JspException, IOException {
            if (this.attribute != null && this.attribute.length() != 0) {
                WebBox.showAttribute((PageContext)this.getJspContext(), this.getAttribute());
            }
            if (this.target != null) {
                WebBox.showTarget((PageContext)this.getJspContext(), this.target);
            }
        }
    }

    public static class WebBoxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WebBoxException(String msg) {
            super(msg);
        }

        public WebBoxException(Throwable e) {
            super(e);
        }

        public WebBoxException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

