/*
 * Decompiled with CFR 0.152.
 */
package showcase.ai.data.orchestration.scdf.processors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class SplitJsonArrayProcessor
implements Function<byte[], List<Message<byte[]>>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SplitJsonArrayProcessor.class);
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<Message<byte[]>> apply(byte[] inputBytes) {
        if (inputBytes == null || inputBytes.length == 0) {
            return null;
        }
        String input = new String(inputBytes);
        log.info("input: {}", (Object)input);
        if (input.trim().isEmpty()) {
            return null;
        }
        JsonNode rootNode = this.mapper.readTree(input);
        if (!rootNode.isArray()) {
            return List.of(MessageBuilder.withPayload((Object)rootNode.toString().getBytes(StandardCharsets.UTF_8)).build());
        }
        ArrayList<Message<byte[]>> list = new ArrayList<Message<byte[]>>();
        for (JsonNode element : rootNode) {
            list.add((Message<byte[]>)MessageBuilder.withPayload((Object)element.toString().getBytes(StandardCharsets.UTF_8)).build());
        }
        return list;
    }
}

