/*
 * Decompiled with CFR 0.152.
 */
package com.godfather1103.app;

import com.godfather1103.error.FailureException;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import ga.rugal.maven.plugin.RuleChecker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class RuleCheckApp {
    ArrayList<RuleChecker> ruleCheckers;

    public RuleCheckApp() throws FailureException {
        try {
            String s = this.getStrFromSteam(RuleCheckApp.class.getResourceAsStream("/rule.json"), "UTF-8");
            Type type = new TypeToken<ArrayList<RuleChecker>>(){}.getType();
            this.ruleCheckers = (ArrayList)new Gson().fromJson(s, type);
        }
        catch (IOException ex) {
            throw new FailureException(ex.getMessage());
        }
    }

    public String getStrFromSteam(InputStream in, String charset) throws IOException {
        StringBuffer sb = new StringBuffer();
        byte[] bytes = new byte[1024];
        if (in != null) {
            int len = in.read(bytes);
            sb.append(new String(bytes, 0, len, charset));
        }
        return sb.toString();
    }

    public RuleCheckApp(String configFilePath) throws FailureException {
        try {
            String s = FileUtils.readFileToString((File)new File(configFilePath), (String)"UTF-8");
            Type type = new TypeToken<ArrayList<RuleChecker>>(){}.getType();
            this.ruleCheckers = (ArrayList)new Gson().fromJson(s, type);
        }
        catch (IOException ex) {
            throw new FailureException(ex.getMessage());
        }
    }

    public void check(String text) throws FailureException {
        if (this.ruleCheckers == null) {
            throw new FailureException("\u76f8\u5173\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        for (RuleChecker ruleChecker : this.ruleCheckers) {
            ruleChecker.check(text);
        }
    }
}

