/*
 * Decompiled with CFR 0.152.
 */
package ga.rugal.maven.plugin;

import com.godfather1103.error.FailureException;
import ga.rugal.maven.plugin.CaptureGroup;
import ga.rugal.maven.plugin.rule.CaseRule;
import ga.rugal.maven.plugin.rule.LengthRule;
import java.beans.ConstructorProperties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuleChecker {
    private CaptureGroup[] captureGroups;
    private String matchPattern;
    private String showMsg;
    private final String pattern = "[\\w\\d\\s-_]+";

    public void check(String match) throws FailureException {
        Pattern pattern = Pattern.compile(this.matchPattern);
        Matcher matcher = pattern.matcher(match);
        if (!matcher.find()) {
            throw new FailureException(this.showMsg);
        }
        if (this.captureGroups != null) {
            for (int i = 1; i <= Math.min(this.captureGroups.length, matcher.groupCount()); ++i) {
                String extractedContent = this.extractContent(matcher.group(i));
                this.checkCaptureGroup(extractedContent, this.captureGroups[i - 1]);
            }
        }
    }

    public void checkCaptureGroup(String match, CaptureGroup captureGroup) throws FailureException {
        if (!CaseRule.validate(match, captureGroup.getCaseFormat())) {
            throw new FailureException(String.format("Case format should be %s", captureGroup.getCaseFormat().name()));
        }
        if (!LengthRule.fitMax(match, captureGroup.getMax())) {
            throw new FailureException(String.format("Length should be no more than %d", captureGroup.getMax()));
        }
        if (!LengthRule.fitMin(match, captureGroup.getMin())) {
            throw new FailureException(String.format("Length should be no less than %d", captureGroup.getMin()));
        }
    }

    private String extractContent(String capturedString) throws FailureException {
        if (capturedString == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(this.pattern);
        Matcher matcher = pattern.matcher(capturedString);
        if (!matcher.find()) {
            throw new FailureException(String.format("No content found [%s]", capturedString));
        }
        return matcher.group().trim();
    }

    @ConstructorProperties(value={"captureGroups", "matchPattern", "showMsg"})
    public RuleChecker(CaptureGroup[] captureGroups, String matchPattern, String showMsg) {
        this.captureGroups = captureGroups;
        this.matchPattern = matchPattern;
        this.showMsg = showMsg;
    }
}

