(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'TelegramBotAPI', 'klock-root-klock', 'kotlinx-coroutines-core', 'ktor-ktor-io', 'ktor-ktor-client-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('TelegramBotAPI'), require('klock-root-klock'), require('kotlinx-coroutines-core'), require('ktor-ktor-io'), require('ktor-ktor-client-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }if (typeof TelegramBotAPI === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'TelegramBotAPI' was not found. Please, check whether 'TelegramBotAPI' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }if (typeof this['klock-root-klock'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'klock-root-klock' was not found. Please, check whether 'klock-root-klock' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }if (typeof this['ktor-ktor-io'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'ktor-ktor-io' was not found. Please, check whether 'ktor-ktor-io' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }if (typeof this['ktor-ktor-client-core'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI-extensions-api'. Its dependency 'ktor-ktor-client-core' was not found. Please, check whether 'ktor-ktor-client-core' is loaded prior to 'TelegramBotAPI-extensions-api'.");
    }root['TelegramBotAPI-extensions-api'] = factory(typeof this['TelegramBotAPI-extensions-api'] === 'undefined' ? {} : this['TelegramBotAPI-extensions-api'], kotlin, TelegramBotAPI, this['klock-root-klock'], this['kotlinx-coroutines-core'], this['ktor-ktor-io'], this['ktor-ktor-client-core']);
  }
}(this, function (_, Kotlin, $module$TelegramBotAPI, $module$klock_root_klock, $module$kotlinx_coroutines_core, $module$ktor_ktor_io, $module$ktor_ktor_client_core) {
  'use strict';
  var DeleteMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.DeleteMessage;
  var ForwardMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.ForwardMessage;
  var types = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types;
  var GetUpdates = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.GetUpdates;
  var SentMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.SentMediaGroupUpdate;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var MediaGroupMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.message.abstracts.MediaGroupMessage;
  var BaseEditMessageUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.abstracts.BaseEditMessageUpdate;
  var BaseSentMessageUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.abstracts.BaseSentMessageUpdate;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var MessageMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.MessageMediaGroupUpdate;
  var MessageUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MessageUpdate;
  var ChannelPostMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.ChannelPostMediaGroupUpdate;
  var ChannelPostUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.ChannelPostUpdate;
  var EditMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.EditMediaGroupUpdate;
  var EditMessageMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.EditMessageMediaGroupUpdate;
  var EditMessageUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.EditMessageUpdate;
  var EditChannelPostMediaGroupUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.MediaGroupUpdates.EditChannelPostMediaGroupUpdate;
  var EditChannelPostUpdate = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.update.EditChannelPostUpdate;
  var getKClass = Kotlin.getKClass;
  var toString = Kotlin.toString;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var sortWith = Kotlin.kotlin.collections.sortWith_nqfjgj$;
  var wrapFunction = Kotlin.wrapFunction;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Comparator = Kotlin.kotlin.Comparator;
  var sortedWith = Kotlin.kotlin.collections.sortedWith_eknfly$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var L60 = Kotlin.Long.fromInt(60);
  var L1000 = Kotlin.Long.fromInt(1000);
  var DateTime = $module$klock_root_klock.com.soywiz.klock.DateTime;
  var L0 = Kotlin.Long.ZERO;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var TimeSpan = $module$klock_root_klock.com.soywiz.klock.TimeSpan;
  var Closeable = $module$ktor_ktor_io.io.ktor.utils.io.core.Closeable;
  var SendLocation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendLocation;
  var Math_0 = Math;
  var StopPoll = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.StopPoll;
  var AnswerCallbackQuery = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.AnswerCallbackQuery;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var AnswerInlineQuery = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.AnswerInlineQuery;
  var AnswerPreCheckoutQueryOk = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerPreCheckoutQueryOk;
  var AnswerPreCheckoutQueryError = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerPreCheckoutQueryError;
  var AnswerShippingQueryOk = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerShippingQueryOk;
  var AnswerShippingQueryError = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerShippingQueryError;
  var bot = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.bot;
  var SetMyCommands = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.bot.SetMyCommands;
  var ExportChatInviteLink = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.ExportChatInviteLink;
  var LeaveChat = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.LeaveChat;
  var GetChat = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChat;
  var GetChatAdministrators = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChatAdministrators;
  var GetChatMembersCount = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChatMembersCount;
  var GetChatMember = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.GetChatMember;
  var KickChatMember = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.KickChatMember;
  var PromoteChatMember = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.PromoteChatMember;
  var ChatPermissions = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.chat.ChatPermissions;
  var RestrictChatMember = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.RestrictChatMember;
  var SetChatAdministratorCustomTitle = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.SetChatAdministratorCustomTitle;
  var UnbanChatMember = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.UnbanChatMember;
  var DeleteChatPhoto = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.DeleteChatPhoto;
  var PinChatMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.PinChatMessage;
  var PublicChat = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.chat.abstracts.PublicChat;
  var SetChatDescription = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatDescription;
  var SetChatPermissions = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatPermissions;
  var SetChatPhoto = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatPhoto;
  var SetChatTitle = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatTitle;
  var UnpinChatMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.UnpinChatMessage;
  var DeleteChatStickerSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.stickers.DeleteChatStickerSet;
  var SetChatStickerSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.chat.stickers.SetChatStickerSet;
  var EditChatMessageLiveLocation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.EditChatMessageLiveLocation;
  var EditInlineMessageLiveLocation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.EditInlineMessageLiveLocation;
  var StopChatMessageLiveLocation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.StopChatMessageLiveLocation;
  var StopInlineMessageLiveLocation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.StopInlineMessageLiveLocation;
  var EditChatMessageReplyMarkup = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.ReplyMarkup.EditChatMessageReplyMarkup;
  var EditInlineMessageReplyMarkup = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.ReplyMarkup.EditInlineMessageReplyMarkup;
  var EditChatMessageCaption = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.caption.EditChatMessageCaption;
  var EditInlineMessageCaption = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.caption.EditInlineMessageCaption;
  var EditChatMessageMedia = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.media.EditChatMessageMedia;
  var EditInlineMessageMedia = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.media.EditInlineMessageMedia;
  var EditChatMessageText = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.text.EditChatMessageText;
  var EditInlineMessageText = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.edit.text.EditInlineMessageText;
  var GetGameHighScoresByChat = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.games.GetGameHighScoresByChat;
  var GetGameHighScoresByInlineMessageId = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.games.GetGameHighScoresByInlineMessageId;
  var SetGameScoreByChatId = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.games.SetGameScoreByChatId;
  var SetGameScoreByInlineMessageId = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.games.SetGameScoreByInlineMessageId;
  var GetFile = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetFile;
  var GetStickerSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetStickerSet;
  var GetUserProfilePhotos = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetUserProfilePhotos;
  var SendAction = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendAction;
  var actions = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.types.actions;
  var SendContact = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendContact;
  var SendContact_init = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendContact_init_q59u6w$;
  var SendDice = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendDice;
  var SendTextMessage = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendTextMessage;
  var SendVenue = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendVenue;
  var SendVenue_init = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendVenue_init_umuec7$;
  var SendGame = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.games.SendGame;
  var SendAnimation = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendAnimation_bvbj0d$;
  var SendAudio = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendAudio_sqi91b$;
  var SendDocument = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendDocument_8v06dl$;
  var SendMediaGroup = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendMediaGroup_vff2fm$;
  var SendPhoto = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendPhoto_6cnbrj$;
  var SendSticker = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendSticker_xey8uw$;
  var SendVideo = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVideo_5taoth$;
  var SendVideoNote = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVideoNote_l63rym$;
  var SendVoice = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVoice_7n0gf3$;
  var SendInvoice = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.payments.SendInvoice;
  var SendRegularPoll = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.polls.SendRegularPoll;
  var SendQuizPoll = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.send.polls.SendQuizPoll;
  var AddAnimatedStickerToSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.AddAnimatedStickerToSet_16zbtk$;
  var AddStaticStickerToSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.AddStaticStickerToSet_16zbtk$;
  var CreateNewAnimatedStickerSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.CreateNewAnimatedStickerSet_fky01s$;
  var CreateNewStaticStickerSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.CreateNewStaticStickerSet_fky01s$;
  var DeleteStickerFromSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.DeleteStickerFromSet;
  var SetStickerPositionInSet = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.SetStickerPositionInSet;
  var SetStickerSetThumb = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.SetStickerSetThumb;
  var SetStickerSetThumb_0 = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.SetStickerSetThumb_u2cx19$;
  var UploadStickerFile = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.UploadStickerFile;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope_1fupul$;
  var get_isActive = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_isActive_e9pf1l$;
  var minus = Kotlin.kotlin.collections.minus_2ws7j4$;
  var Unit = Kotlin.kotlin.Unit;
  var supervisorScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.supervisorScope_awg8ri$;
  var HttpRequestTimeoutException = $module$ktor_ktor_client_core.io.ktor.client.features.HttpRequestTimeoutException;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var RequestException = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.bot.exceptions.RequestException;
  var Exception = Kotlin.kotlin.Exception;
  var FlowsUpdatesFilter = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.updateshandlers.FlowsUpdatesFilter;
  var SimpleUpdatesFilter = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.updateshandlers.SimpleUpdatesFilter;
  var DeleteWebhook = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.DeleteWebhook;
  var GetWebhookInfo = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.GetWebhookInfo;
  var SetWebhook = $module$TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.SetWebhook_1wefy4$;
  function deleteMessage($receiver, chatId, messageId, continuation) {
    return $receiver.execute_2kauxl$(new DeleteMessage(chatId, messageId), continuation);
  }
  function deleteMessage_0($receiver, chat, messageId, continuation) {
    return deleteMessage($receiver, chat.id, messageId, continuation);
  }
  function deleteMessage_1($receiver, message, continuation) {
    return deleteMessage_0($receiver, message.chat, message.messageId, continuation);
  }
  function delete_0($receiver, requestsExecutor, continuation) {
    return deleteMessage_1(requestsExecutor, $receiver, continuation);
  }
  function forwardMessage($receiver, fromChatId, toChatId, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return $receiver.execute_2kauxl$(new ForwardMessage(fromChatId, toChatId, messageId, disableNotification), continuation);
  }
  function forwardMessage_0($receiver, fromChat, toChatId, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return forwardMessage($receiver, fromChat.id, toChatId, messageId, disableNotification, continuation);
  }
  function forwardMessage_1($receiver, fromChatId, toChat, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return forwardMessage($receiver, fromChatId, toChat.id, messageId, disableNotification, continuation);
  }
  function forwardMessage_2($receiver, fromChat, toChat, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return forwardMessage($receiver, fromChat.id, toChat.id, messageId, disableNotification, continuation);
  }
  function forwardMessage_3($receiver, toChatId, message, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return forwardMessage_0($receiver, message.chat, toChatId, message.messageId, disableNotification, continuation);
  }
  function forwardMessage_4($receiver, toChat, message, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return forwardMessage_2($receiver, message.chat, toChat, message.messageId, disableNotification, continuation);
  }
  function getMe($receiver, continuation) {
    return getMe_0($receiver, continuation);
  }
  function getUpdates($receiver, offset, limit, timeout, allowed_updates, continuation) {
    if (offset === void 0)
      offset = null;
    if (limit === void 0)
      limit = types.getUpdatesLimit.last;
    if (timeout === void 0)
      timeout = null;
    if (allowed_updates === void 0)
      allowed_updates = types.ALL_UPDATES_LIST;
    return $receiver.execute_2kauxl$(new GetUpdates(offset, limit, timeout, allowed_updates), continuation);
  }
  function getUpdates_0($receiver, lastUpdate, limit, timeout, allowed_updates, continuation) {
    if (limit === void 0)
      limit = types.getUpdatesLimit.last;
    if (timeout === void 0)
      timeout = null;
    if (allowed_updates === void 0)
      allowed_updates = types.ALL_UPDATES_LIST;
    return getUpdates($receiver, lastUpdate.updateId.add(Kotlin.Long.fromInt(1)), limit, timeout, allowed_updates, continuation);
  }
  function Comparator$ObjectLiteral(closure$comparison) {
    this.closure$comparison = closure$comparison;
  }
  Comparator$ObjectLiteral.prototype.compare = function (a, b) {
    return this.closure$comparison(a, b);
  };
  Comparator$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Comparator]};
  var compareBy$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function Comparator$ObjectLiteral_0(closure$comparison) {
    this.closure$comparison = closure$comparison;
  }
  Comparator$ObjectLiteral_0.prototype.compare = function (a, b) {
    return this.closure$comparison(a, b);
  };
  Comparator$ObjectLiteral_0.$metadata$ = {kind: Kind_CLASS, interfaces: [Comparator]};
  var compareBy$lambda_0 = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function lastUpdateIdentifier($receiver) {
    var tmp$;
    if (Kotlin.isType($receiver, SentMediaGroupUpdate)) {
      tmp$ = last($receiver.origins).updateId;
    } else {
      tmp$ = $receiver.updateId;
    }
    return tmp$;
  }
  function lastUpdateIdentifier_0($receiver) {
    var tmp$;
    var maxBy$result;
    maxBy$break: do {
      var iterator = $receiver.iterator();
      if (!iterator.hasNext()) {
        maxBy$result = null;
        break maxBy$break;
      }var maxElem = iterator.next();
      if (!iterator.hasNext()) {
        maxBy$result = maxElem;
        break maxBy$break;
      }var maxValue = maxElem.updateId;
      do {
        var e = iterator.next();
        var v = e.updateId;
        if (Kotlin.compareTo(maxValue, v) < 0) {
          maxElem = e;
          maxValue = v;
        }}
       while (iterator.hasNext());
      maxBy$result = maxElem;
    }
     while (false);
    return (tmp$ = maxBy$result) != null ? lastUpdateIdentifier(tmp$) : null;
  }
  function convertWithMediaGroupUpdates$lambda(it) {
    return it.updateId;
  }
  function convertWithMediaGroupUpdates($receiver) {
    var tmp$, tmp$_0;
    var resultUpdates = ArrayList_init();
    var mediaGroups = LinkedHashMap_init();
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var update = tmp$.next();
      var data = Kotlin.isType(tmp$_0 = update.data, MediaGroupMessage) ? tmp$_0 : null;
      if (data == null) {
        resultUpdates.add_11rb$(update);
        continue;
      }if (Kotlin.isType(update, BaseEditMessageUpdate))
        resultUpdates.add_11rb$(toEditMediaGroupUpdate(update));
      else if (Kotlin.isType(update, BaseSentMessageUpdate)) {
        var key = data.mediaGroupId;
        var tmp$_1;
        var value = mediaGroups.get_11rb$(key);
        if (value == null) {
          var answer = ArrayList_init();
          mediaGroups.put_xwzc9p$(key, answer);
          tmp$_1 = answer;
        } else {
          tmp$_1 = value;
        }
        tmp$_1.add_11rb$(update);
      } else
        resultUpdates.add_11rb$(update);
    }
    var $receiver_0 = mediaGroups.values;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
    var tmp$_2;
    tmp$_2 = $receiver_0.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      var tmp$_3;
      destination.add_11rb$((tmp$_3 = toSentMediaGroupUpdate(item)) != null ? resultUpdates.add_11rb$(tmp$_3) : null);
    }
    if (resultUpdates.size > 1) {
      sortWith(resultUpdates, new Comparator$ObjectLiteral(compareBy$lambda(convertWithMediaGroupUpdates$lambda)));
    }return resultUpdates;
  }
  function toSentMediaGroupUpdate$lambda$lambda(it) {
    return it.updateId;
  }
  function toSentMediaGroupUpdate($receiver) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$_0 = Kotlin.isType(tmp$ = $receiver, SentMediaGroupUpdate) ? tmp$ : null) != null)
      tmp$_1 = tmp$_0;
    else {
      var block$result;
      block$break: do {
        var tmp$_2;
        if ($receiver.isEmpty()) {
          block$result = null;
          break block$break;
        }var resultList = sortedWith($receiver, new Comparator$ObjectLiteral_0(compareBy$lambda_0(toSentMediaGroupUpdate$lambda$lambda)));
        tmp$_2 = first($receiver);
        if (Kotlin.isType(tmp$_2, MessageUpdate)) {
          block$result = new MessageMediaGroupUpdate(resultList);
        } else if (Kotlin.isType(tmp$_2, ChannelPostUpdate)) {
          block$result = new ChannelPostMediaGroupUpdate(resultList);
        } else {
          block$result = null;
        }
      }
       while (false);
      tmp$_1 = block$result;
    }
    return tmp$_1;
  }
  function toEditMediaGroupUpdate($receiver) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$_0 = Kotlin.isType(tmp$ = $receiver, EditMediaGroupUpdate) ? tmp$ : null) != null)
      tmp$_1 = tmp$_0;
    else {
      var block$result;
      if (Kotlin.isType($receiver, EditMessageUpdate)) {
        block$result = new EditMessageMediaGroupUpdate($receiver);
      } else if (Kotlin.isType($receiver, EditChannelPostUpdate)) {
        block$result = new EditChannelPostMediaGroupUpdate($receiver);
      } else {
        throw IllegalStateException_init(('Unsupported type of ' + toString(getKClass(BaseEditMessageUpdate).simpleName)).toString());
      }
      tmp$_1 = block$result;
    }
    return tmp$_1;
  }
  var livePeriodDelayMillis;
  function LiveLocation(requestsExecutor, scope, autoCloseTimeDelay, initMessage) {
    this.requestsExecutor_0 = requestsExecutor;
    this.doWhenClose_0 = LiveLocation$doWhenClose$lambda(scope, this);
    this.autoCloseTime_0 = DateTime.Companion.now().plus_fv8bff$(new TimeSpan(autoCloseTimeDelay));
    this.isClosed_jvj9yt$_0 = false;
    this.message_0 = initMessage;
  }
  Object.defineProperty(LiveLocation.prototype, 'leftUntilCloseMillis', {
    get: function () {
      return this.autoCloseTime_0.minus_mw5vjr$(DateTime.Companion.now());
    }
  });
  Object.defineProperty(LiveLocation.prototype, 'isClosed', {
    get: function () {
      return this.isClosed_jvj9yt$_0 || this.leftUntilCloseMillis.millisecondsLong.compareTo_11rb$(L0) < 0;
    },
    set: function (isClosed) {
      this.isClosed_jvj9yt$_0 = isClosed;
    }
  });
  Object.defineProperty(LiveLocation.prototype, 'lastLocation', {
    get: function () {
      return this.message_0.content.location;
    }
  });
  function Coroutine$updateLocation_cf14f1$($this, location_0, replyMarkup_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$location = location_0;
    this.local$replyMarkup = replyMarkup_0;
  }
  Coroutine$updateLocation_cf14f1$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$updateLocation_cf14f1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$updateLocation_cf14f1$.prototype.constructor = Coroutine$updateLocation_cf14f1$;
  Coroutine$updateLocation_cf14f1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$replyMarkup === void 0)
              this.local$replyMarkup = null;
            if (!this.$this.isClosed) {
              this.state_0 = 2;
              this.result_0 = editLiveLocation_4(this.$this.requestsExecutor_0, this.$this.message_0, this.local$location, this.local$replyMarkup, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              throw IllegalStateException_init('LiveLocation is closed'.toString());
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.$this.message_0 = this.result_0;
            return this.$this.lastLocation;
          case 3:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  LiveLocation.prototype.updateLocation_cf14f1$ = function (location_0, replyMarkup_0, continuation_0, suspended) {
    var instance = new Coroutine$updateLocation_cf14f1$(this, location_0, replyMarkup_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  LiveLocation.prototype.close = function () {
    if (this.isClosed) {
      return;
    }this.isClosed = true;
    this.doWhenClose_0();
  };
  function Coroutine$LiveLocation$doWhenClose$lambda$lambda(this$LiveLocation_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$LiveLocation = this$LiveLocation_0;
  }
  Coroutine$LiveLocation$doWhenClose$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$LiveLocation$doWhenClose$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$LiveLocation$doWhenClose$lambda$lambda.prototype.constructor = Coroutine$LiveLocation$doWhenClose$lambda$lambda;
  Coroutine$LiveLocation$doWhenClose$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = stopLiveLocation_1(this.local$this$LiveLocation.requestsExecutor_0, this.local$this$LiveLocation.message_0, void 0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function LiveLocation$doWhenClose$lambda$lambda(this$LiveLocation_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$LiveLocation$doWhenClose$lambda$lambda(this$LiveLocation_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function LiveLocation$doWhenClose$lambda(closure$scope, this$LiveLocation) {
    return function () {
      return launch(closure$scope, void 0, void 0, LiveLocation$doWhenClose$lambda$lambda(this$LiveLocation));
    };
  }
  LiveLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LiveLocation',
    interfaces: [Closeable]
  };
  function Coroutine$startLiveLocation($receiver_0, scope_0, chatId_0, latitude_0, longitude_0, liveTimeMillis_0, disableNotification_0, replyToMessageId_0, replyMarkup_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$liveTimeAsDouble = void 0;
    this.local$$receiver = $receiver_0;
    this.local$scope = scope_0;
    this.local$chatId = chatId_0;
    this.local$latitude = latitude_0;
    this.local$longitude = longitude_0;
    this.local$liveTimeMillis = liveTimeMillis_0;
    this.local$disableNotification = disableNotification_0;
    this.local$replyToMessageId = replyToMessageId_0;
    this.local$replyMarkup = replyMarkup_0;
  }
  Coroutine$startLiveLocation.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$startLiveLocation.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$startLiveLocation.prototype.constructor = Coroutine$startLiveLocation;
  Coroutine$startLiveLocation.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$liveTimeMillis === void 0)
              this.local$liveTimeMillis = livePeriodDelayMillis;
            if (this.local$disableNotification === void 0)
              this.local$disableNotification = false;
            if (this.local$replyToMessageId === void 0)
              this.local$replyToMessageId = null;
            if (this.local$replyMarkup === void 0)
              this.local$replyMarkup = null;
            this.local$liveTimeAsDouble = this.local$liveTimeMillis.toNumber();
            var x = this.local$liveTimeAsDouble / 1000;
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.execute_2kauxl$(new SendLocation(this.local$chatId, this.local$latitude, this.local$longitude, Kotlin.Long.fromNumber(Math_0.ceil(x)), this.local$disableNotification, this.local$replyToMessageId, this.local$replyMarkup), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var locationMessage = this.result_0;
            return new LiveLocation(this.local$$receiver, this.local$scope, this.local$liveTimeAsDouble, locationMessage);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function startLiveLocation($receiver_0, scope_0, chatId_0, latitude_0, longitude_0, liveTimeMillis_0, disableNotification_0, replyToMessageId_0, replyMarkup_0, continuation_0, suspended) {
    var instance = new Coroutine$startLiveLocation($receiver_0, scope_0, chatId_0, latitude_0, longitude_0, liveTimeMillis_0, disableNotification_0, replyToMessageId_0, replyMarkup_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function startLiveLocation_0($receiver, scope, chat, latitude, longitude, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (liveTimeMillis === void 0)
      liveTimeMillis = livePeriodDelayMillis;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return startLiveLocation($receiver, scope, chat.id, latitude, longitude, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function startLiveLocation_1($receiver, scope, chatId, location, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (liveTimeMillis === void 0)
      liveTimeMillis = livePeriodDelayMillis;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return startLiveLocation($receiver, scope, chatId, location.latitude, location.longitude, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function startLiveLocation_2($receiver, scope, chat, location, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (liveTimeMillis === void 0)
      liveTimeMillis = livePeriodDelayMillis;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return startLiveLocation($receiver, scope, chat.id, location.latitude, location.longitude, liveTimeMillis, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function stopPoll($receiver, chatId, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new StopPoll(chatId, messageId, replyMarkup), continuation);
  }
  function stopPoll_0($receiver, chat, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return stopPoll($receiver, chat.id, messageId, replyMarkup, continuation);
  }
  function stopPoll_1($receiver, chatId, message, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return stopPoll($receiver, chatId, message.messageId, replyMarkup, continuation);
  }
  function stopPoll_2($receiver, chat, message, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return stopPoll($receiver, chat.id, message.messageId, replyMarkup, continuation);
  }
  function answerCallbackQuery($receiver, callbackQueryId, text, showAlert, url, cachedTimeSeconds, continuation) {
    if (text === void 0)
      text = null;
    if (showAlert === void 0)
      showAlert = null;
    if (url === void 0)
      url = null;
    if (cachedTimeSeconds === void 0)
      cachedTimeSeconds = null;
    return $receiver.execute_2kauxl$(new AnswerCallbackQuery(callbackQueryId, text, showAlert, url, cachedTimeSeconds), continuation);
  }
  function answerCallbackQuery_0($receiver, callbackQuery, text, showAlert, url, cachedTimeSeconds, continuation) {
    if (text === void 0)
      text = null;
    if (showAlert === void 0)
      showAlert = null;
    if (url === void 0)
      url = null;
    if (cachedTimeSeconds === void 0)
      cachedTimeSeconds = null;
    return answerCallbackQuery($receiver, callbackQuery.id, text, showAlert, url, cachedTimeSeconds, continuation);
  }
  function answerInlineQuery($receiver, inlineQueryID, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter, continuation) {
    if (results === void 0)
      results = emptyList();
    if (cachedTime === void 0)
      cachedTime = null;
    if (isPersonal === void 0)
      isPersonal = null;
    if (nextOffset === void 0)
      nextOffset = null;
    if (switchPmText === void 0)
      switchPmText = null;
    if (switchPmParameter === void 0)
      switchPmParameter = null;
    return $receiver.execute_2kauxl$(new AnswerInlineQuery(inlineQueryID, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter), continuation);
  }
  function answerInlineQuery_0($receiver, inlineQuery, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter, continuation) {
    if (results === void 0)
      results = emptyList();
    if (cachedTime === void 0)
      cachedTime = null;
    if (isPersonal === void 0)
      isPersonal = null;
    if (nextOffset === void 0)
      nextOffset = null;
    if (switchPmText === void 0)
      switchPmText = null;
    if (switchPmParameter === void 0)
      switchPmParameter = null;
    return answerInlineQuery($receiver, inlineQuery.id, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter, continuation);
  }
  function answerPreCheckoutQueryOk($receiver, id, continuation) {
    return $receiver.execute_2kauxl$(new AnswerPreCheckoutQueryOk(id), continuation);
  }
  function answerPreCheckoutQueryOk_0($receiver, preCheckoutQuery, continuation) {
    return answerPreCheckoutQueryOk($receiver, preCheckoutQuery.id, continuation);
  }
  function answerPreCheckoutQueryError($receiver, id, error, continuation) {
    return $receiver.execute_2kauxl$(new AnswerPreCheckoutQueryError(id, error), continuation);
  }
  function answerPreCheckoutQueryError_0($receiver, preCheckoutQuery, error, continuation) {
    return answerPreCheckoutQueryError($receiver, preCheckoutQuery.id, error, continuation);
  }
  function answerShippingQueryOk($receiver, id, shippingOptions, continuation) {
    return $receiver.execute_2kauxl$(new AnswerShippingQueryOk(id, shippingOptions), continuation);
  }
  function answerShippingQueryOk_0($receiver, shippingQuery, shippingOptions, continuation) {
    return answerShippingQueryOk($receiver, shippingQuery.id, shippingOptions, continuation);
  }
  function answerShippingQueryError($receiver, id, error, continuation) {
    return $receiver.execute_2kauxl$(new AnswerShippingQueryError(id, error), continuation);
  }
  function answerShippingQueryError_0($receiver, shippingQuery, error, continuation) {
    return answerShippingQueryError($receiver, shippingQuery.id, error, continuation);
  }
  function getMe_0($receiver, continuation) {
    return $receiver.execute_2kauxl$(bot.GetMe, continuation);
  }
  function getMyCommands($receiver, continuation) {
    return $receiver.execute_2kauxl$(bot.GetMyCommands, continuation);
  }
  function setMyCommands($receiver, commands, continuation) {
    return $receiver.execute_2kauxl$(new SetMyCommands(commands), continuation);
  }
  function exportChatInviteLink($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new ExportChatInviteLink(chatId), continuation);
  }
  function exportChatInviteLink_0($receiver, chat, continuation) {
    return exportChatInviteLink($receiver, chat.id, continuation);
  }
  function leaveChat($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new LeaveChat(chatId), continuation);
  }
  function leaveChat_0($receiver, chat, continuation) {
    return leaveChat($receiver, chat.id, continuation);
  }
  function getChat($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new GetChat(chatId), continuation);
  }
  function getChat_0($receiver, chat, continuation) {
    return getChat($receiver, chat.id, continuation);
  }
  function getChatAdministrators($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new GetChatAdministrators(chatId), continuation);
  }
  function getChatAdministrators_0($receiver, chat, continuation) {
    return getChatAdministrators($receiver, chat.id, continuation);
  }
  function getChatMembersCount($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new GetChatMembersCount(chatId), continuation);
  }
  function getChatMembersCount_0($receiver, chat, continuation) {
    return getChatMembersCount($receiver, chat.id, continuation);
  }
  function getChatMember($receiver, chatId, userId, continuation) {
    return $receiver.execute_2kauxl$(new GetChatMember(chatId, userId), continuation);
  }
  function getChatMember_0($receiver, chat, userId, continuation) {
    return getChatMember($receiver, chat.id, userId, continuation);
  }
  function getChatMember_1($receiver, chatId, user, continuation) {
    return getChatMember($receiver, chatId, user.id, continuation);
  }
  function getChatMember_2($receiver, chat, user, continuation) {
    return getChatMember($receiver, chat.id, user.id, continuation);
  }
  function kickChatMember($receiver, chatId, userId, untilDate, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    return $receiver.execute_2kauxl$(new KickChatMember(chatId, userId, untilDate), continuation);
  }
  function kickChatMember_0($receiver, chat, userId, untilDate, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    return kickChatMember($receiver, chat.id, userId, untilDate, continuation);
  }
  function kickChatMember_1($receiver, chatId, user, untilDate, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    return kickChatMember($receiver, chatId, user.id, untilDate, continuation);
  }
  function kickChatMember_2($receiver, chat, user, untilDate, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    return kickChatMember($receiver, chat.id, user.id, untilDate, continuation);
  }
  function promoteChatMember($receiver, chatId, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (canChangeInfo === void 0)
      canChangeInfo = null;
    if (canPostMessages === void 0)
      canPostMessages = null;
    if (canEditMessages === void 0)
      canEditMessages = null;
    if (canDeleteMessages === void 0)
      canDeleteMessages = null;
    if (canInviteUsers === void 0)
      canInviteUsers = null;
    if (canRestrictMembers === void 0)
      canRestrictMembers = null;
    if (canPinMessages === void 0)
      canPinMessages = null;
    if (canPromoteMembers === void 0)
      canPromoteMembers = null;
    return $receiver.execute_2kauxl$(new PromoteChatMember(chatId, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers), continuation);
  }
  function promoteChatMember_0($receiver, chat, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (canChangeInfo === void 0)
      canChangeInfo = null;
    if (canPostMessages === void 0)
      canPostMessages = null;
    if (canEditMessages === void 0)
      canEditMessages = null;
    if (canDeleteMessages === void 0)
      canDeleteMessages = null;
    if (canInviteUsers === void 0)
      canInviteUsers = null;
    if (canRestrictMembers === void 0)
      canRestrictMembers = null;
    if (canPinMessages === void 0)
      canPinMessages = null;
    if (canPromoteMembers === void 0)
      canPromoteMembers = null;
    return promoteChatMember($receiver, chat.id, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation);
  }
  function promoteChatMember_1($receiver, chatId, user, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (canChangeInfo === void 0)
      canChangeInfo = null;
    if (canPostMessages === void 0)
      canPostMessages = null;
    if (canEditMessages === void 0)
      canEditMessages = null;
    if (canDeleteMessages === void 0)
      canDeleteMessages = null;
    if (canInviteUsers === void 0)
      canInviteUsers = null;
    if (canRestrictMembers === void 0)
      canRestrictMembers = null;
    if (canPinMessages === void 0)
      canPinMessages = null;
    if (canPromoteMembers === void 0)
      canPromoteMembers = null;
    return promoteChatMember($receiver, chatId, user.id, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation);
  }
  function promoteChatMember_2($receiver, chat, user, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (canChangeInfo === void 0)
      canChangeInfo = null;
    if (canPostMessages === void 0)
      canPostMessages = null;
    if (canEditMessages === void 0)
      canEditMessages = null;
    if (canDeleteMessages === void 0)
      canDeleteMessages = null;
    if (canInviteUsers === void 0)
      canInviteUsers = null;
    if (canRestrictMembers === void 0)
      canRestrictMembers = null;
    if (canPinMessages === void 0)
      canPinMessages = null;
    if (canPromoteMembers === void 0)
      canPromoteMembers = null;
    return promoteChatMember($receiver, chat.id, user.id, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, continuation);
  }
  function restrictChatMember($receiver, chatId, userId, untilDate, permissions, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (permissions === void 0)
      permissions = new ChatPermissions();
    return $receiver.execute_2kauxl$(new RestrictChatMember(chatId, userId, untilDate, permissions), continuation);
  }
  function restrictChatMember_0($receiver, chat, userId, untilDate, permissions, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (permissions === void 0)
      permissions = new ChatPermissions();
    return restrictChatMember($receiver, chat.id, userId, untilDate, permissions, continuation);
  }
  function restrictChatMember_1($receiver, chatId, user, untilDate, permissions, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (permissions === void 0)
      permissions = new ChatPermissions();
    return restrictChatMember($receiver, chatId, user.id, untilDate, permissions, continuation);
  }
  function restrictChatMember_2($receiver, chat, user, untilDate, permissions, continuation) {
    if (untilDate === void 0)
      untilDate = null;
    if (permissions === void 0)
      permissions = new ChatPermissions();
    return restrictChatMember($receiver, chat.id, user.id, untilDate, permissions, continuation);
  }
  function setChatAdministratorCustomTitle($receiver, chatId, userId, customTitle, continuation) {
    return $receiver.execute_2kauxl$(new SetChatAdministratorCustomTitle(chatId, userId, customTitle), continuation);
  }
  function setChatAdministratorCustomTitle_0($receiver, chat, userId, customTitle, continuation) {
    return setChatAdministratorCustomTitle($receiver, chat.id, userId, customTitle, continuation);
  }
  function setChatAdministratorCustomTitle_1($receiver, chatId, user, customTitle, continuation) {
    return setChatAdministratorCustomTitle($receiver, chatId, user.id, customTitle, continuation);
  }
  function setChatAdministratorCustomTitle_2($receiver, chat, user, customTitle, continuation) {
    return setChatAdministratorCustomTitle($receiver, chat.id, user.id, customTitle, continuation);
  }
  function unbanChatMember($receiver, chatId, userId, continuation) {
    return $receiver.execute_2kauxl$(new UnbanChatMember(chatId, userId), continuation);
  }
  function unbanChatMember_0($receiver, chat, userId, continuation) {
    return unbanChatMember($receiver, chat.id, userId, continuation);
  }
  function unbanChatMember_1($receiver, chatId, user, continuation) {
    return unbanChatMember($receiver, chatId, user.id, continuation);
  }
  function unbanChatMember_2($receiver, chat, user, continuation) {
    return unbanChatMember($receiver, chat.id, user.id, continuation);
  }
  function deleteChatPhoto($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new DeleteChatPhoto(chatId), continuation);
  }
  function deleteChatPhoto_0($receiver, chat, continuation) {
    return deleteChatPhoto($receiver, chat.id, continuation);
  }
  function pinChatMessage($receiver, chatId, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return $receiver.execute_2kauxl$(new PinChatMessage(chatId, messageId, disableNotification), continuation);
  }
  function pinChatMessage_0($receiver, chat, messageId, disableNotification, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    return pinChatMessage($receiver, chat.id, messageId, disableNotification, continuation);
  }
  function Coroutine$pinChatMessage($receiver_0, message_0, disableNotification_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
    this.local$message = message_0;
    this.local$disableNotification = disableNotification_0;
  }
  Coroutine$pinChatMessage.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$pinChatMessage.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$pinChatMessage.prototype.constructor = Coroutine$pinChatMessage;
  Coroutine$pinChatMessage.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$disableNotification === void 0)
              this.local$disableNotification = false;
            if (Kotlin.isType(this.local$message.chat, PublicChat)) {
              this.state_0 = 2;
              this.result_0 = pinChatMessage(this.local$$receiver, this.local$message.chat.id, this.local$message.messageId, this.local$disableNotification, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              throw IllegalStateException_init('It is possible to pin messages only in non one-to-one chats'.toString());
            }

          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          case 3:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function pinChatMessage_1($receiver_0, message_0, disableNotification_0, continuation_0, suspended) {
    var instance = new Coroutine$pinChatMessage($receiver_0, message_0, disableNotification_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function setChatDescription($receiver, chatId, description, continuation) {
    return $receiver.execute_2kauxl$(new SetChatDescription(chatId, description), continuation);
  }
  function setChatDescription_0($receiver, chat, description, continuation) {
    return setChatDescription($receiver, chat.id, description, continuation);
  }
  function setDefaultChatMembersPermissions($receiver, chatId, permissions, continuation) {
    return $receiver.execute_2kauxl$(new SetChatPermissions(chatId, permissions), continuation);
  }
  function setDefaultChatMembersPermissions_0($receiver, chat, permissions, continuation) {
    return setDefaultChatMembersPermissions($receiver, chat.id, permissions, continuation);
  }
  function setChatPhoto($receiver, chatId, photo, continuation) {
    return $receiver.execute_2kauxl$(new SetChatPhoto(chatId, photo), continuation);
  }
  function setChatPhoto_0($receiver, chat, photo, continuation) {
    return setChatPhoto($receiver, chat.id, photo, continuation);
  }
  function setChatTitle($receiver, chatId, title, continuation) {
    return $receiver.execute_2kauxl$(new SetChatTitle(chatId, title), continuation);
  }
  function setChatTitle_0($receiver, chat, title, continuation) {
    return setChatTitle($receiver, chat.id, title, continuation);
  }
  function unpinChatMessage($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new UnpinChatMessage(chatId), continuation);
  }
  function unpinChatMessage_0($receiver, chat, continuation) {
    return unpinChatMessage($receiver, chat.id, continuation);
  }
  function deleteChatStickerSet($receiver, chatId, continuation) {
    return $receiver.execute_2kauxl$(new DeleteChatStickerSet(chatId), continuation);
  }
  function deleteChatStickerSet_0($receiver, chat, continuation) {
    return deleteChatStickerSet($receiver, chat.id, continuation);
  }
  function setChatStickerSet($receiver, chatId, stickerSetName, continuation) {
    return $receiver.execute_2kauxl$(new SetChatStickerSet(chatId, stickerSetName), continuation);
  }
  function setChatStickerSet_0($receiver, chat, stickerSetName, continuation) {
    return setChatStickerSet($receiver, chat.id, stickerSetName, continuation);
  }
  function editLiveLocation($receiver, chatId, messageId, latitude, longitude, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageLiveLocation(chatId, messageId, latitude, longitude, replyMarkup), continuation);
  }
  function editLiveLocation_0($receiver, chat, messageId, latitude, longitude, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editLiveLocation($receiver, chat.id, messageId, latitude, longitude, replyMarkup, continuation);
  }
  function editLiveLocation_1($receiver, message, latitude, longitude, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editLiveLocation_0($receiver, message.chat, message.messageId, latitude, longitude, replyMarkup, continuation);
  }
  function editLiveLocation_2($receiver, chatId, messageId, location, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageLiveLocation(chatId, messageId, location.latitude, location.longitude, replyMarkup), continuation);
  }
  function editLiveLocation_3($receiver, chat, messageId, location, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editLiveLocation($receiver, chat.id, messageId, location.latitude, location.longitude, replyMarkup, continuation);
  }
  function editLiveLocation_4($receiver, message, location, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editLiveLocation_0($receiver, message.chat, message.messageId, location.latitude, location.longitude, replyMarkup, continuation);
  }
  function editLiveLocation_5($receiver, inlineMessageId, latitude, longitude, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditInlineMessageLiveLocation(inlineMessageId, latitude, longitude, replyMarkup), continuation);
  }
  function editLiveLocation_6($receiver, inlineMessageId, location, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editLiveLocation_5($receiver, inlineMessageId, location.latitude, location.longitude, replyMarkup, continuation);
  }
  function stopLiveLocation($receiver, chatId, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new StopChatMessageLiveLocation(chatId, messageId, replyMarkup), continuation);
  }
  function stopLiveLocation_0($receiver, chat, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return stopLiveLocation($receiver, chat.id, messageId, replyMarkup, continuation);
  }
  function stopLiveLocation_1($receiver, message, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return stopLiveLocation_0($receiver, message.chat, message.messageId, replyMarkup, continuation);
  }
  function stopLiveLocation_2($receiver, inlineMessageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new StopInlineMessageLiveLocation(inlineMessageId, replyMarkup), continuation);
  }
  function editMessageReplyMarkup($receiver, chatId, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageReplyMarkup(chatId, messageId, replyMarkup), continuation);
  }
  function editMessageReplyMarkup_0($receiver, chat, messageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageReplyMarkup($receiver, chat.id, messageId, replyMarkup, continuation);
  }
  function editMessageReplyMarkup_1($receiver, message, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageReplyMarkup($receiver, message.chat.id, message.messageId, replyMarkup, continuation);
  }
  function editMessageReplyMarkup_2($receiver, inlineMessageId, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditInlineMessageReplyMarkup(inlineMessageId, replyMarkup), continuation);
  }
  function editMessageCaption($receiver, chatId, messageId, text, parseMode, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageCaption(chatId, messageId, text, parseMode, replyMarkup), continuation);
  }
  function editMessageCaption_0($receiver, chat, messageId, text, parseMode, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageCaption($receiver, chat.id, messageId, text, parseMode, replyMarkup, continuation);
  }
  function editMessageCaption_1($receiver, message, text, parseMode, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageCaption($receiver, message.chat.id, message.messageId, text, parseMode, replyMarkup, continuation);
  }
  function editMessageCaption_2($receiver, inlineMessageId, text, parseMode, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditInlineMessageCaption(inlineMessageId, text, parseMode, replyMarkup), continuation);
  }
  function editMessageMedia($receiver, chatId, messageId, media, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageMedia(chatId, messageId, media, replyMarkup), continuation);
  }
  function editMessageMedia_0($receiver, chat, messageId, media, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageMedia($receiver, chat.id, messageId, media, replyMarkup, continuation);
  }
  function editMessageMedia_1($receiver, message, media, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageMedia($receiver, message.chat.id, message.messageId, media, replyMarkup, continuation);
  }
  function editMessageCaption_3($receiver, inlineMessageId, media, replyMarkup, continuation) {
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditInlineMessageMedia(inlineMessageId, media, replyMarkup), continuation);
  }
  function editMessageText($receiver, chatId, messageId, text, parseMode, disableWebPagePreview, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditChatMessageText(chatId, messageId, text, parseMode, disableWebPagePreview, replyMarkup), continuation);
  }
  function editMessageText_0($receiver, chat, messageId, text, parseMode, disableWebPagePreview, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageText($receiver, chat.id, messageId, text, parseMode, disableWebPagePreview, replyMarkup, continuation);
  }
  function editMessageText_1($receiver, message, text, parseMode, disableWebPagePreview, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return editMessageText($receiver, message.chat.id, message.messageId, text, parseMode, disableWebPagePreview, replyMarkup, continuation);
  }
  function editMessageText_2($receiver, inlineMessageId, text, parseMode, disableWebPagePreview, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new EditInlineMessageText(inlineMessageId, text, parseMode, disableWebPagePreview, replyMarkup), continuation);
  }
  function getGameScore($receiver, userId, chatId, messageId, continuation) {
    return $receiver.execute_2kauxl$(new GetGameHighScoresByChat(userId, chatId, messageId), continuation);
  }
  function getGameScore_0($receiver, user, chatId, messageId, continuation) {
    return getGameScore($receiver, user.id, chatId, messageId, continuation);
  }
  function getGameScore_1($receiver, userId, chat, messageId, continuation) {
    return getGameScore($receiver, userId, chat.id, messageId, continuation);
  }
  function getGameScore_2($receiver, user, chat, messageId, continuation) {
    return getGameScore($receiver, user.id, chat.id, messageId, continuation);
  }
  function getGameScore_3($receiver, userId, message, continuation) {
    return getGameScore($receiver, userId, message.chat.id, message.messageId, continuation);
  }
  function getGameScore_4($receiver, user, message, continuation) {
    return getGameScore($receiver, user.id, message.chat.id, message.messageId, continuation);
  }
  function getGameScore_5($receiver, userId, inlineMessageId, continuation) {
    return $receiver.execute_2kauxl$(new GetGameHighScoresByInlineMessageId(userId, inlineMessageId), continuation);
  }
  function getGameScore_6($receiver, user, inlineMessageId, continuation) {
    return getGameScore_5($receiver, user.id, inlineMessageId, continuation);
  }
  function setGameScore($receiver, userId, score, chatId, messageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return $receiver.execute_2kauxl$(new SetGameScoreByChatId(userId, score, chatId, messageId, force, disableEditMessage), continuation);
  }
  function setGameScore_0($receiver, user, score, chatId, messageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore($receiver, user.id, score, chatId, messageId, force, disableEditMessage, continuation);
  }
  function setGameScore_1($receiver, userId, score, chat, messageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore($receiver, userId, score, chat.id, messageId, force, disableEditMessage, continuation);
  }
  function setGameScore_2($receiver, user, score, chat, messageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore($receiver, user.id, score, chat.id, messageId, force, disableEditMessage, continuation);
  }
  function setGameScore_3($receiver, userId, score, message, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore($receiver, userId, score, message.chat.id, message.messageId, force, disableEditMessage, continuation);
  }
  function setGameScore_4($receiver, user, score, message, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore($receiver, user.id, score, message.chat.id, message.messageId, force, disableEditMessage, continuation);
  }
  function setGameScore_5($receiver, userId, score, inlineMessageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return $receiver.execute_2kauxl$(new SetGameScoreByInlineMessageId(userId, score, inlineMessageId, force, disableEditMessage), continuation);
  }
  function setGameScore_6($receiver, user, score, inlineMessageId, force, disableEditMessage, continuation) {
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    return setGameScore_5($receiver, user.id, score, inlineMessageId, force, disableEditMessage, continuation);
  }
  function getFileAdditionalInfo($receiver, fileId, continuation) {
    return $receiver.execute_2kauxl$(new GetFile(fileId), continuation);
  }
  function getFileAdditionalInfo_0($receiver, file, continuation) {
    return getFileAdditionalInfo($receiver, file.fileId, continuation);
  }
  function getStickerSet($receiver, name, continuation) {
    return $receiver.execute_2kauxl$(new GetStickerSet(name), continuation);
  }
  function getStickerSet_0($receiver, sticker, continuation) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = sticker.stickerSetName) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init('Sticker must contains stickerSetName to be correctly used in getStickerSet method'.toString());
    }
    return getStickerSet($receiver, tmp$_0, continuation);
  }
  function getUserProfilePhotos($receiver, userId, offset, limit, continuation) {
    if (offset === void 0)
      offset = null;
    if (limit === void 0)
      limit = null;
    return $receiver.execute_2kauxl$(new GetUserProfilePhotos(userId, offset, limit), continuation);
  }
  function getUserProfilePhotos_0($receiver, user, offset, limit, continuation) {
    if (offset === void 0)
      offset = null;
    if (limit === void 0)
      limit = null;
    return getUserProfilePhotos($receiver, user.id, offset, limit, continuation);
  }
  function sendBotAction($receiver, chatId, action, continuation) {
    return $receiver.execute_2kauxl$(new SendAction(chatId, action), continuation);
  }
  function sendBotAction_0($receiver, chat, action, continuation) {
    return sendBotAction($receiver, chat.id, action, continuation);
  }
  function sendActionTyping($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.TypingAction, continuation);
  }
  function sendActionUploadPhoto($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.UploadPhotoAction, continuation);
  }
  function sendActionRecordVideo($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.RecordVideoAction, continuation);
  }
  function sendActionUploadVideo($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.UploadVideoAction, continuation);
  }
  function sendActionRecordAudio($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.RecordAudioAction, continuation);
  }
  function sendActionUploadAudio($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.UploadAudioAction, continuation);
  }
  function sendActionUploadDocument($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.UploadDocumentAction, continuation);
  }
  function sendActionFindLocation($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.FindLocationAction, continuation);
  }
  function sendActionRecordVideoNote($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.RecordVideoNoteAction, continuation);
  }
  function sendActionUploadVideoNote($receiver, chatId, continuation) {
    return sendBotAction($receiver, chatId, actions.UploadVideoNoteAction, continuation);
  }
  function sendActionTyping_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.TypingAction, continuation);
  }
  function sendActionUploadPhoto_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.UploadPhotoAction, continuation);
  }
  function sendActionRecordVideo_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.RecordVideoAction, continuation);
  }
  function sendActionUploadVideo_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.UploadVideoAction, continuation);
  }
  function sendActionRecordAudio_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.RecordAudioAction, continuation);
  }
  function sendActionUploadAudio_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.UploadAudioAction, continuation);
  }
  function sendActionUploadDocument_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.UploadDocumentAction, continuation);
  }
  function sendActionFindLocation_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.FindLocationAction, continuation);
  }
  function sendActionRecordVideoNote_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.RecordVideoNoteAction, continuation);
  }
  function sendActionUploadVideoNote_0($receiver, chat, continuation) {
    return sendBotAction_0($receiver, chat, actions.UploadVideoNoteAction, continuation);
  }
  function sendContact($receiver, chatId, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (lastName === void 0)
      lastName = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendContact(chatId, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendContact_0($receiver, chatId, contact, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendContact_init(chatId, contact, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendContact_1($receiver, chat, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (lastName === void 0)
      lastName = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendContact($receiver, chat.id, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendContact_2($receiver, chat, contact, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendContact_0($receiver, chat.id, contact, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendDice($receiver, chatId, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendDice(chatId, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendDice_0($receiver, chat, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendDice($receiver, chat.id, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendLocation($receiver, chatId, latitude, longitude, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendLocation(chatId, latitude, longitude, void 0, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendLocation_0($receiver, chatId, location, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendLocation($receiver, chatId, location.latitude, location.longitude, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendLocation_1($receiver, chat, latitude, longitude, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendLocation($receiver, chat.id, latitude, longitude, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendLocation_2($receiver, chat, location, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendLocation($receiver, chat.id, location.latitude, location.longitude, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendMessage($receiver, chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendTextMessage(chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendTextMessage($receiver, chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendMessage($receiver, chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendMessage_0($receiver, chat, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendMessage($receiver, chat.id, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendTextMessage_0($receiver, chat, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendTextMessage($receiver, chat.id, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendVenue($receiver, chatId, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (foursquareId === void 0)
      foursquareId = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendVenue(chatId, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVenue_0($receiver, chat, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (foursquareId === void 0)
      foursquareId = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendVenue($receiver, chat.id, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendVenue_1($receiver, chatId, venue, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendVenue_init(chatId, venue, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVenue_2($receiver, chat, venue, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendVenue_1($receiver, chat.id, venue, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendGame($receiver, chatId, gameShortName, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendGame(chatId, gameShortName, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendGame_0($receiver, chat, gameShortName, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendGame($receiver, chat.id, gameShortName, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendGame_1($receiver, chatId, game, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendGame($receiver, chatId, game.title, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendGame_2($receiver, chat, game, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendGame($receiver, chat.id, game.title, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendAnimation($receiver, chatId, animation, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendAnimation(chatId, animation, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendAnimation_0($receiver, chatId, animation, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendAnimation($receiver, chatId, animation.fileId, (tmp$ = animation.thumb) != null ? tmp$.fileId : null, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendAudio($receiver, chatId, audio, thumb, text, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (performer === void 0)
      performer = null;
    if (title === void 0)
      title = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendAudio(chatId, audio, thumb, text, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendAudio_0($receiver, chatId, audio, text, parseMode, title, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (title === void 0)
      title = audio.title;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendAudio($receiver, chatId, audio.fileId, (tmp$ = audio.thumb) != null ? tmp$.fileId : null, text, parseMode, audio.duration, audio.performer, title, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendDocument($receiver, chatId, document, thumb, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendDocument(chatId, document, thumb, text, parseMode, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendDocument_0($receiver, chatId, document, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendDocument($receiver, chatId, document.fileId, (tmp$ = document.thumb) != null ? tmp$.fileId : null, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendMediaGroup($receiver, chatId, media, disableNotification, replyToMessageId, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    return $receiver.execute_2kauxl$(SendMediaGroup(chatId, media, disableNotification, replyToMessageId), continuation);
  }
  function sendMediaGroup_0($receiver, chat, media, disableNotification, replyToMessageId, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    return sendMediaGroup($receiver, chat.id, media, disableNotification, replyToMessageId, continuation);
  }
  function sendPhoto($receiver, chatId, fileId, caption, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendPhoto(chatId, fileId, caption, parseMode, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendSticker($receiver, chatId, sticker, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendSticker(chatId, sticker, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVideo($receiver, chatId, video, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendVideo(chatId, video, thumb, text, parseMode, duration, width, height, null, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVideo_0($receiver, chatId, video, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendVideo($receiver, chatId, video.fileId, (tmp$ = video.thumb) != null ? tmp$.fileId : null, text, parseMode, video.duration, video.width, video.height, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendVideoNote($receiver, chatId, videoNote, thumb, text, parseMode, duration, size, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (size === void 0)
      size = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendVideoNote(chatId, videoNote, thumb, text, parseMode, duration, size, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVideoNote_0($receiver, chatId, videoNote, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendVideoNote($receiver, chatId, videoNote.fileId, (tmp$ = videoNote.thumb) != null ? tmp$.fileId : null, text, parseMode, videoNote.duration, videoNote.width, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendVoice($receiver, chatId, voice, thumb, text, parseMode, duration, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(SendVoice(chatId, voice, thumb, text, parseMode, duration, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendVoice_0($receiver, chatId, voice, text, parseMode, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    return sendVoice($receiver, chatId, voice.fileId, (tmp$ = voice.thumb) != null ? tmp$.fileId : null, text, parseMode, voice.duration, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendInvoice($receiver, chatId, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (providerData === void 0)
      providerData = null;
    if (requireName === void 0)
      requireName = false;
    if (requirePhoneNumber === void 0)
      requirePhoneNumber = false;
    if (requireEmail === void 0)
      requireEmail = false;
    if (requireShippingAddress === void 0)
      requireShippingAddress = false;
    if (shouldSendPhoneNumberToProvider === void 0)
      shouldSendPhoneNumberToProvider = false;
    if (shouldSendEmailToProvider === void 0)
      shouldSendEmailToProvider = false;
    if (priceDependOnShipAddress === void 0)
      priceDependOnShipAddress = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendInvoice(chatId, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendInvoice_0($receiver, user, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (providerData === void 0)
      providerData = null;
    if (requireName === void 0)
      requireName = false;
    if (requirePhoneNumber === void 0)
      requirePhoneNumber = false;
    if (requireEmail === void 0)
      requireEmail = false;
    if (requireShippingAddress === void 0)
      requireShippingAddress = false;
    if (shouldSendPhoneNumberToProvider === void 0)
      shouldSendPhoneNumberToProvider = false;
    if (shouldSendEmailToProvider === void 0)
      shouldSendEmailToProvider = false;
    if (priceDependOnShipAddress === void 0)
      priceDependOnShipAddress = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendInvoice($receiver, user.id, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendRegularPoll($receiver, chatId, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isAnonymous === void 0)
      isAnonymous = true;
    if (isClosed === void 0)
      isClosed = false;
    if (allowMultipleAnswers === void 0)
      allowMultipleAnswers = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendRegularPoll(chatId, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendRegularPoll_0($receiver, chatId, poll, isClosed, question, options, isAnonymous, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isClosed === void 0)
      isClosed = false;
    if (question === void 0)
      question = poll.question;
    if (options === void 0) {
      var $receiver_0 = poll.options;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.text);
      }
      options = destination;
    }if (isAnonymous === void 0)
      isAnonymous = poll.isAnonymous;
    if (allowMultipleAnswers === void 0)
      allowMultipleAnswers = poll.allowMultipleAnswers;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendRegularPoll(chatId, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendRegularPoll_1($receiver, chat, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isAnonymous === void 0)
      isAnonymous = true;
    if (isClosed === void 0)
      isClosed = false;
    if (allowMultipleAnswers === void 0)
      allowMultipleAnswers = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendRegularPoll($receiver, chat.id, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendRegularPoll_2($receiver, chat, poll, isClosed, question, options, isAnonymous, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isClosed === void 0)
      isClosed = false;
    if (question === void 0)
      question = poll.question;
    if (options === void 0) {
      var $receiver_0 = poll.options;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.text);
      }
      options = destination;
    }if (isAnonymous === void 0)
      isAnonymous = poll.isAnonymous;
    if (allowMultipleAnswers === void 0)
      allowMultipleAnswers = poll.allowMultipleAnswers;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendRegularPoll($receiver, chat.id, question, options, isAnonymous, isClosed, allowMultipleAnswers, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendQuizPoll($receiver, chatId, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isAnonymous === void 0)
      isAnonymous = true;
    if (isClosed === void 0)
      isClosed = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendQuizPoll(chatId, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendQuizPoll_0($receiver, chat, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup, continuation) {
    if (isAnonymous === void 0)
      isAnonymous = true;
    if (isClosed === void 0)
      isClosed = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendQuizPoll($receiver, chat.id, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function sendQuizPoll_1($receiver, chatId, isClosed, quizPoll, question, options, correctOptionId, isAnonymous, disableNotification, replyToMessageId, replyMarkup, continuation) {
    var tmp$;
    if (isClosed === void 0)
      isClosed = false;
    if (question === void 0)
      question = quizPoll.question;
    if (options === void 0) {
      var $receiver_0 = quizPoll.options;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$_0;
      tmp$_0 = $receiver_0.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(item.text);
      }
      options = destination;
    }if (correctOptionId === void 0) {
      var tmp$_1;
      if ((tmp$ = quizPoll.correctOptionId) != null)
        tmp$_1 = tmp$;
      else {
        throw IllegalStateException_init('Correct option ID must be provided by income QuizPoll or by developer'.toString());
      }
      correctOptionId = tmp$_1;
    }if (isAnonymous === void 0)
      isAnonymous = quizPoll.isAnonymous;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return $receiver.execute_2kauxl$(new SendQuizPoll(chatId, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup), continuation);
  }
  function sendQuizPoll_2($receiver, chat, isClosed, quizPoll, question, options, correctOptionId, isAnonymous, disableNotification, replyToMessageId, replyMarkup, continuation) {
    var tmp$;
    if (isClosed === void 0)
      isClosed = false;
    if (question === void 0)
      question = quizPoll.question;
    if (options === void 0) {
      var $receiver_0 = quizPoll.options;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$_0;
      tmp$_0 = $receiver_0.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        destination.add_11rb$(item.text);
      }
      options = destination;
    }if (correctOptionId === void 0) {
      var tmp$_1;
      if ((tmp$ = quizPoll.correctOptionId) != null)
        tmp$_1 = tmp$;
      else {
        throw IllegalStateException_init('Correct option ID must be provided by income QuizPoll or by developer'.toString());
      }
      correctOptionId = tmp$_1;
    }if (isAnonymous === void 0)
      isAnonymous = quizPoll.isAnonymous;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return sendQuizPoll($receiver, chat.id, question, options, correctOptionId, isAnonymous, isClosed, disableNotification, replyToMessageId, replyMarkup, continuation);
  }
  function addAnimatedStickerToSet($receiver, userId, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(AddAnimatedStickerToSet(userId, stickerSetName, sticker, emojis, maskPosition), continuation);
  }
  function addAnimatedStickerToSet_0($receiver, userId, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(AddAnimatedStickerToSet(userId, stickerSetName, sticker, emojis, maskPosition), continuation);
  }
  function addAnimatedStickerToSet_1($receiver, user, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet($receiver, user.id, stickerSetName, sticker, emojis, maskPosition, continuation);
  }
  function addAnimatedStickerToSet_2($receiver, user, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet_0($receiver, user.id, stickerSetName, sticker, emojis, maskPosition, continuation);
  }
  function addAnimatedStickerToSet_3($receiver, userId, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet($receiver, userId, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addAnimatedStickerToSet_4($receiver, userId, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet_0($receiver, userId, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addAnimatedStickerToSet_5($receiver, user, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet($receiver, user.id, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addAnimatedStickerToSet_6($receiver, user, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addAnimatedStickerToSet_0($receiver, user.id, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet($receiver, userId, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(AddStaticStickerToSet(userId, stickerSetName, sticker, emojis, maskPosition), continuation);
  }
  function addStaticStickerToSet_0($receiver, userId, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(AddStaticStickerToSet(userId, stickerSetName, sticker, emojis, maskPosition), continuation);
  }
  function addStaticStickerToSet_1($receiver, user, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet($receiver, user.id, stickerSetName, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet_2($receiver, user, stickerSetName, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet_0($receiver, user.id, stickerSetName, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet_3($receiver, userId, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet($receiver, userId, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet_4($receiver, userId, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet_0($receiver, userId, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet_5($receiver, user, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet($receiver, user.id, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function addStaticStickerToSet_6($receiver, user, stickerSet, sticker, emojis, maskPosition, continuation) {
    if (maskPosition === void 0)
      maskPosition = null;
    return addStaticStickerToSet_0($receiver, user.id, stickerSet.name, sticker, emojis, maskPosition, continuation);
  }
  function createNewAnimatedStickerSet($receiver, userId, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(CreateNewAnimatedStickerSet(userId, name, sticker, emojis, containsMasks, maskPosition), continuation);
  }
  function createNewAnimatedStickerSet_0($receiver, userId, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(CreateNewAnimatedStickerSet(userId, name, sticker, emojis, containsMasks, maskPosition), continuation);
  }
  function createNewAnimatedStickerSet_1($receiver, user, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return createNewAnimatedStickerSet($receiver, user.id, name, sticker, emojis, containsMasks, maskPosition, continuation);
  }
  function createNewAnimatedStickerSet_2($receiver, user, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return createNewAnimatedStickerSet_0($receiver, user.id, name, sticker, emojis, containsMasks, maskPosition, continuation);
  }
  function createNewStaticStickerSet($receiver, userId, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(CreateNewStaticStickerSet(userId, name, sticker, emojis, containsMasks, maskPosition), continuation);
  }
  function createNewStaticStickerSet_0($receiver, userId, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return $receiver.execute_2kauxl$(CreateNewStaticStickerSet(userId, name, sticker, emojis, containsMasks, maskPosition), continuation);
  }
  function createNewStaticStickerSet_1($receiver, user, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return createNewStaticStickerSet($receiver, user.id, name, sticker, emojis, containsMasks, maskPosition, continuation);
  }
  function createNewStaticStickerSet_2($receiver, user, name, sticker, emojis, containsMasks, maskPosition, continuation) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    return createNewStaticStickerSet_0($receiver, user.id, name, sticker, emojis, containsMasks, maskPosition, continuation);
  }
  function deleteStickerFromSet($receiver, sticker, continuation) {
    return $receiver.execute_2kauxl$(new DeleteStickerFromSet(sticker), continuation);
  }
  function deleteStickerFromSet_0($receiver, sticker, continuation) {
    return deleteStickerFromSet($receiver, sticker.fileId, continuation);
  }
  function setStickerPositionInSet($receiver, sticker, position, continuation) {
    return $receiver.execute_2kauxl$(new SetStickerPositionInSet(sticker, position), continuation);
  }
  function setStickerPositionInSet_0($receiver, sticker, position, continuation) {
    return setStickerPositionInSet($receiver, sticker.fileId, position, continuation);
  }
  function setStickerSetThumb($receiver, userId, thumbSetName, thumb, continuation) {
    return $receiver.execute_2kauxl$(new SetStickerSetThumb(userId, thumbSetName, thumb), continuation);
  }
  function setStickerSetThumb_0($receiver, userId, thumbSetName, thumb, continuation) {
    return $receiver.execute_2kauxl$(SetStickerSetThumb_0(userId, thumbSetName, thumb), continuation);
  }
  function setStickerSetThumb_1($receiver, user, thumbSetName, thumb, continuation) {
    return setStickerSetThumb($receiver, user.id, thumbSetName, thumb, continuation);
  }
  function setStickerSetThumb_2($receiver, user, thumbSetName, thumb, continuation) {
    return setStickerSetThumb_0($receiver, user.id, thumbSetName, thumb, continuation);
  }
  function setStickerSetThumb_3($receiver, userId, thumbSet, thumb, continuation) {
    return setStickerSetThumb($receiver, userId, thumbSet.name, thumb, continuation);
  }
  function setStickerSetThumb_4($receiver, userId, thumbSet, thumb, continuation) {
    return setStickerSetThumb_0($receiver, userId, thumbSet.name, thumb, continuation);
  }
  function setStickerSetThumb_5($receiver, user, thumbSet, thumb, continuation) {
    return setStickerSetThumb($receiver, user.id, thumbSet.name, thumb, continuation);
  }
  function setStickerSetThumb_6($receiver, user, thumbSet, thumb, continuation) {
    return setStickerSetThumb_0($receiver, user.id, thumbSet.name, thumb, continuation);
  }
  function uploadStickerFile($receiver, userId, sticker, continuation) {
    return $receiver.execute_2kauxl$(new UploadStickerFile(userId, sticker), continuation);
  }
  function uploadStickerFile_0($receiver, user, sticker, continuation) {
    return $receiver.execute_2kauxl$(new UploadStickerFile(user.id, sticker), continuation);
  }
  function Coroutine$startGettingOfUpdates$lambda$lambda$lambda(closure$updates_0, closure$updatesReceiver_0, closure$lastUpdateIdentifier_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$updates = closure$updates_0;
    this.local$closure$updatesReceiver = closure$updatesReceiver_0;
    this.local$closure$lastUpdateIdentifier = closure$lastUpdateIdentifier_0;
    this.local$tmp$ = void 0;
    this.local$update = void 0;
  }
  Coroutine$startGettingOfUpdates$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$startGettingOfUpdates$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$startGettingOfUpdates$lambda$lambda$lambda.prototype.constructor = Coroutine$startGettingOfUpdates$lambda$lambda$lambda;
  Coroutine$startGettingOfUpdates$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.local$closure$updates.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            this.local$update = this.local$tmp$.next();
            this.state_0 = 3;
            this.result_0 = this.local$closure$updatesReceiver(this.local$update, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$closure$lastUpdateIdentifier.v = lastUpdateIdentifier(this.local$update);
            this.state_0 = 2;
            continue;
          case 4:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function startGettingOfUpdates$lambda$lambda$lambda(closure$updates_0, closure$updatesReceiver_0, closure$lastUpdateIdentifier_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$startGettingOfUpdates$lambda$lambda$lambda(closure$updates_0, closure$updatesReceiver_0, closure$lastUpdateIdentifier_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$startGettingOfUpdates$lambda$lambda(closure$lastUpdateIdentifier_0, closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$lastUpdateIdentifier = closure$lastUpdateIdentifier_0;
    this.local$closure$timeoutSeconds = closure$timeoutSeconds_0;
    this.local$closure$allowedUpdates = closure$allowedUpdates_0;
    this.local$this$startGettingOfUpdates = this$startGettingOfUpdates_0;
    this.local$closure$updatesReceiver = closure$updatesReceiver_0;
  }
  Coroutine$startGettingOfUpdates$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$startGettingOfUpdates$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$startGettingOfUpdates$lambda$lambda.prototype.constructor = Coroutine$startGettingOfUpdates$lambda$lambda;
  Coroutine$startGettingOfUpdates$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            tmp$_0 = (tmp$ = this.local$closure$lastUpdateIdentifier.v) != null ? tmp$.add(Kotlin.Long.fromInt(1)) : null;
            this.state_0 = 2;
            this.result_0 = getUpdates(this.local$this$startGettingOfUpdates, tmp$_0, void 0, this.local$closure$timeoutSeconds, this.local$closure$allowedUpdates, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var originalUpdates = this.result_0;
            var block$result;
            var converted = convertWithMediaGroupUpdates(originalUpdates);
            if (originalUpdates.size === types.getUpdatesLimit.last && Kotlin.isType(last(converted), SentMediaGroupUpdate)) {
              block$result = minus(converted, last(converted));
            } else {
              block$result = converted;
            }

            var updates = block$result;
            this.state_0 = 3;
            this.result_0 = supervisorScope(startGettingOfUpdates$lambda$lambda$lambda(updates, this.local$closure$updatesReceiver, this.local$closure$lastUpdateIdentifier), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function startGettingOfUpdates$lambda$lambda(closure$lastUpdateIdentifier_0, closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$startGettingOfUpdates$lambda$lambda(closure$lastUpdateIdentifier_0, closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$startGettingOfUpdates$lambda(closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0, closure$exceptionsHandler_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 15;
    this.local$closure$timeoutSeconds = closure$timeoutSeconds_0;
    this.local$closure$allowedUpdates = closure$allowedUpdates_0;
    this.local$this$startGettingOfUpdates = this$startGettingOfUpdates_0;
    this.local$closure$updatesReceiver = closure$updatesReceiver_0;
    this.local$closure$exceptionsHandler = closure$exceptionsHandler_0;
    this.local$lastUpdateIdentifier = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$startGettingOfUpdates$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$startGettingOfUpdates$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$startGettingOfUpdates$lambda.prototype.constructor = Coroutine$startGettingOfUpdates$lambda;
  Coroutine$startGettingOfUpdates$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$lastUpdateIdentifier = {v: null};
            this.state_0 = 1;
            continue;
          case 1:
            if (!get_isActive(this.local$$receiver)) {
              this.state_0 = 16;
              continue;
            }
            this.exceptionState_0 = 3;
            this.state_0 = 2;
            this.result_0 = supervisorScope(startGettingOfUpdates$lambda$lambda(this.local$lastUpdateIdentifier, this.local$closure$timeoutSeconds, this.local$closure$allowedUpdates, this.local$this$startGettingOfUpdates, this.local$closure$updatesReceiver), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.exceptionState_0 = 15;
            this.state_0 = 14;
            continue;
          case 3:
            this.exceptionState_0 = 15;
            var e = this.exception_0;
            if (Kotlin.isType(e, HttpRequestTimeoutException)) {
              if (this.local$closure$exceptionsHandler != null) {
                this.state_0 = 11;
                this.result_0 = this.local$closure$exceptionsHandler(e, this);
                if (this.result_0 === COROUTINE_SUSPENDED)
                  return COROUTINE_SUSPENDED;
                continue;
              } else {
                this.result_0 = null;
                this.state_0 = 12;
                continue;
              }
            } else {
              if (Kotlin.isType(e, RequestException)) {
                if (this.local$closure$exceptionsHandler != null) {
                  this.state_0 = 7;
                  this.result_0 = this.local$closure$exceptionsHandler(e, this);
                  if (this.result_0 === COROUTINE_SUSPENDED)
                    return COROUTINE_SUSPENDED;
                  continue;
                } else {
                  this.result_0 = null;
                  this.state_0 = 8;
                  continue;
                }
              } else {
                if (Kotlin.isType(e, Exception)) {
                  if (this.local$closure$exceptionsHandler != null) {
                    this.state_0 = 4;
                    this.result_0 = this.local$closure$exceptionsHandler(e, this);
                    if (this.result_0 === COROUTINE_SUSPENDED)
                      return COROUTINE_SUSPENDED;
                    continue;
                  } else {
                    this.result_0 = null;
                    this.state_0 = 5;
                    continue;
                  }
                } else {
                  throw e;
                }
              }
            }

          case 4:
            this.state_0 = 5;
            continue;
          case 5:
            this.state_0 = 6;
            continue;
          case 6:
            this.state_0 = 10;
            continue;
          case 7:
            this.state_0 = 8;
            continue;
          case 8:
            this.state_0 = 9;
            this.result_0 = delay(L1000, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 9:
            this.state_0 = 10;
            continue;
          case 10:
            this.state_0 = 13;
            continue;
          case 11:
            this.state_0 = 12;
            continue;
          case 12:
            this.state_0 = 13;
            continue;
          case 13:
            this.state_0 = 14;
            continue;
          case 14:
            this.state_0 = 1;
            continue;
          case 15:
            throw this.exception_0;
          case 16:
            return Unit;
          default:this.state_0 = 15;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 15) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function startGettingOfUpdates$lambda(closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0, closure$exceptionsHandler_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$startGettingOfUpdates$lambda(closure$timeoutSeconds_0, closure$allowedUpdates_0, this$startGettingOfUpdates_0, closure$updatesReceiver_0, closure$exceptionsHandler_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function startGettingOfUpdates($receiver, timeoutSeconds, scope, exceptionsHandler, allowedUpdates, updatesReceiver) {
    if (timeoutSeconds === void 0)
      timeoutSeconds = 30;
    if (scope === void 0)
      scope = CoroutineScope(coroutines.Dispatchers.Default);
    if (exceptionsHandler === void 0)
      exceptionsHandler = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    return launch(scope, void 0, void 0, startGettingOfUpdates$lambda(timeoutSeconds, allowedUpdates, $receiver, updatesReceiver, exceptionsHandler));
  }
  function startGettingFlowsUpdates$lambda($receiver) {
    return Unit;
  }
  function startGettingFlowsUpdates($receiver, timeoutSeconds, scope, exceptionsHandler, flowsUpdatesFilterUpdatesKeeperCount, flowUpdatesPreset) {
    if (timeoutSeconds === void 0)
      timeoutSeconds = 30;
    if (scope === void 0)
      scope = CoroutineScope(coroutines.Dispatchers.Default);
    if (exceptionsHandler === void 0)
      exceptionsHandler = null;
    if (flowsUpdatesFilterUpdatesKeeperCount === void 0)
      flowsUpdatesFilterUpdatesKeeperCount = 64;
    if (flowUpdatesPreset === void 0)
      flowUpdatesPreset = startGettingFlowsUpdates$lambda;
    var $receiver_0 = new FlowsUpdatesFilter(flowsUpdatesFilterUpdatesKeeperCount);
    flowUpdatesPreset($receiver_0);
    startGettingOfUpdates($receiver, timeoutSeconds, scope, exceptionsHandler, $receiver_0.allowedUpdates, $receiver_0.asUpdateReceiver);
    return $receiver_0;
  }
  function startGettingOfUpdates_0($receiver, updatesFilter, timeoutSeconds, exceptionsHandler, scope) {
    if (timeoutSeconds === void 0)
      timeoutSeconds = 30;
    if (exceptionsHandler === void 0)
      exceptionsHandler = null;
    if (scope === void 0)
      scope = CoroutineScope(coroutines.Dispatchers.Default);
    return startGettingOfUpdates($receiver, timeoutSeconds, scope, exceptionsHandler, updatesFilter.allowedUpdates, updatesFilter.asUpdateReceiver);
  }
  function startGettingOfUpdates_1($receiver, messageCallback, messageMediaGroupCallback, editedMessageCallback, editedMessageMediaGroupCallback, channelPostCallback, channelPostMediaGroupCallback, editedChannelPostCallback, editedChannelPostMediaGroupCallback, chosenInlineResultCallback, inlineQueryCallback, callbackQueryCallback, shippingQueryCallback, preCheckoutQueryCallback, pollCallback, pollAnswerCallback, timeoutSeconds, exceptionsHandler, scope) {
    if (messageCallback === void 0)
      messageCallback = null;
    if (messageMediaGroupCallback === void 0)
      messageMediaGroupCallback = null;
    if (editedMessageCallback === void 0)
      editedMessageCallback = null;
    if (editedMessageMediaGroupCallback === void 0)
      editedMessageMediaGroupCallback = null;
    if (channelPostCallback === void 0)
      channelPostCallback = null;
    if (channelPostMediaGroupCallback === void 0)
      channelPostMediaGroupCallback = null;
    if (editedChannelPostCallback === void 0)
      editedChannelPostCallback = null;
    if (editedChannelPostMediaGroupCallback === void 0)
      editedChannelPostMediaGroupCallback = null;
    if (chosenInlineResultCallback === void 0)
      chosenInlineResultCallback = null;
    if (inlineQueryCallback === void 0)
      inlineQueryCallback = null;
    if (callbackQueryCallback === void 0)
      callbackQueryCallback = null;
    if (shippingQueryCallback === void 0)
      shippingQueryCallback = null;
    if (preCheckoutQueryCallback === void 0)
      preCheckoutQueryCallback = null;
    if (pollCallback === void 0)
      pollCallback = null;
    if (pollAnswerCallback === void 0)
      pollAnswerCallback = null;
    if (timeoutSeconds === void 0)
      timeoutSeconds = 30;
    if (exceptionsHandler === void 0)
      exceptionsHandler = null;
    if (scope === void 0)
      scope = coroutines.GlobalScope;
    return startGettingOfUpdates_0($receiver, new SimpleUpdatesFilter(messageCallback, messageMediaGroupCallback, editedMessageCallback, editedMessageMediaGroupCallback, channelPostCallback, channelPostMediaGroupCallback, editedChannelPostCallback, editedChannelPostMediaGroupCallback, chosenInlineResultCallback, inlineQueryCallback, callbackQueryCallback, shippingQueryCallback, preCheckoutQueryCallback, pollCallback, pollAnswerCallback), timeoutSeconds, exceptionsHandler, scope);
  }
  function startGettingOfUpdates_2($receiver, messageCallback, mediaGroupCallback, editedMessageCallback, channelPostCallback, editedChannelPostCallback, chosenInlineResultCallback, inlineQueryCallback, callbackQueryCallback, shippingQueryCallback, preCheckoutQueryCallback, pollCallback, pollAnswerCallback, timeoutSeconds, exceptionsHandler, scope) {
    if (messageCallback === void 0)
      messageCallback = null;
    if (mediaGroupCallback === void 0)
      mediaGroupCallback = null;
    if (editedMessageCallback === void 0)
      editedMessageCallback = null;
    if (channelPostCallback === void 0)
      channelPostCallback = null;
    if (editedChannelPostCallback === void 0)
      editedChannelPostCallback = null;
    if (chosenInlineResultCallback === void 0)
      chosenInlineResultCallback = null;
    if (inlineQueryCallback === void 0)
      inlineQueryCallback = null;
    if (callbackQueryCallback === void 0)
      callbackQueryCallback = null;
    if (shippingQueryCallback === void 0)
      shippingQueryCallback = null;
    if (preCheckoutQueryCallback === void 0)
      preCheckoutQueryCallback = null;
    if (pollCallback === void 0)
      pollCallback = null;
    if (pollAnswerCallback === void 0)
      pollAnswerCallback = null;
    if (timeoutSeconds === void 0)
      timeoutSeconds = 30;
    if (exceptionsHandler === void 0)
      exceptionsHandler = null;
    if (scope === void 0)
      scope = CoroutineScope(coroutines.Dispatchers.Default);
    return startGettingOfUpdates_1($receiver, messageCallback, mediaGroupCallback, editedMessageCallback, mediaGroupCallback, channelPostCallback, mediaGroupCallback, editedChannelPostCallback, mediaGroupCallback, chosenInlineResultCallback, inlineQueryCallback, callbackQueryCallback, shippingQueryCallback, preCheckoutQueryCallback, pollCallback, pollAnswerCallback, timeoutSeconds, exceptionsHandler, scope);
  }
  function deleteWebhook($receiver, continuation) {
    return $receiver.execute_2kauxl$(new DeleteWebhook(), continuation);
  }
  function getWebhookInfo($receiver, continuation) {
    return $receiver.execute_2kauxl$(new GetWebhookInfo(), continuation);
  }
  function setWebhookInfo($receiver, url, certificate, maxAllowedConnections, allowedUpdates, continuation) {
    if (maxAllowedConnections === void 0)
      maxAllowedConnections = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    return $receiver.execute_2kauxl$(SetWebhook(url, certificate, maxAllowedConnections, allowedUpdates), continuation);
  }
  function setWebhookInfo_0($receiver, url, certificate, maxAllowedConnections, allowedUpdates, continuation) {
    if (maxAllowedConnections === void 0)
      maxAllowedConnections = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    return $receiver.execute_2kauxl$(SetWebhook(url, certificate, maxAllowedConnections, allowedUpdates), continuation);
  }
  var package$com = _.com || (_.com = {});
  var package$github = package$com.github || (package$com.github = {});
  var package$insanusmokrassar = package$github.insanusmokrassar || (package$github.insanusmokrassar = {});
  var package$TelegramBotAPI = package$insanusmokrassar.TelegramBotAPI || (package$insanusmokrassar.TelegramBotAPI = {});
  var package$extensions = package$TelegramBotAPI.extensions || (package$TelegramBotAPI.extensions = {});
  var package$api = package$extensions.api || (package$extensions.api = {});
  package$api.deleteMessage_3yyn9y$ = deleteMessage;
  package$api.deleteMessage_a5ivsg$ = deleteMessage_0;
  package$api.deleteMessage_h3e8hh$ = deleteMessage_1;
  package$api.delete_c6vklf$ = delete_0;
  package$api.forwardMessage_xmgtnx$ = forwardMessage;
  package$api.forwardMessage_x0k4rx$ = forwardMessage_0;
  package$api.forwardMessage_vhfsrf$ = forwardMessage_1;
  package$api.forwardMessage_w3dkzv$ = forwardMessage_2;
  package$api.forwardMessage_1u4a1s$ = forwardMessage_3;
  package$api.forwardMessage_4w8scm$ = forwardMessage_4;
  package$api.getMe_e6cma1$ = getMe;
  package$api.getUpdates_5z2q7a$ = getUpdates;
  package$api.getUpdates_93hiic$ = getUpdates_0;
  var package$InternalUtils = package$api.InternalUtils || (package$api.InternalUtils = {});
  package$InternalUtils.lastUpdateIdentifier_s40vmy$ = lastUpdateIdentifier;
  package$InternalUtils.lastUpdateIdentifier_jybzy5$ = lastUpdateIdentifier_0;
  package$InternalUtils.convertWithMediaGroupUpdates_jybzy5$ = convertWithMediaGroupUpdates;
  package$InternalUtils.toSentMediaGroupUpdate_fkdy4x$ = toSentMediaGroupUpdate;
  package$InternalUtils.toEditMediaGroupUpdate_dmziba$ = toEditMediaGroupUpdate;
  package$api.LiveLocation = LiveLocation;
  package$api.startLiveLocation_8mhs75$ = startLiveLocation;
  package$api.startLiveLocation_yf7bi5$ = startLiveLocation_0;
  package$api.startLiveLocation_oty65j$ = startLiveLocation_1;
  package$api.startLiveLocation_ye1nxz$ = startLiveLocation_2;
  package$api.stopPoll_tsjbl$ = stopPoll;
  package$api.stopPoll_57vmuv$ = stopPoll_0;
  package$api.stopPoll_kpip9u$ = stopPoll_1;
  package$api.stopPoll_qco55m$ = stopPoll_2;
  var package$answers = package$api.answers || (package$api.answers = {});
  package$answers.answerCallbackQuery_haj95s$ = answerCallbackQuery;
  package$answers.answerCallbackQuery_rwdww7$ = answerCallbackQuery_0;
  package$answers.answerInlineQuery_3h2emp$ = answerInlineQuery;
  package$answers.answerInlineQuery_tpxtj7$ = answerInlineQuery_0;
  var package$payments = package$answers.payments || (package$answers.payments = {});
  package$payments.answerPreCheckoutQueryOk_mu3aqh$ = answerPreCheckoutQueryOk;
  package$payments.answerPreCheckoutQueryOk_x6fwa0$ = answerPreCheckoutQueryOk_0;
  package$payments.answerPreCheckoutQueryError_ph79s7$ = answerPreCheckoutQueryError;
  package$payments.answerPreCheckoutQueryError_b6hanu$ = answerPreCheckoutQueryError_0;
  package$payments.answerShippingQueryOk_7fe7yd$ = answerShippingQueryOk;
  package$payments.answerShippingQueryOk_ktp66n$ = answerShippingQueryOk_0;
  package$payments.answerShippingQueryError_ph79s7$ = answerShippingQueryError;
  package$payments.answerShippingQueryError_d7ex4t$ = answerShippingQueryError_0;
  var package$bot = package$api.bot || (package$api.bot = {});
  package$bot.getMe_e6cma1$ = getMe_0;
  package$bot.getMyCommands_e6cma1$ = getMyCommands;
  package$bot.setMyCommands_cwbqu1$ = setMyCommands;
  var package$chat = package$api.chat || (package$api.chat = {});
  package$chat.exportChatInviteLink_mabzdz$ = exportChatInviteLink;
  package$chat.exportChatInviteLink_c7v0u4$ = exportChatInviteLink_0;
  package$chat.leaveChat_mabzdz$ = leaveChat;
  package$chat.leaveChat_c7v0u4$ = leaveChat_0;
  var package$get = package$chat.get || (package$chat.get = {});
  package$get.getChat_mabzdz$ = getChat;
  package$get.getChat_783f3n$ = getChat_0;
  package$get.getChatAdministrators_mabzdz$ = getChatAdministrators;
  package$get.getChatAdministrators_c7v0u4$ = getChatAdministrators_0;
  package$get.getChatMembersCount_mabzdz$ = getChatMembersCount;
  package$get.getChatMembersCount_c7v0u4$ = getChatMembersCount_0;
  var package$members = package$chat.members || (package$chat.members = {});
  package$members.getChatMember_z7vlzj$ = getChatMember;
  package$members.getChatMember_iejr3m$ = getChatMember_0;
  package$members.getChatMember_vn52vb$ = getChatMember_1;
  package$members.getChatMember_mv892i$ = getChatMember_2;
  package$members.kickChatMember_1hil0i$ = kickChatMember;
  package$members.kickChatMember_7tx5b9$ = kickChatMember_0;
  package$members.kickChatMember_ip3wi4$ = kickChatMember_1;
  package$members.kickChatMember_onccnx$ = kickChatMember_2;
  package$members.promoteChatMember_66gwy$ = promoteChatMember;
  package$members.promoteChatMember_tvgtjv$ = promoteChatMember_0;
  package$members.promoteChatMember_rosmt0$ = promoteChatMember_1;
  package$members.promoteChatMember_r74yw3$ = promoteChatMember_2;
  package$members.restrictChatMember_ue23uf$ = restrictChatMember;
  package$members.restrictChatMember_xt8t1o$ = restrictChatMember_0;
  package$members.restrictChatMember_gtmyh9$ = restrictChatMember_1;
  package$members.restrictChatMember_zhbz7g$ = restrictChatMember_2;
  package$members.setChatAdministratorCustomTitle_ltamnh$ = setChatAdministratorCustomTitle;
  package$members.setChatAdministratorCustomTitle_2nyyro$ = setChatAdministratorCustomTitle_0;
  package$members.setChatAdministratorCustomTitle_idk3nv$ = setChatAdministratorCustomTitle_1;
  package$members.setChatAdministratorCustomTitle_g1tvo$ = setChatAdministratorCustomTitle_2;
  package$members.unbanChatMember_z7vlzj$ = unbanChatMember;
  package$members.unbanChatMember_iejr3m$ = unbanChatMember_0;
  package$members.unbanChatMember_vn52vb$ = unbanChatMember_1;
  package$members.unbanChatMember_mv892i$ = unbanChatMember_2;
  var package$modify = package$chat.modify || (package$chat.modify = {});
  package$modify.deleteChatPhoto_mabzdz$ = deleteChatPhoto;
  package$modify.deleteChatPhoto_c7v0u4$ = deleteChatPhoto_0;
  package$modify.pinChatMessage_kjezw1$ = pinChatMessage;
  package$modify.pinChatMessage_w86gz2$ = pinChatMessage_0;
  package$modify.pinChatMessage_f5ujx8$ = pinChatMessage_1;
  package$modify.setChatDescription_fz2mc5$ = setChatDescription;
  package$modify.setChatDescription_1j5r02$ = setChatDescription_0;
  package$modify.setDefaultChatMembersPermissions_8291zi$ = setDefaultChatMembersPermissions;
  package$modify.setDefaultChatMembersPermissions_19e1ez$ = setDefaultChatMembersPermissions_0;
  package$modify.setChatPhoto_ih4u20$ = setChatPhoto;
  package$modify.setChatPhoto_nltoqd$ = setChatPhoto_0;
  package$modify.setChatTitle_fz2mc5$ = setChatTitle;
  package$modify.setChatTitle_1j5r02$ = setChatTitle_0;
  package$modify.unpinChatMessage_mabzdz$ = unpinChatMessage;
  package$modify.unpinChatMessage_c7v0u4$ = unpinChatMessage_0;
  var package$stickers = package$chat.stickers || (package$chat.stickers = {});
  package$stickers.deleteChatStickerSet_mabzdz$ = deleteChatStickerSet;
  package$stickers.deleteChatStickerSet_1w7bsn$ = deleteChatStickerSet_0;
  package$stickers.setChatStickerSet_fz2mc5$ = setChatStickerSet;
  package$stickers.setChatStickerSet_6qtol3$ = setChatStickerSet_0;
  var package$edit = package$api.edit || (package$api.edit = {});
  var package$LiveLocation = package$edit.LiveLocation || (package$edit.LiveLocation = {});
  package$LiveLocation.editLiveLocation_xb2qzx$ = editLiveLocation;
  package$LiveLocation.editLiveLocation_k49pnx$ = editLiveLocation_0;
  package$LiveLocation.editLiveLocation_gkl7dc$ = editLiveLocation_1;
  package$LiveLocation.editLiveLocation_5jdkop$ = editLiveLocation_2;
  package$LiveLocation.editLiveLocation_no3j6p$ = editLiveLocation_3;
  package$LiveLocation.editLiveLocation_pmz9xg$ = editLiveLocation_4;
  package$LiveLocation.editLiveLocation_wsi4fw$ = editLiveLocation_5;
  package$LiveLocation.editLiveLocation_ctuohk$ = editLiveLocation_6;
  package$LiveLocation.stopLiveLocation_tsjbl$ = stopLiveLocation;
  package$LiveLocation.stopLiveLocation_57vmuv$ = stopLiveLocation_0;
  package$LiveLocation.stopLiveLocation_ndwcj0$ = stopLiveLocation_1;
  package$LiveLocation.stopLiveLocation_c1tt0g$ = stopLiveLocation_2;
  var package$ReplyMarkup = package$edit.ReplyMarkup || (package$edit.ReplyMarkup = {});
  package$ReplyMarkup.editMessageReplyMarkup_tsjbl$ = editMessageReplyMarkup;
  package$ReplyMarkup.editMessageReplyMarkup_57vmuv$ = editMessageReplyMarkup_0;
  package$ReplyMarkup.editMessageReplyMarkup_h4mzuk$ = editMessageReplyMarkup_1;
  package$ReplyMarkup.editMessageReplyMarkup_c1tt0g$ = editMessageReplyMarkup_2;
  var package$caption = package$edit.caption || (package$edit.caption = {});
  package$caption.editMessageCaption_toamkl$ = editMessageCaption;
  package$caption.editMessageCaption_z9wo2p$ = editMessageCaption_0;
  package$caption.editMessageCaption_y2p5v5$ = editMessageCaption_1;
  package$caption.editMessageCaption_4y04ju$ = editMessageCaption_2;
  var package$media = package$edit.media || (package$edit.media = {});
  package$media.editMessageMedia_deirv6$ = editMessageMedia;
  package$media.editMessageMedia_u5sxm4$ = editMessageMedia_0;
  package$media.editMessageMedia_yps94m$ = editMessageMedia_1;
  package$media.editMessageCaption_27y3j7$ = editMessageCaption_3;
  var package$text = package$edit.text || (package$edit.text = {});
  package$text.editMessageText_8d61el$ = editMessageText;
  package$text.editMessageText_adzsvr$ = editMessageText_0;
  package$text.editMessageText_lfb6tu$ = editMessageText_1;
  package$text.editMessageText_f7h3ci$ = editMessageText_2;
  var package$games = package$api.games || (package$api.games = {});
  package$games.getGameScore_i7it6q$ = getGameScore;
  package$games.getGameScore_s7cge9$ = getGameScore_0;
  package$games.getGameScore_rr348q$ = getGameScore_1;
  package$games.getGameScore_cy0xjr$ = getGameScore_2;
  package$games.getGameScore_xosimy$ = getGameScore_3;
  package$games.getGameScore_8a5bop$ = getGameScore_4;
  package$games.getGameScore_z52wyl$ = getGameScore_5;
  package$games.getGameScore_m28pgg$ = getGameScore_6;
  package$games.setGameScore_uwmdej$ = setGameScore;
  package$games.setGameScore_r84uzi$ = setGameScore_0;
  package$games.setGameScore_l22nlp$ = setGameScore_1;
  package$games.setGameScore_rzqld2$ = setGameScore_2;
  package$games.setGameScore_721cjn$ = setGameScore_3;
  package$games.setGameScore_9u2jp6$ = setGameScore_4;
  package$games.setGameScore_e5dfga$ = setGameScore_5;
  package$games.setGameScore_dycoub$ = setGameScore_6;
  var package$get_0 = package$api.get || (package$api.get = {});
  package$get_0.getFileAdditionalInfo_q6wrff$ = getFileAdditionalInfo;
  package$get_0.getFileAdditionalInfo_ekhqpf$ = getFileAdditionalInfo_0;
  package$get_0.getStickerSet_mu3aqh$ = getStickerSet;
  package$get_0.getStickerSet_axddce$ = getStickerSet_0;
  package$get_0.getUserProfilePhotos_4u3uvn$ = getUserProfilePhotos;
  package$get_0.getUserProfilePhotos_dgwvo0$ = getUserProfilePhotos_0;
  var package$send = package$api.send || (package$api.send = {});
  package$send.sendBotAction_ult4c0$ = sendBotAction;
  package$send.sendBotAction_l7z1ee$ = sendBotAction_0;
  package$send.sendActionTyping_mabzdz$ = sendActionTyping;
  package$send.sendActionUploadPhoto_mabzdz$ = sendActionUploadPhoto;
  package$send.sendActionRecordVideo_mabzdz$ = sendActionRecordVideo;
  package$send.sendActionUploadVideo_mabzdz$ = sendActionUploadVideo;
  package$send.sendActionRecordAudio_mabzdz$ = sendActionRecordAudio;
  package$send.sendActionUploadAudio_mabzdz$ = sendActionUploadAudio;
  package$send.sendActionUploadDocument_mabzdz$ = sendActionUploadDocument;
  package$send.sendActionFindLocation_mabzdz$ = sendActionFindLocation;
  package$send.sendActionRecordVideoNote_mabzdz$ = sendActionRecordVideoNote;
  package$send.sendActionUploadVideoNote_mabzdz$ = sendActionUploadVideoNote;
  package$send.sendActionTyping_783f3n$ = sendActionTyping_0;
  package$send.sendActionUploadPhoto_783f3n$ = sendActionUploadPhoto_0;
  package$send.sendActionRecordVideo_783f3n$ = sendActionRecordVideo_0;
  package$send.sendActionUploadVideo_783f3n$ = sendActionUploadVideo_0;
  package$send.sendActionRecordAudio_783f3n$ = sendActionRecordAudio_0;
  package$send.sendActionUploadAudio_783f3n$ = sendActionUploadAudio_0;
  package$send.sendActionUploadDocument_783f3n$ = sendActionUploadDocument_0;
  package$send.sendActionFindLocation_783f3n$ = sendActionFindLocation_0;
  package$send.sendActionRecordVideoNote_783f3n$ = sendActionRecordVideoNote_0;
  package$send.sendActionUploadVideoNote_783f3n$ = sendActionUploadVideoNote_0;
  package$send.sendContact_pojs8b$ = sendContact;
  package$send.sendContact_nsi1mn$ = sendContact_0;
  package$send.sendContact_54gf4h$ = sendContact_1;
  package$send.sendContact_sivfmj$ = sendContact_2;
  package$send.sendDice_40cz1o$ = sendDice;
  package$send.sendDice_n3dhf2$ = sendDice_0;
  package$send.sendLocation_qvg8y0$ = sendLocation;
  package$send.sendLocation_919cj0$ = sendLocation_0;
  package$send.sendLocation_9ey5ci$ = sendLocation_1;
  package$send.sendLocation_ky8r2e$ = sendLocation_2;
  package$send.sendMessage_dmttz6$ = sendMessage;
  package$send.sendTextMessage_dmttz6$ = sendTextMessage;
  package$send.sendMessage_m5wdgk$ = sendMessage_0;
  package$send.sendTextMessage_m5wdgk$ = sendTextMessage_0;
  package$send.sendVenue_tmxqmf$ = sendVenue;
  package$send.sendVenue_n42jgz$ = sendVenue_0;
  package$send.sendVenue_ak25oy$ = sendVenue_1;
  package$send.sendVenue_8m6bu4$ = sendVenue_2;
  var package$games_0 = package$send.games || (package$send.games = {});
  package$games_0.sendGame_w175ui$ = sendGame;
  package$games_0.sendGame_h2ev40$ = sendGame_0;
  package$games_0.sendGame_mvin9m$ = sendGame_1;
  package$games_0.sendGame_7dkdps$ = sendGame_2;
  var package$media_0 = package$send.media || (package$send.media = {});
  package$media_0.sendAnimation_s11r6u$ = sendAnimation;
  package$media_0.sendAnimation_c4ob23$ = sendAnimation_0;
  package$media_0.sendAudio_f6bpug$ = sendAudio;
  package$media_0.sendAudio_tnh6p6$ = sendAudio_0;
  package$media_0.sendDocument_ma8fnk$ = sendDocument;
  package$media_0.sendDocument_wzgizm$ = sendDocument_0;
  package$media_0.sendMediaGroup_wpm5k5$ = sendMediaGroup;
  package$media_0.sendMediaGroup_uk7t8r$ = sendMediaGroup_0;
  package$media_0.sendPhoto_wmv1i$ = sendPhoto;
  package$media_0.sendSticker_gvsc69$ = sendSticker;
  package$media_0.sendVideo_s11r6u$ = sendVideo;
  package$media_0.sendVideo_aq2p2w$ = sendVideo_0;
  package$media_0.sendVideoNote_79qxfb$ = sendVideoNote;
  package$media_0.sendVideoNote_aq2p2w$ = sendVideoNote_0;
  package$media_0.sendVoice_dibda0$ = sendVoice;
  package$media_0.sendVoice_ozchoz$ = sendVoice_0;
  var package$payments_0 = package$send.payments || (package$send.payments = {});
  package$payments_0.sendInvoice_7u64uy$ = sendInvoice;
  package$payments_0.sendInvoice_ipshjx$ = sendInvoice_0;
  var package$polls = package$send.polls || (package$send.polls = {});
  package$polls.sendRegularPoll_bs3ur4$ = sendRegularPoll;
  package$polls.sendRegularPoll_elccwa$ = sendRegularPoll_0;
  package$polls.sendRegularPoll_1gl2dy$ = sendRegularPoll_1;
  package$polls.sendRegularPoll_2c0a9c$ = sendRegularPoll_2;
  package$polls.sendQuizPoll_2u11wp$ = sendQuizPoll;
  package$polls.sendQuizPoll_l1t33x$ = sendQuizPoll_0;
  package$polls.sendQuizPoll_136ux8$ = sendQuizPoll_1;
  package$polls.sendQuizPoll_x18mia$ = sendQuizPoll_2;
  var package$stickers_0 = package$api.stickers || (package$api.stickers = {});
  package$stickers_0.addAnimatedStickerToSet_gzcdi$ = addAnimatedStickerToSet;
  package$stickers_0.addAnimatedStickerToSet_q2t619$ = addAnimatedStickerToSet_0;
  package$stickers_0.addAnimatedStickerToSet_d06blj$ = addAnimatedStickerToSet_1;
  package$stickers_0.addAnimatedStickerToSet_cn5muu$ = addAnimatedStickerToSet_2;
  package$stickers_0.addAnimatedStickerToSet_9b6bvs$ = addAnimatedStickerToSet_3;
  package$stickers_0.addAnimatedStickerToSet_uo14dh$ = addAnimatedStickerToSet_4;
  package$stickers_0.addAnimatedStickerToSet_kqkd5h$ = addAnimatedStickerToSet_5;
  package$stickers_0.addAnimatedStickerToSet_kzuf26$ = addAnimatedStickerToSet_6;
  package$stickers_0.addStaticStickerToSet_gzcdi$ = addStaticStickerToSet;
  package$stickers_0.addStaticStickerToSet_q2t619$ = addStaticStickerToSet_0;
  package$stickers_0.addStaticStickerToSet_d06blj$ = addStaticStickerToSet_1;
  package$stickers_0.addStaticStickerToSet_cn5muu$ = addStaticStickerToSet_2;
  package$stickers_0.addStaticStickerToSet_9b6bvs$ = addStaticStickerToSet_3;
  package$stickers_0.addStaticStickerToSet_uo14dh$ = addStaticStickerToSet_4;
  package$stickers_0.addStaticStickerToSet_kqkd5h$ = addStaticStickerToSet_5;
  package$stickers_0.addStaticStickerToSet_kzuf26$ = addStaticStickerToSet_6;
  package$stickers_0.createNewAnimatedStickerSet_cqt0ge$ = createNewAnimatedStickerSet;
  package$stickers_0.createNewAnimatedStickerSet_j6stth$ = createNewAnimatedStickerSet_0;
  package$stickers_0.createNewAnimatedStickerSet_k8aqr5$ = createNewAnimatedStickerSet_1;
  package$stickers_0.createNewAnimatedStickerSet_omobhu$ = createNewAnimatedStickerSet_2;
  package$stickers_0.createNewStaticStickerSet_cqt0ge$ = createNewStaticStickerSet;
  package$stickers_0.createNewStaticStickerSet_j6stth$ = createNewStaticStickerSet_0;
  package$stickers_0.createNewStaticStickerSet_k8aqr5$ = createNewStaticStickerSet_1;
  package$stickers_0.createNewStaticStickerSet_omobhu$ = createNewStaticStickerSet_2;
  package$stickers_0.deleteStickerFromSet_q6wrff$ = deleteStickerFromSet;
  package$stickers_0.deleteStickerFromSet_axddce$ = deleteStickerFromSet_0;
  package$stickers_0.setStickerPositionInSet_2o84wj$ = setStickerPositionInSet;
  package$stickers_0.setStickerPositionInSet_x96wow$ = setStickerPositionInSet_0;
  var package$thumbs = package$api.thumbs || (package$api.thumbs = {});
  package$thumbs.setStickerSetThumb_bq41eb$ = setStickerSetThumb;
  package$thumbs.setStickerSetThumb_9osjh0$ = setStickerSetThumb_0;
  package$thumbs.setStickerSetThumb_bupo5s$ = setStickerSetThumb_1;
  package$thumbs.setStickerSetThumb_4daydt$ = setStickerSetThumb_2;
  package$thumbs.setStickerSetThumb_m001b5$ = setStickerSetThumb_3;
  package$thumbs.setStickerSetThumb_4qecpu$ = setStickerSetThumb_4;
  package$thumbs.setStickerSetThumb_s851us$ = setStickerSetThumb_5;
  package$thumbs.setStickerSetThumb_fklscb$ = setStickerSetThumb_6;
  package$stickers_0.uploadStickerFile_ry955y$ = uploadStickerFile;
  package$stickers_0.uploadStickerFile_g96lgj$ = uploadStickerFile_0;
  var package$updates = package$api.updates || (package$api.updates = {});
  package$updates.startGettingOfUpdates_2uelke$ = startGettingOfUpdates;
  package$updates.startGettingFlowsUpdates_a24tgm$ = startGettingFlowsUpdates;
  package$updates.startGettingOfUpdates_4e35ks$ = startGettingOfUpdates_0;
  package$updates.startGettingOfUpdates_xyifxj$ = startGettingOfUpdates_1;
  package$updates.startGettingOfUpdates_mcnpu4$ = startGettingOfUpdates_2;
  var package$webhook = package$api.webhook || (package$api.webhook = {});
  package$webhook.deleteWebhook_e6cma1$ = deleteWebhook;
  package$webhook.getWebhookInfo_e6cma1$ = getWebhookInfo;
  package$webhook.setWebhookInfo_1g504i$ = setWebhookInfo;
  package$webhook.setWebhookInfo_w4ilm7$ = setWebhookInfo_0;
  livePeriodDelayMillis = Kotlin.Long.fromInt(types.livePeriodLimit.last).subtract(L60).multiply(L1000);
  Kotlin.defineModule('TelegramBotAPI-extensions-api', _);
  return _;
}));

//# sourceMappingURL=TelegramBotAPI-extensions-api.js.map
