/*
 * Decompiled with CFR 0.152.
 */
package com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity;

import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.BoldTextMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.BotCommandMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.CodeTextMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.EMailMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.HashTagMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.ItalicTextMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.MentionMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.MessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.PhoneNumberMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.PreTextMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.RawMessageEntity$;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.TextLinkMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.TextMentionMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.URLMessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.User;
import com.github.insanusmokrassar.TelegramBotAPI.types.User$;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationConstructorMarker;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/github/insanusmokrassar/TelegramBotAPI/types/MessageEntity/RawMessageEntity;", "", "type", "", "offset", "", "length", "url", "user", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/User;", "(Ljava/lang/String;IILjava/lang/String;Lcom/github/insanusmokrassar/TelegramBotAPI/types/User;)V", "getLength", "()I", "getOffset", "getType", "()Ljava/lang/String;", "getUrl", "getUser", "()Lcom/github/insanusmokrassar/TelegramBotAPI/types/User;", "asMessageEntity", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/MessageEntity/MessageEntity;", "source", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "$serializer", "Companion", "TelegramBotAPI"})
public final class RawMessageEntity {
    @NotNull
    private final String type;
    private final int offset;
    private final int length;
    @Nullable
    private final String url;
    @Nullable
    private final User user;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MessageEntity asMessageEntity(@NotNull String source) {
        MessageEntity messageEntity;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        String string = source;
        int n = this.offset;
        int n2 = this.offset + this.length;
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sourceSubstring = string2;
        switch (this.type) {
            case "mention": {
                messageEntity = new MentionMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "hashtag": {
                messageEntity = new HashTagMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "cashtag": {
                n = 0;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            case "bot_command": {
                messageEntity = new BotCommandMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "url": {
                messageEntity = new URLMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "email": {
                messageEntity = new EMailMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "phone_number": {
                messageEntity = new PhoneNumberMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "bold": {
                messageEntity = new BoldTextMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "italic": {
                messageEntity = new ItalicTextMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "code": {
                messageEntity = new CodeTextMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "pre": {
                messageEntity = new PreTextMessageEntity(this.offset, this.length, sourceSubstring);
                break;
            }
            case "text_link": {
                String string3 = this.url;
                if (string3 == null) {
                    throw (Throwable)new IllegalStateException("URL must not be null for text link");
                }
                messageEntity = new TextLinkMessageEntity(this.offset, this.length, sourceSubstring, string3);
                break;
            }
            case "text_mention": {
                User user = this.user;
                if (user == null) {
                    throw (Throwable)new IllegalStateException("User must not be null for text mention");
                }
                messageEntity = new TextMentionMessageEntity(this.offset, this.length, sourceSubstring, user);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown type of message entity");
            }
        }
        return messageEntity;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public RawMessageEntity(@NotNull String type, int offset, int length, @Nullable String url, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.type = type;
        this.offset = offset;
        this.length = length;
        this.url = url;
        this.user = user;
    }

    public /* synthetic */ RawMessageEntity(String string, int n, int n2, String string2, User user, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            string2 = null;
        }
        if ((n3 & 0x10) != 0) {
            user = null;
        }
        this(string, n, n2, string2, user);
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    public final int component2() {
        return this.offset;
    }

    public final int component3() {
        return this.length;
    }

    @Nullable
    public final String component4() {
        return this.url;
    }

    @Nullable
    public final User component5() {
        return this.user;
    }

    @NotNull
    public final RawMessageEntity copy(@NotNull String type, int offset, int length, @Nullable String url, @Nullable User user) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return new RawMessageEntity(type, offset, length, url, user);
    }

    @NotNull
    public static /* synthetic */ RawMessageEntity copy$default(RawMessageEntity rawMessageEntity, String string, int n, int n2, String string2, User user, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = rawMessageEntity.type;
        }
        if ((n3 & 2) != 0) {
            n = rawMessageEntity.offset;
        }
        if ((n3 & 4) != 0) {
            n2 = rawMessageEntity.length;
        }
        if ((n3 & 8) != 0) {
            string2 = rawMessageEntity.url;
        }
        if ((n3 & 0x10) != 0) {
            user = rawMessageEntity.user;
        }
        return rawMessageEntity.copy(string, n, n2, string2, user);
    }

    @NotNull
    public String toString() {
        return "RawMessageEntity(type=" + this.type + ", offset=" + this.offset + ", length=" + this.length + ", url=" + this.url + ", user=" + this.user + ")";
    }

    public int hashCode() {
        String string = this.type;
        String string2 = this.url;
        User user = this.user;
        return ((((string != null ? string.hashCode() : 0) * 31 + this.offset) * 31 + this.length) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (user != null ? ((Object)user).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RawMessageEntity)) break block3;
                RawMessageEntity rawMessageEntity = (RawMessageEntity)object;
                if (!Intrinsics.areEqual((Object)this.type, (Object)rawMessageEntity.type) || !(this.offset == rawMessageEntity.offset) || !(this.length == rawMessageEntity.length) || !Intrinsics.areEqual((Object)this.url, (Object)rawMessageEntity.url) || !Intrinsics.areEqual((Object)this.user, (Object)rawMessageEntity.user)) break block3;
            }
            return true;
        }
        return false;
    }

    public RawMessageEntity(int seen1, @Nullable String type, int offset, int length, @Nullable String url, @Nullable User user, @Nullable SerializationConstructorMarker serializationConstructorMarker) {
        if ((seen1 & 1) == 0) {
            throw (Throwable)new MissingFieldException("type");
        }
        this.type = type;
        if ((seen1 & 2) == 0) {
            throw (Throwable)new MissingFieldException("offset");
        }
        this.offset = offset;
        if ((seen1 & 4) == 0) {
            throw (Throwable)new MissingFieldException("length");
        }
        this.length = length;
        this.url = (seen1 & 8) != 0 ? url : null;
        this.user = (seen1 & 0x10) != 0 ? user : null;
    }

    @JvmStatic
    public static final void write$Self(@NotNull RawMessageEntity self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)serialDesc, (String)"serialDesc");
        output.encodeStringElement(serialDesc, 0, self.type);
        output.encodeIntElement(serialDesc, 1, self.offset);
        output.encodeIntElement(serialDesc, 2, self.length);
        if (Intrinsics.areEqual((Object)self.url, null) ^ true || output.shouldEncodeElementDefault(serialDesc, 3)) {
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)((KSerializer)StringSerializer.INSTANCE), (Object)self.url);
        }
        if (Intrinsics.areEqual((Object)self.user, null) ^ true || output.shouldEncodeElementDefault(serialDesc, 4)) {
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)((KSerializer)User$.serializer.INSTANCE), (Object)self.user);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/github/insanusmokrassar/TelegramBotAPI/types/MessageEntity/RawMessageEntity$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/MessageEntity/RawMessageEntity;", "TelegramBotAPI"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public final KSerializer<RawMessageEntity> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }
    }
}

