/*
 * Decompiled with CFR 0.152.
 */
package com.github.insanusmokrassar.TelegramBotAPI.utils;

import com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.MessageEntity;
import com.github.insanusmokrassar.TelegramBotAPI.types.message.content.TextContent;
import com.github.insanusmokrassar.TelegramBotAPI.types.message.content.abstracts.CaptionedMediaContent;
import com.github.insanusmokrassar.TelegramBotAPI.utils.extensions.StringKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"createMarkdownText", "", "text", "messageEntities", "", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/MessageEntity/MessageEntity;", "toMarkdownCaption", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/message/content/abstracts/CaptionedMediaContent;", "toMarkdownText", "Lcom/github/insanusmokrassar/TelegramBotAPI/types/message/content/TextContent;", "TelegramBotAPI"})
public final class CaptionSourcerKt {
    @NotNull
    public static final String createMarkdownText(@NotNull String text, @NotNull List<? extends MessageEntity> messageEntities) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(messageEntities, (String)"messageEntities");
        StringBuilder builder = new StringBuilder();
        int offset = 0;
        for (MessageEntity string : messageEntities) {
            builder.append(StringKt.toMarkdown(StringsKt.substring((String)text, (IntRange)RangesKt.until((int)offset, (int)string.getOffset()))));
            builder.append(string.getAsMarkdownSource());
            offset += string.getLength();
        }
        String string = text;
        StringBuilder stringBuilder = builder;
        String string2 = string.substring(offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String string3 = string2;
        stringBuilder.append(StringKt.toMarkdown(string3));
        String string4 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"builder.toString()");
        return string4;
    }

    @Nullable
    public static final String toMarkdownCaption(@NotNull CaptionedMediaContent $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string2 = $receiver.getCaption();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = CaptionSourcerKt.createMarkdownText(it, $receiver.getCaptionEntities());
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String toMarkdownText(@NotNull TextContent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return CaptionSourcerKt.createMarkdownText($receiver.getText(), $receiver.getEntities());
    }
}

