/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework;

import com.github.isaichkindanila.command.framework.CommandFramework;
import com.github.isaichkindanila.command.framework.stuff.Command;
import com.github.isaichkindanila.command.framework.stuff.ConsoleIO;
import com.github.isaichkindanila.command.framework.util.Result;
import com.github.isaichkindanila.command.framework.util.cmd.CommandParameters;
import com.github.isaichkindanila.command.framework.util.cmd.CommandWrapper;
import com.github.isaichkindanila.command.framework.util.key.IntKey;
import com.github.isaichkindanila.command.framework.util.key.StringKey;
import com.github.isaichkindanila.command.framework.util.param.Flag;
import com.github.isaichkindanila.command.framework.util.param.Option;
import com.github.isaichkindanila.command.framework.util.param.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class CommandRunner {
    private static final Logger LOGGER = Logger.getLogger(CommandRunner.class.getName());
    private static final String ERROR_ON_PARSING = "error on parsing parameters:";
    private static final String ERROR_ON_CHECKING = "error on checking parameters:";
    private static final String ERROR_ON_EXECUTING = "failed to execute command:";
    private final ConsoleIO consoleIO = CommandFramework.getConsoleIO();
    private final Command command;

    CommandRunner(CommandWrapper wrapper) {
        this.command = CommandFramework.commandFromWrapper(wrapper);
    }

    private void showErrors(String msg, Result result) {
        List<String> errors = result.getErrors();
        if (errors.size() != 0) {
            LOGGER.info(() -> String.format("%s [%s]", msg, String.join((CharSequence)"; ", result.getErrors())));
            if (errors.size() == 1) {
                this.consoleIO.printLine(msg + " " + errors.get(0));
            } else {
                this.consoleIO.printLine(msg);
                this.consoleIO.printList(result.getErrors());
            }
            this.consoleIO.newLine();
        }
    }

    private void parse(Class clazz, String value, String name, Consumer<Integer> intConsumer, Consumer<String> stringConsumer, Result result) {
        if (clazz == IntKey.VALUE_CLASS) {
            try {
                intConsumer.accept(Integer.parseInt(value));
            }
            catch (Exception e) {
                result.addError("failed to parse " + name + ": " + e.toString());
            }
        } else if (clazz == StringKey.VALUE_CLASS) {
            try {
                stringConsumer.accept(value);
            }
            catch (Exception e) {
                result.addError("failed to parse " + name + ": " + e.toString());
            }
        } else {
            result.addError("failed to parse " + name + ": unsupported type " + clazz.getName());
        }
    }

    private void parseParam(Parameter param, String value, Result result) {
        this.parse(param.valueClass(), value, "parameter '" + param.getName() + "'", param::setValue, param::setValue, result);
    }

    private void parseOption(Option option, String name, String value, Result result) {
        this.parse(option.valueClass(), value, "option '" + name + "'", option::setValue, option::setValue, result);
    }

    private void parseArgs(List<String> args, Result result) {
        Iterator<String> iterator = args.iterator();
        CommandParameters params = this.command.getParameters();
        for (Parameter parameter : params.getRequiredParameters()) {
            if (iterator.hasNext()) {
                String arg = iterator.next();
                LOGGER.finer("parsing required parameter '" + parameter.getName() + "', value = '" + arg + "'");
                this.parseParam(parameter, arg, result);
                continue;
            }
            result.addError("required parameter '" + parameter.getName() + "' is missing");
        }
        String arg = null;
        for (Parameter param : params.getOptionalParameters()) {
            if (iterator.hasNext()) {
                arg = iterator.next();
                if (params.getOption(arg) != null || params.getFlag(arg) != null) break;
                LOGGER.finer("parsing optional parameter '" + param.getName() + "', value = '" + arg + "'");
                this.parseParam(param, arg, result);
                arg = null;
                continue;
            }
            return;
        }
        while (arg != null || iterator.hasNext()) {
            if (arg == null) {
                arg = iterator.next();
                continue;
            }
            Flag flag = params.getFlag(arg);
            if (flag != null) {
                LOGGER.finer("parsed flag '" + arg + "'");
                flag.set();
            } else {
                Option option = params.getOption(arg);
                if (option != null) {
                    if (iterator.hasNext()) {
                        String s = iterator.next();
                        LOGGER.finer("parsing option '" + arg + "', value = '" + s + "'");
                        this.parseOption(option, arg, s, result);
                    } else {
                        result.addError("argument for option '" + arg + "' is missing");
                    }
                } else {
                    result.addError("no flags or options found for '" + arg + "'");
                }
            }
            arg = null;
        }
    }

    void run(List<String> args) {
        Result result = new Result();
        CommandFramework.runAndLog("parsed command line arguments", () -> this.parseArgs(args, result));
        if (!result.isOk()) {
            this.showErrors(ERROR_ON_PARSING, result);
            return;
        }
        try {
            CommandFramework.runAndLog("checked command parameters", () -> this.command.checkParameters(result));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "unhandled exception from 'Command.checkParameters()'", e);
            result.addError("exception occurred: " + e.toString());
        }
        if (!result.isOk()) {
            this.showErrors(ERROR_ON_CHECKING, result);
            return;
        }
        try {
            CommandFramework.runAndLog("executed command", () -> this.command.execute(result));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "unhandled exception from 'Command.execute()'", e);
            result.addError("exception occurred: " + e.toString());
        }
        if (!result.isOk()) {
            this.showErrors(ERROR_ON_EXECUTING, result);
        }
    }
}

