/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework;

import com.github.isaichkindanila.command.framework.stuff.ConfigHandler;
import com.github.isaichkindanila.command.framework.util.key.BooleanKey;
import com.github.isaichkindanila.command.framework.util.key.IntKey;
import com.github.isaichkindanila.command.framework.util.key.Key;
import com.github.isaichkindanila.command.framework.util.key.ListKey;
import com.github.isaichkindanila.command.framework.util.key.StringKey;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class ExternalConfig {
    private static final Logger LOGGER = Logger.getLogger(ExternalConfig.class.getName());
    private final ConfigHandler configHandler;
    private final List<KeyWrapper> keyWrappers = new ArrayList<KeyWrapper>();

    public ExternalConfig(ConfigHandler configHandler) {
        this.configHandler = configHandler;
    }

    protected final Key<Integer> getInt(String section, String name, int defaultValue) {
        Optional<Key> optional = this.configHandler.getKey(section, name);
        Key key = optional.isPresent() && optional.get().valueClass() == IntKey.VALUE_CLASS ? optional.get() : this.configHandler.putInt(section, name, defaultValue);
        this.keyWrappers.add(new KeyWrapper(section, name, key));
        return key;
    }

    protected final Key<Boolean> getBoolean(String section, String name, boolean defaultValue) {
        Optional<Key> optional = this.configHandler.getKey(section, name);
        Key key = optional.isPresent() && optional.get().valueClass() == BooleanKey.VALUE_CLASS ? optional.get() : this.configHandler.putBoolean(section, name, defaultValue);
        this.keyWrappers.add(new KeyWrapper(section, name, key));
        return key;
    }

    protected final Key<String> getString(String section, String name, String defaultValue) {
        Optional<Key> optional = this.configHandler.getKey(section, name);
        Key key = optional.isPresent() && optional.get().valueClass() == StringKey.VALUE_CLASS ? optional.get() : this.configHandler.putString(section, name, defaultValue);
        this.keyWrappers.add(new KeyWrapper(section, name, key));
        return key;
    }

    protected final List<String> getList(String section, String name) {
        Optional<Key> optional = this.configHandler.getKey(section, name);
        Key key = optional.isPresent() && optional.get().valueClass() == ListKey.VALUE_CLASS ? optional.get() : this.configHandler.putList(section, name, new ArrayList<String>());
        this.keyWrappers.add(new KeyWrapper(section, name, key));
        return (List)key.value();
    }

    public final ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    final void save(OutputStream out) throws IOException {
        LOGGER.finer("saving config, key count: " + this.keyWrappers.size());
        this.configHandler.clear();
        this.keyWrappers.forEach(w -> this.configHandler.putKey(((KeyWrapper)w).section, ((KeyWrapper)w).name, ((KeyWrapper)w).key));
        this.configHandler.save(out);
    }

    private static class KeyWrapper {
        private final String section;
        private final String name;
        private final Key key;

        private KeyWrapper(String section, String name, Key key) {
            this.section = section;
            this.name = name;
            this.key = key;
        }
    }
}

