/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework;

import com.github.isaichkindanila.command.framework.ExternalConfig;
import com.github.isaichkindanila.command.framework.predefined.DamerauLevenshteinDistance;
import com.github.isaichkindanila.command.framework.predefined.DefaultConsoleIO;
import com.github.isaichkindanila.command.framework.predefined.HelpCommand;
import com.github.isaichkindanila.command.framework.predefined.SimpleXmlConfigHandler;
import com.github.isaichkindanila.command.framework.stuff.Command;
import com.github.isaichkindanila.command.framework.stuff.ConfigHandler;
import com.github.isaichkindanila.command.framework.stuff.ConsoleIO;
import com.github.isaichkindanila.command.framework.stuff.StringDistanceAlgorithm;
import com.github.isaichkindanila.command.framework.util.cmd.CommandWrapper;
import java.io.File;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.XMLFormatter;

public abstract class FrameworkConfig {
    public static final String COMMAND_INFO_FILE_NAME = "commands.bin";

    protected abstract String appName();

    protected abstract Function<ConfigHandler, ExternalConfig> externalConfigConstructor();

    protected ConfigHandler configHandler() {
        return new SimpleXmlConfigHandler();
    }

    public String[] configCommandGetOptionNames() {
        return new String[]{"--get", "-g"};
    }

    public String[] configCommandSaveFlagNames() {
        return new String[]{"--save", "-s"};
    }

    public String[] configCommandEditFlagNames() {
        return new String[]{"--edit", "-e"};
    }

    protected StringDistanceAlgorithm stringDistanceAlgorithm() {
        return new DamerauLevenshteinDistance();
    }

    protected IntUnaryOperator maxSimilarStringDistance() {
        return length -> length >> 1;
    }

    protected ConsoleIO consoleIO() {
        return new DefaultConsoleIO();
    }

    protected File dataDirectory() {
        String homePath = System.getProperty("user.home");
        String dirPath = this.appName();
        return new File(homePath + File.separator + dirPath);
    }

    protected BiConsumer<CommandWrapper, Command> showDetailedInformation() {
        return HelpCommand::showInfoAbout;
    }

    protected Level loggingLevel() {
        return Level.FINE;
    }

    protected Formatter fileLogFormatter() {
        return new XMLFormatter();
    }

    protected Level consoleLoggingLevel() {
        return Level.WARNING;
    }
}

