/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.annotation;

import com.github.isaichkindanila.command.framework.CommandFramework;
import com.github.isaichkindanila.command.framework.annotation.ConsoleCommand;
import com.github.isaichkindanila.command.framework.predefined.ConfigCommand;
import com.github.isaichkindanila.command.framework.predefined.HelpCommand;
import com.github.isaichkindanila.command.framework.stuff.Command;
import com.github.isaichkindanila.command.framework.util.cmd.CommandWrapper;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.github.isaichkindanila.command.framework.annotation.ConsoleCommand"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class CommandProcessor
extends AbstractProcessor {
    private final Set<String> usedCommandNames = new HashSet<String>();
    private final List<CommandWrapper> wrappers = new ArrayList<CommandWrapper>();
    private boolean everythingIsFine = true;
    private Messager messager;
    private TypeMirror commandTypeMirror;
    private Supplier<DataOutputStream> commandsOutSupplier;
    private Supplier<OutputStream> reflectConfigOutSupplier;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.commandTypeMirror = processingEnv.getElementUtils().getTypeElement(Command.class.getCanonicalName()).asType();
        this.commandsOutSupplier = () -> {
            try {
                OutputStream os = processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, CommandFramework.class.getPackage().getName(), "commands.bin", new Element[0]).openOutputStream();
                return new DataOutputStream(new BufferedOutputStream(os));
            }
            catch (IOException e) {
                throw new IllegalStateException("failed to open resource output stream", e);
            }
        };
        this.reflectConfigOutSupplier = () -> {
            try {
                return processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/native-image/command-framework/generated/reflect-config.json", new Element[0]).openOutputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException("failed to open resource output stream", e);
            }
        };
    }

    private void checkIsPublicClass(Element element) {
        if (!element.getKind().isClass() || element.getModifiers().contains((Object)Modifier.ABSTRACT) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessingException(element, String.format("elements annotated with @%s must be public not-abstract classes", ConsoleCommand.class.getSimpleName()));
        }
    }

    private void checkExtendsCommand(Element element) {
        TypeMirror elementMirror = element.asType();
        if (!this.processingEnv.getTypeUtils().isSubtype(elementMirror, this.commandTypeMirror)) {
            throw new ProcessingException(element, String.format("elements annotated with @%s must extend %s", ConsoleCommand.class.getSimpleName(), Command.class.getName()));
        }
    }

    private void checkIsNotInnerClass(Element element) {
        if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            throw new ProcessingException(element, String.format("elements annotated with @%s must be a top-level classes", ConsoleCommand.class.getSimpleName()));
        }
    }

    private void checkHasDefaultConstructor(Element element) {
        List<? extends Element> enclosed = element.getEnclosedElements();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(enclosed);
        for (ExecutableElement c : constructors) {
            if (!c.getParameters().isEmpty() || !c.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return;
        }
        throw new ProcessingException(element, String.format("elements annotated with @%s must have public no-args constructor", ConsoleCommand.class.getSimpleName()));
    }

    private void checkNames(Element element, String[] names) {
        if (names.length == 0) {
            throw new ProcessingException(element, String.format("@%s names must be non-empty", ConsoleCommand.class.getSimpleName()));
        }
        for (String name : names) {
            if (name.contains(" ")) {
                throw new ProcessingException(element, String.format("illegal @%s name: %s (contains space character)", ConsoleCommand.class.getSimpleName(), name));
            }
            if (this.usedCommandNames.add(name)) continue;
            throw new ProcessingException(element, String.format("duplicate @%s name: %s", ConsoleCommand.class.getSimpleName(), name));
        }
    }

    private CommandWrapper createCommandWrapper(Element element, String[] names, String description) {
        PackageElement packageElement = (PackageElement)element.getEnclosingElement();
        String packageName = packageElement.getQualifiedName().toString();
        String className = element.getSimpleName().toString();
        if (!packageName.isEmpty()) {
            className = packageName + "." + className;
        }
        return new CommandWrapper(names, className, description);
    }

    private void processElement(Element element) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "processing", element);
        this.checkIsPublicClass(element);
        this.checkExtendsCommand(element);
        this.checkIsNotInnerClass(element);
        this.checkHasDefaultConstructor(element);
        ConsoleCommand annotation = element.getAnnotation(ConsoleCommand.class);
        String[] names = annotation.names();
        String desc = annotation.desc();
        this.checkNames(element, names);
        CommandWrapper commandWrapper = this.createCommandWrapper(element, names, desc);
        this.wrappers.add(commandWrapper);
    }

    private void writeCommands() {
        try (DataOutputStream out = this.commandsOutSupplier.get();){
            out.writeInt(this.wrappers.size());
            for (CommandWrapper wrapper : this.wrappers) {
                wrapper.writeTo(out);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write commands", e);
        }
    }

    private void writeReflectConfig() {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(Command.class.getName());
        classNames.add(HelpCommand.class.getName());
        classNames.add(ConfigCommand.class.getName());
        this.wrappers.stream().map(CommandWrapper::getClassName).forEach(classNames::add);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String className : classNames) {
            if (first) {
                first = false;
                builder.append("[\n");
            } else {
                builder.append(",\n");
            }
            builder.append("  {\n").append("    \"name\" : \"").append(className).append("\",\n").append("    \"methods\" : [\n").append("      { \"name\" : \"<init>\", \"parameterTypes\" : [] }\n").append("    ]\n").append("  }");
        }
        builder.append("\n]");
        try (OutputStream out = this.reflectConfigOutSupplier.get();){
            out.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to write reflect-config.json", e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised() || !this.everythingIsFine) {
            return false;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(ConsoleCommand.class);
        try {
            elements.forEach(this::processElement);
        }
        catch (ProcessingException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.msg, e.element);
            this.everythingIsFine = false;
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "something went wrong: " + e.toString());
        }
        if (this.everythingIsFine && roundEnv.processingOver()) {
            this.wrappers.sort(Comparator.comparing(a -> a.getNames()[0]));
            this.writeCommands();
            this.writeReflectConfig();
        }
        return true;
    }

    private static class ProcessingException
    extends RuntimeException {
        private final Element element;
        private final String msg;

        private ProcessingException(Element element, String msg) {
            this.element = element;
            this.msg = msg;
        }
    }
}

