/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.predefined;

import com.github.isaichkindanila.command.framework.CommandFramework;
import com.github.isaichkindanila.command.framework.FrameworkConfig;
import com.github.isaichkindanila.command.framework.stuff.Command;
import com.github.isaichkindanila.command.framework.util.Result;
import com.github.isaichkindanila.command.framework.util.cmd.CommandWrapper;
import com.github.isaichkindanila.command.framework.util.key.Key;
import com.github.isaichkindanila.command.framework.util.key.ListKey;
import com.github.isaichkindanila.command.framework.util.param.Flag;
import com.github.isaichkindanila.command.framework.util.param.Option;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigCommand
extends Command {
    private static final Logger LOGGER = Logger.getLogger(ConfigCommand.class.getName());
    private static CommandWrapper wrapper;
    private static String[] getKeyNames;
    private static String[] saveConfigNames;
    private static String[] editConfigNames;
    private boolean hasOptions = false;
    private boolean saved = false;
    private Option<String> getOption = this.stringOption(getKeyNames, "get config key by name (in format 'section.key')", "section.key");
    private Flag saveFlag = this.flag(saveConfigNames, "rewrite and save config to file");
    private Flag editFlag = this.flag(editConfigNames, "open config file in text editor");

    public static CommandWrapper getWrapper(FrameworkConfig config) {
        if (wrapper == null) {
            getKeyNames = config.configCommandGetOptionNames();
            saveConfigNames = config.configCommandSaveFlagNames();
            editConfigNames = config.configCommandEditFlagNames();
            wrapper = new CommandWrapper(new String[]{"config"}, ConfigCommand.class.getName(), "interacts with configuration");
        }
        return wrapper;
    }

    @Override
    public void checkParameters(Result result) {
        if (this.getOption.isPresent() || this.saveFlag.isSet() || this.editFlag.isSet()) {
            this.hasOptions = true;
        }
    }

    private void get(String arg, Result result) {
        String name;
        String section = "";
        int indexOfFirstDot = arg.indexOf(46);
        if (indexOfFirstDot < 0) {
            name = arg;
        } else {
            section = arg.substring(0, indexOfFirstDot);
            name = arg.substring(indexOfFirstDot + 1);
        }
        LOGGER.fine(String.format("section = '%s', name = '%s'", section, name));
        if (name.isEmpty()) {
            result.addError("key name is empty");
        } else {
            Optional<Key> optional = CommandFramework.getExternalConfig().getConfigHandler().getKey(section, name);
            if (optional.isPresent()) {
                Key key = optional.get();
                if (key.valueClass() == List.class) {
                    List list = (List)((ListKey)key).value();
                    if (list.isEmpty()) {
                        this.consoleIO.printLine(arg + ": <empty list>");
                    } else {
                        this.consoleIO.printLine(arg + ":");
                        this.consoleIO.printList(list);
                    }
                } else {
                    this.consoleIO.printLine(arg + " = " + key.value().toString());
                }
            } else {
                this.consoleIO.printLine("key \"" + arg + "\" not found");
            }
        }
    }

    private void save() {
        if (!this.saved) {
            CommandFramework.saveExternalConfig();
            this.saved = true;
            this.consoleIO.printLine("config saved to " + CommandFramework.getConfigFile().getAbsolutePath());
        }
    }

    private void edit() {
        if (!this.saved) {
            CommandFramework.saveExternalConfig();
            this.saved = true;
        }
        String path = CommandFramework.getConfigFile().getAbsolutePath();
        LOGGER.finer("opening config file");
        try {
            Runtime runtime = Runtime.getRuntime();
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                runtime.exec("cmd /c start \"\" \"" + path + "\"");
            } else if (os.startsWith("Linux")) {
                runtime.exec("edit \"" + path + "\"");
            } else if (os.startsWith("Mac")) {
                runtime.exec("open \"" + path + "\"");
            } else {
                LOGGER.warning("unsupported OS: '" + os + "'");
                this.consoleIO.printLine("cannot open file on this OS (file path: '" + path + "')");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "failed to open config file", e);
            this.consoleIO.printLine("failed to open config file");
        }
    }

    @Override
    public void execute(Result result) {
        if (!this.hasOptions) {
            CommandFramework.showDetailedInformation(wrapper, this);
        } else {
            this.getOption.ifPresent(s -> this.get((String)s, result));
            if (this.saveFlag.isSet()) {
                this.save();
            }
            if (this.editFlag.isSet()) {
                this.edit();
            }
        }
    }
}

