/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.predefined;

import com.github.isaichkindanila.command.framework.stuff.StringDistanceAlgorithm;
import java.util.Arrays;

public class DamerauLevenshteinDistance
implements StringDistanceAlgorithm {
    private int[] da;

    private int min(int ... numbers) {
        int min = Integer.MAX_VALUE;
        for (int num : numbers) {
            if (num >= min) continue;
            min = num;
        }
        return min;
    }

    @Override
    public int compute(String stringA, String stringB) {
        int i;
        int maxDist;
        if (this.da == null) {
            this.da = new int[65536];
        } else {
            Arrays.fill(this.da, 0);
        }
        char[] a = stringA.toCharArray();
        char[] b = stringB.toCharArray();
        int[][] d = new int[a.length + 2][b.length + 2];
        d[0][0] = maxDist = a.length + b.length;
        for (i = 0; i <= a.length; ++i) {
            d[i + 1][0] = maxDist;
            d[i + 1][1] = i;
        }
        for (i = 0; i <= b.length; ++i) {
            d[0][i + 1] = maxDist;
            d[1][i + 1] = i;
        }
        for (i = 1; i <= a.length; ++i) {
            int db = 0;
            for (int j = 1; j <= b.length; ++j) {
                int cost;
                int m = this.da[b[j - 1]];
                int n = db;
                int n2 = cost = a[i - 1] == b[j - 1] ? 0 : 1;
                if (cost == 0) {
                    db = j;
                }
                d[i + 1][j + 1] = this.min(d[i][j] + cost, d[i + 1][j] + 1, d[i][j + 1] + 1, d[m][n] + (i - m - 1) + (j - n - 1) + 1);
            }
            this.da[a[i - 1]] = i;
        }
        return d[a.length + 1][b.length + 1];
    }
}

