/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.predefined;

import com.github.isaichkindanila.command.framework.stuff.ConsoleIO;
import java.util.Collection;
import java.util.Scanner;

public class DefaultConsoleIO
extends ConsoleIO {
    private static final String MAIN_INDENTATION = "  ";
    private static final String LIST_INDENTATION = "  ";
    private final Scanner scanner = new Scanner(System.in);

    @Override
    public void print(String str) {
        System.out.print("  " + str);
    }

    @Override
    public void newLine() {
        System.out.println();
    }

    @Override
    public void printList(Collection<String> lines) {
        int indexLength = 0;
        int x = lines.size();
        while (x > 0) {
            x /= 10;
            ++indexLength;
        }
        String template = String.format("%s%%%dd. %%s", "  ", indexLength);
        int index = 0;
        for (String str : lines) {
            this.printLine(String.format(template, ++index, str));
        }
    }

    @Override
    public String readInput(String message) {
        this.print(message + ": ");
        return this.scanner.nextLine();
    }

    @Override
    public boolean confirm(String message) {
        this.print(message + " ('q' to abort): ");
        return !this.scanner.nextLine().equalsIgnoreCase("q");
    }
}

