/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.predefined;

import com.github.isaichkindanila.command.framework.stuff.ConfigHandler;
import com.github.isaichkindanila.command.framework.util.key.BooleanKey;
import com.github.isaichkindanila.command.framework.util.key.IntKey;
import com.github.isaichkindanila.command.framework.util.key.Key;
import com.github.isaichkindanila.command.framework.util.key.ListKey;
import com.github.isaichkindanila.command.framework.util.key.StringKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleXmlConfigHandler
extends ConfigHandler {
    private static final Logger LOGGER = Logger.getLogger(SimpleXmlConfigHandler.class.getName());
    private static final String INDENTATION = "    ";
    private static final String INT_TAG = "int";
    private static final String BOOL_TAG = "bool";
    private static final String STRING_TAG = "string";
    private static final String LIST_TAG = "list";
    private static final String ITEM_TAG = "item";
    private static final Pattern SECTION_PATTERN = Pattern.compile("<section\\s+name=\"(.*)\"\\s*>");
    private static final Pattern PRIMITIVE_PATTERN = Pattern.compile("<(.*)\\s+name=\"(.*)\"\\s*value=\"(.*)\"\\s*/>");
    private static final Pattern LIST_PATTERN = Pattern.compile("<list\\s+name=\"(.*)\"\\s*>");
    private static final Pattern ITEM_PATTERN = Pattern.compile("<item\\s+value=\"(.*)\"\\s*/>");
    private static final EscapePair[] ESCAPE_PAIRS = new EscapePair[]{new EscapePair("&", "&amp;"), new EscapePair("\"", "&quot;"), new EscapePair("'", "&apos;"), new EscapePair("<", "&lt;"), new EscapePair(">", "&gt;")};

    @Override
    public String extension() {
        return "xml";
    }

    private String escape(String str) {
        for (int i = 0; i < ESCAPE_PAIRS.length; ++i) {
            str = str.replace(ESCAPE_PAIRS[i].character, ESCAPE_PAIRS[i].replacement);
        }
        return str;
    }

    private String unescape(String str) {
        for (int i = ESCAPE_PAIRS.length - 1; i >= 0; --i) {
            str = str.replace(ESCAPE_PAIRS[i].replacement, ESCAPE_PAIRS[i].character);
        }
        return str;
    }

    private void parsePrimitive(String tag, String section, String name, String value) {
        LOGGER.finer(() -> "parsing " + tag + ": name='" + name + "', value = '" + value + "'");
        switch (tag) {
            case "int": {
                try {
                    this.putInt(section, name, Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.FINE, "failed to parse '" + section + "." + name + "'", e);
                }
                break;
            }
            case "bool": {
                this.putBoolean(section, name, Boolean.parseBoolean(value));
                break;
            }
            case "string": {
                this.putString(section, name, value);
                break;
            }
            default: {
                LOGGER.warning("unknown primitive tag '" + tag + "'");
            }
        }
    }

    @Override
    public void parse(InputStream in) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> list = null;
        String listName = null;
        String section = null;
        while ((line = bufferedReader.readLine()) != null) {
            Matcher matcher;
            if ((line = line.trim()).isEmpty()) continue;
            if (line.equals("</config>")) break;
            if (list != null) {
                if (line.equals("</list>")) {
                    this.putList(section, listName, list);
                    list = null;
                    listName = null;
                    continue;
                }
                matcher = ITEM_PATTERN.matcher(line);
                if (matcher.matches()) {
                    list.add(this.unescape(matcher.group(1)));
                    continue;
                }
                LOGGER.warning("expected list item; got '" + line + "'");
                continue;
            }
            if (line.equals("<config>")) continue;
            if (section == null) {
                matcher = SECTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    section = this.unescape(matcher.group(1));
                    LOGGER.finer("parsing section '" + section + "'");
                    continue;
                }
                LOGGER.warning("expected start of section; got '" + line + "'");
                continue;
            }
            if (line.equals("</section>")) {
                section = null;
                continue;
            }
            if (line.startsWith("<list") && line.endsWith("/>")) {
                LOGGER.finer("skipping empty list");
                continue;
            }
            matcher = PRIMITIVE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String tag = matcher.group(1);
                String name = this.unescape(matcher.group(2));
                String value = this.unescape(matcher.group(3));
                this.parsePrimitive(tag, section, name, value);
                continue;
            }
            matcher = LIST_PATTERN.matcher(line);
            if (matcher.matches()) {
                list = new ArrayList<String>();
                listName = this.unescape(matcher.group(1));
                continue;
            }
            LOGGER.warning("expected end of section, primitive or list; got '" + line + "'");
        }
    }

    private void savePrimitive(StringBuilder builder, String tagName, KeyWrapper wrapper) {
        LOGGER.finer(() -> "saving " + tagName + ": name='" + wrapper.name + "', value = '" + wrapper.key.value().toString() + "'");
        builder.append(INDENTATION).append(INDENTATION).append('<').append(tagName).append(" name=\"").append(this.escape(wrapper.name)).append("\" value=\"").append(this.escape(wrapper.key.value().toString())).append("\"/>\n");
    }

    private void saveList(StringBuilder builder, KeyWrapper wrapper) {
        LOGGER.finer(() -> "saving list '" + wrapper.name);
        builder.append(INDENTATION).append(INDENTATION).append('<').append(LIST_TAG).append(" name=\"").append(this.escape(wrapper.name)).append('\"');
        List list = (List)wrapper.key.value();
        if (list.isEmpty()) {
            builder.append("/>\n");
            return;
        }
        builder.append(">\n");
        for (String s : list) {
            builder.append(INDENTATION).append(INDENTATION).append(INDENTATION).append('<').append(ITEM_TAG).append(" value=\"").append(this.escape(s)).append("\"/>\n");
        }
        builder.append(INDENTATION).append(INDENTATION).append("</list>\n");
    }

    private void saveSection(StringBuilder builder, ConfigHandler.Section section) {
        LOGGER.finer(() -> "saving section '" + section.name + "'");
        builder.append(INDENTATION).append("<section name=\"").append(this.escape(section.name)).append("\">\n");
        section.map.entrySet().stream().map(e -> new KeyWrapper((String)e.getKey(), (Key)e.getValue())).sorted().forEach(w -> {
            switch (((KeyWrapper)w).ordinal) {
                case 1: {
                    this.savePrimitive(builder, INT_TAG, (KeyWrapper)w);
                    break;
                }
                case 2: {
                    this.savePrimitive(builder, BOOL_TAG, (KeyWrapper)w);
                    break;
                }
                case 3: {
                    this.savePrimitive(builder, STRING_TAG, (KeyWrapper)w);
                    break;
                }
                case 4: {
                    this.saveList(builder, (KeyWrapper)w);
                    break;
                }
                default: {
                    LOGGER.warning("unknown key: name='" + ((KeyWrapper)w).name + "', class='" + ((KeyWrapper)w).key.valueClass() + "'");
                }
            }
        });
        builder.append(INDENTATION).append("</section>\n");
    }

    @Override
    protected void save(OutputStream out, List<ConfigHandler.Section> sections) throws IOException {
        StringBuilder builder = new StringBuilder("<config>\n");
        sections.forEach(s -> this.saveSection(builder, (ConfigHandler.Section)s));
        builder.append("</config>");
        out.write(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static class KeyWrapper
    implements Comparable<KeyWrapper> {
        private static final int INT = 1;
        private static final int BOOL = 2;
        private static final int STRING = 3;
        private static final int LIST = 4;
        private static final int UNKNOWN = 5;
        private final String name;
        private final Key key;
        private final int ordinal;

        private static int ordinalOf(Key key) {
            Class clazz = key.valueClass();
            if (clazz == IntKey.VALUE_CLASS) {
                return 1;
            }
            if (clazz == BooleanKey.VALUE_CLASS) {
                return 2;
            }
            if (clazz == StringKey.VALUE_CLASS) {
                return 3;
            }
            if (clazz == ListKey.VALUE_CLASS) {
                return 4;
            }
            return 5;
        }

        private KeyWrapper(String name, Key key) {
            this.name = name;
            this.key = key;
            this.ordinal = KeyWrapper.ordinalOf(key);
        }

        @Override
        public int compareTo(KeyWrapper that) {
            int thisOrdinal = this.ordinal;
            int thatOrdinal = that.ordinal;
            if (thisOrdinal == thatOrdinal) {
                return this.name.compareToIgnoreCase(that.name);
            }
            return thisOrdinal - thatOrdinal;
        }
    }

    private static class EscapePair {
        private final String character;
        private final String replacement;

        private EscapePair(String character, String replacement) {
            this.character = character;
            this.replacement = replacement;
        }
    }
}

