/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.stuff;

import com.github.isaichkindanila.command.framework.util.key.BooleanKey;
import com.github.isaichkindanila.command.framework.util.key.IntKey;
import com.github.isaichkindanila.command.framework.util.key.Key;
import com.github.isaichkindanila.command.framework.util.key.ListKey;
import com.github.isaichkindanila.command.framework.util.key.StringKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ConfigHandler {
    private static final Logger LOGGER = Logger.getLogger(ConfigHandler.class.getName());
    private final Map<String, Map<String, Key>> sectionNameKeyMap = new HashMap<String, Map<String, Key>>();

    public abstract String extension();

    public abstract void parse(InputStream var1) throws IOException;

    protected abstract void save(OutputStream var1, List<Section> var2) throws IOException;

    public final void save(OutputStream out) throws IOException {
        List<Section> sections = this.sectionNameKeyMap.entrySet().stream().map(e -> new Section((String)e.getKey(), (Map)e.getValue())).sorted(Comparator.comparing(section -> section.name)).collect(Collectors.toList());
        this.save(out, sections);
    }

    public final void clear() {
        this.sectionNameKeyMap.clear();
    }

    private Map<String, Key> getSection(String section) {
        if (section == null) {
            section = "";
        }
        return this.sectionNameKeyMap.computeIfAbsent(section, s -> new HashMap());
    }

    public final void putKey(String section, String name, Key key) {
        this.getSection(section).put(name, key);
    }

    public final IntKey putInt(String section, String name, int value) {
        LOGGER.finest(() -> String.format("putting int: section = '%s', name = '%s', value = %d", section, name, value));
        IntKey key = new IntKey(value);
        this.putKey(section, name, key);
        return key;
    }

    public final BooleanKey putBoolean(String section, String name, boolean value) {
        LOGGER.finest(() -> String.format("putting boolean: section = '%s', name = '%s', value = %s", section, name, String.valueOf(value)));
        BooleanKey key = new BooleanKey(value);
        this.putKey(section, name, key);
        return key;
    }

    public final StringKey putString(String section, String name, String value) {
        LOGGER.finest(() -> String.format("putting string: section = '%s', name = '%s', value = '%s'", section, name, value));
        StringKey key = new StringKey(value);
        this.putKey(section, name, key);
        return key;
    }

    public final ListKey putList(String section, String name, List<String> value) {
        LOGGER.finest(() -> String.format("putting list: section = '%s', name = '%s', value = [%s]", section, name, String.join((CharSequence)", ", value)));
        ListKey key = new ListKey(value);
        this.putKey(section, name, key);
        return key;
    }

    public final Optional<Key> getKey(String section, String name) {
        return Optional.ofNullable(this.getSection(section).get(name));
    }

    protected static final class Section {
        public final String name;
        public final Map<String, Key> map;

        private Section(String name, Map<String, Key> map) {
            this.name = name == null ? "" : name;
            this.map = map;
        }
    }
}

