/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.stuff;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class ConsoleIO {
    public abstract void print(String var1);

    public final void printLine(String line) {
        this.print(line + System.lineSeparator());
    }

    public abstract void newLine();

    public abstract void printList(Collection<String> var1);

    public final void printList(String[] lines) {
        this.printList(Arrays.asList(lines));
    }

    public abstract String readInput(String var1);

    public abstract boolean confirm(String var1);

    public final Handler createHandler(Level level) {
        return new Handler(this, level);
    }

    private static class ConsoleFormatter
    extends Formatter {
        private ConsoleFormatter() {
        }

        private static String formatLevel(LogRecord record) {
            Level level = record.getLevel();
            return level.getName() + ':';
        }

        private static String formatThrown(LogRecord record) {
            return "(" + record.getThrown().toString() + ")";
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder().append(ConsoleFormatter.formatLevel(record)).append(' ').append(this.formatMessage(record));
            if (record.getThrown() != null) {
                builder.append(' ').append(ConsoleFormatter.formatThrown(record));
            }
            return builder.toString();
        }
    }

    public static class Handler
    extends java.util.logging.Handler {
        private final ConsoleIO consoleIO;

        private Handler(ConsoleIO consoleIO, Level level) {
            this.consoleIO = consoleIO;
            this.setLevel(level);
            this.setFormatter(new ConsoleFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            if (record == null || !this.isLoggable(record)) {
                return;
            }
            this.consoleIO.printLine(this.getFormatter().format(record));
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

