/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.util.cmd;

import com.github.isaichkindanila.command.framework.util.param.Flag;
import com.github.isaichkindanila.command.framework.util.param.Option;
import com.github.isaichkindanila.command.framework.util.param.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CommandParameters {
    private final List<Parameter> requiredParameters = new ArrayList<Parameter>();
    private final List<Parameter> optionalParameters = new ArrayList<Parameter>();
    private final Map<String, Option> optionMap = new HashMap<String, Option>();
    private final Map<String, Flag> flagMap = new HashMap<String, Flag>();

    public void addParameter(Parameter parameter) {
        if (parameter.isRequired()) {
            this.requiredParameters.add(parameter);
        } else {
            this.optionalParameters.add(parameter);
        }
    }

    public void addOption(Option option) {
        for (String name : option.getNames()) {
            this.optionMap.put(name, option);
        }
    }

    public void addFlag(Flag flag) {
        for (String name : flag.getNames()) {
            this.flagMap.put(name, flag);
        }
    }

    public Option getOption(String name) {
        return this.optionMap.get(name);
    }

    public Flag getFlag(String name) {
        return this.flagMap.get(name);
    }

    public List<Parameter> getRequiredParameters() {
        return this.requiredParameters;
    }

    public List<Parameter> getOptionalParameters() {
        return this.optionalParameters;
    }

    public Map<String, Option> getOptionMap() {
        return this.optionMap;
    }

    public Map<String, Flag> getFlagMap() {
        return this.flagMap;
    }
}

