/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.util.cmd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class CommandWrapper {
    private final String[] names;
    private final String description;
    private final String className;

    public CommandWrapper(String[] names, String className, String description) {
        this.names = Objects.requireNonNull(names, "names is null");
        this.className = Objects.requireNonNull(className, "className is null");
        this.description = Objects.requireNonNull(description, "description is null");
    }

    public CommandWrapper(DataInput in) throws IOException {
        this.names = new String[in.readInt()];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = in.readUTF();
        }
        this.className = in.readUTF();
        this.description = in.readUTF();
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.names.length);
        for (String name : this.names) {
            out.writeUTF(name);
        }
        out.writeUTF(this.className);
        out.writeUTF(this.description);
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }
}

