/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.util.param;

import com.github.isaichkindanila.command.framework.util.key.Key;
import java.util.function.Consumer;

public class Option<T> {
    private final String[] names;
    private final String description;
    private final String argName;
    private final Key<T> key;

    public Option(String[] names, String description, String argName, Key<T> key) {
        this.names = names;
        this.description = description;
        this.argName = argName;
        this.key = key;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public String getArgName() {
        return this.argName;
    }

    public T getValue() {
        return this.key.value();
    }

    public void setValue(T value) {
        this.key.setValue(value);
    }

    public Class valueClass() {
        return this.key.valueClass();
    }

    public boolean isPresent() {
        return this.key.value() != null;
    }

    public T orElse(T value) {
        return this.isPresent() ? this.key.value() : value;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.isPresent()) {
            action.accept(this.key.value());
        }
    }
}

