/*
 * Decompiled with CFR 0.152.
 */
package com.github.isaichkindanila.command.framework.util.param;

import com.github.isaichkindanila.command.framework.util.key.Key;
import java.util.function.Consumer;

public class Parameter<T> {
    private final String name;
    private final String description;
    private final boolean required;
    private final Key<T> key;

    public Parameter(String name, String description, boolean required, Key<T> key) {
        this.name = name;
        this.description = description;
        this.required = required;
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public T getValue() {
        return this.key.value();
    }

    public void setValue(T value) {
        this.key.setValue(value);
    }

    public boolean isPresent() {
        return this.getValue() != null;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.isPresent()) {
            action.accept(this.key.value());
        }
    }

    public T orElse(T value) {
        return this.isPresent() ? this.key.value() : value;
    }

    public Class valueClass() {
        return this.key.valueClass();
    }
}

