/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.util;

import com.github.jasync.sql.db.exceptions.UnknownLengthException;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public class ChannelWrapper {
    public static final short MySQL_NULL = 251;

    public static String readFixedString(ByteBuf buffer, int length, Charset charset) {
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        return new String(bytes, charset);
    }

    public static String readCString(ByteBuf buffer, Charset charset) {
        return ByteBufferUtils.readCString(buffer, charset);
    }

    public static String readUntilEOF(ByteBuf buffer, Charset charset) {
        return ByteBufferUtils.readUntilEOF(buffer, charset);
    }

    public static String readLengthEncodedString(ByteBuf buffer, Charset charset) {
        long length = ChannelWrapper.readBinaryLength(buffer);
        return ChannelWrapper.readFixedString(buffer, (int)length, charset);
    }

    public static long readBinaryLength(ByteBuf buffer) {
        short firstByte = buffer.readUnsignedByte();
        if (firstByte <= 250) {
            return firstByte;
        }
        switch (firstByte) {
            case 251: {
                return -1L;
            }
            case 252: {
                return buffer.readUnsignedShort();
            }
            case 253: {
                return ChannelWrapper.readLongInt(buffer);
            }
            case 254: {
                return buffer.readLong();
            }
        }
        throw new UnknownLengthException(firstByte);
    }

    public static int readLongInt(ByteBuf buffer) {
        byte first = buffer.readByte();
        byte second = buffer.readByte();
        byte third = buffer.readByte();
        return first & 0xFF | (second & 0xFF) << 8 | (third & 0xFF) << 16;
    }

    public static void writeLength(ByteBuf buffer, long length) {
        if (length < 251L) {
            buffer.writeByte((int)((byte)length));
        } else if (length < 65536L) {
            buffer.writeByte(252);
            buffer.writeShort((int)length);
        } else if (length < 0x1000000L) {
            buffer.writeByte(253);
            ChannelWrapper.writeLongInt(buffer, (int)length);
        } else {
            buffer.writeByte(254);
            buffer.writeLong(length);
        }
    }

    public static void writeLongInt(ByteBuf buffer, int i) {
        buffer.writeByte(i & 0xFF);
        buffer.writeByte(i >>> 8);
        buffer.writeByte(i >>> 16);
    }

    public static void writeLengthEncodedString(ByteBuf buffer, String value, Charset charset) {
        byte[] bytes = value.getBytes(charset);
        ChannelWrapper.writeLength(buffer, bytes.length);
        buffer.writeBytes(bytes);
    }

    public static void writePacketLength(ByteBuf buffer) {
        ChannelWrapper.writePacketLength(buffer, 0);
    }

    public static void writePacketLength(ByteBuf buffer, int sequence) {
        ByteBufferUtils.writePacketLength(buffer, sequence);
    }

    public static int mysqlReadInt(ByteBuf buffer) {
        byte first = buffer.readByte();
        byte last = buffer.readByte();
        return first & 0xFF | (last & 0xFF) << 8;
    }
}

