/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.util;

public class HexCodec {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] decode(CharSequence value, int start) {
        int length = value.length() - start;
        int end = value.length();
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters. A hex encoded byte array has to be even.");
        }
        byte[] out = new byte[length >> 1];
        int i = 0;
        int j = start;
        while (j < end) {
            int f = HexCodec.toDigit(value.charAt(j), j) << 4;
            f |= HexCodec.toDigit(value.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String encode(byte[] bytes, char[] prefix) {
        int length = bytes.length * 2 + prefix.length;
        char[] chars = new char[length];
        if (prefix.length != 0) {
            for (int x = 0; x < prefix.length; ++x) {
                chars[x] = prefix[x];
            }
        }
        int dataLength = bytes.length;
        int j = prefix.length;
        for (int i = 0; i < dataLength; ++i) {
            chars[j] = digits[(0xF0 & bytes[i]) >>> 4];
            chars[++j] = digits[0xF & bytes[i]];
            ++j;
        }
        return new String(chars);
    }
}

