/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.ConnectionPoolConfiguration;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.interceptor.QueryInterceptor;
import com.github.jasync.sql.db.pool.PoolConfiguration;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import com.github.jasync.sql.db.util.NettyUtils;
import com.github.jasync.sql.db.util.NullableUtilsKt;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0091\u0002\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 \u0012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010&J\t\u0010S\u001a\u00020\u0003H\u00c6\u0003J\t\u0010T\u001a\u00020\u000bH\u00c6\u0003J\t\u0010U\u001a\u00020\u000bH\u00c6\u0003J\u0010\u0010V\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010CJ\t\u0010W\u001a\u00020\u0012H\u00c6\u0003J\t\u0010X\u001a\u00020\u0014H\u00c6\u0003J\t\u0010Y\u001a\u00020\u0016H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0018H\u00c6\u0003J\t\u0010[\u001a\u00020\u001aH\u00c6\u0003J\t\u0010\\\u001a\u00020\u0005H\u00c6\u0003J\t\u0010]\u001a\u00020\u001dH\u00c6\u0003J\t\u0010^\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010_\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 H\u00c6\u0003J\u0010\u0010a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010CJ\u000b\u0010b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010g\u001a\u00020\u0005H\u00c6\u0003J\t\u0010h\u001a\u00020\u000bH\u00c6\u0003J\t\u0010i\u001a\u00020\u0005H\u00c6\u0003J\t\u0010j\u001a\u00020\u000bH\u00c6\u0003J\u0098\u0002\u0010k\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010lJ\u0013\u0010m\u001a\u00020n2\b\u0010o\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010p\u001a\u00020\u0005H\u00d6\u0001J\b\u0010q\u001a\u00020\u0003H\u0016R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00102R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00102R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0013\u0010$\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010*R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010*R\u001d\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0015\u0010#\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010D\u001a\u0004\bB\u0010CR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u00102R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010AR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010AR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010*R\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010AR\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010D\u001a\u0004\bN\u0010CR\u0013\u0010%\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010*R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010*\u00a8\u0006r"}, d2={"Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;", "", "host", "", "port", "", "database", "username", "password", "maxActiveConnections", "maxIdleTime", "", "maxPendingQueries", "connectionValidationInterval", "connectionCreateTimeout", "connectionTestTimeout", "queryTimeout", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "executionContext", "Ljava/util/concurrent/Executor;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "ssl", "Lcom/github/jasync/sql/db/SSLConfiguration;", "charset", "Ljava/nio/charset/Charset;", "maximumMessageSize", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "applicationName", "interceptors", "", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/interceptor/QueryInterceptor;", "maxConnectionTtl", "currentSchema", "socketPath", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IJIJJJLjava/lang/Long;Lio/netty/channel/EventLoopGroup;Ljava/util/concurrent/Executor;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/github/jasync/sql/db/SSLConfiguration;Ljava/nio/charset/Charset;ILio/netty/buffer/ByteBufAllocator;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)V", "getAllocator", "()Lio/netty/buffer/ByteBufAllocator;", "getApplicationName", "()Ljava/lang/String;", "getCharset", "()Ljava/nio/charset/Charset;", "connectionConfiguration", "Lcom/github/jasync/sql/db/Configuration;", "getConnectionConfiguration", "()Lcom/github/jasync/sql/db/Configuration;", "getConnectionCreateTimeout", "()J", "getConnectionTestTimeout", "getConnectionValidationInterval", "getCoroutineDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "getCurrentSchema", "getDatabase", "getEventLoopGroup", "()Lio/netty/channel/EventLoopGroup;", "getExecutionContext", "()Ljava/util/concurrent/Executor;", "getHost", "getInterceptors", "()Ljava/util/List;", "getMaxActiveConnections", "()I", "getMaxConnectionTtl", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getMaxIdleTime", "getMaxPendingQueries", "getMaximumMessageSize", "getPassword", "poolConfiguration", "Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "getPoolConfiguration", "()Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "getPort", "getQueryTimeout", "getSocketPath", "getSsl", "()Lcom/github/jasync/sql/db/SSLConfiguration;", "getUsername", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IJIJJJLjava/lang/Long;Lio/netty/channel/EventLoopGroup;Ljava/util/concurrent/Executor;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/github/jasync/sql/db/SSLConfiguration;Ljava/nio/charset/Charset;ILio/netty/buffer/ByteBufAllocator;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)Lcom/github/jasync/sql/db/ConnectionPoolConfiguration;", "equals", "", "other", "hashCode", "toString", "jasync-common"})
public final class ConnectionPoolConfiguration {
    @NotNull
    private final String host;
    private final int port;
    @Nullable
    private final String database;
    @NotNull
    private final String username;
    @Nullable
    private final String password;
    private final int maxActiveConnections;
    private final long maxIdleTime;
    private final int maxPendingQueries;
    private final long connectionValidationInterval;
    private final long connectionCreateTimeout;
    private final long connectionTestTimeout;
    @Nullable
    private final Long queryTimeout;
    @NotNull
    private final EventLoopGroup eventLoopGroup;
    @NotNull
    private final Executor executionContext;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final SSLConfiguration ssl;
    @NotNull
    private final Charset charset;
    private final int maximumMessageSize;
    @NotNull
    private final ByteBufAllocator allocator;
    @Nullable
    private final String applicationName;
    @NotNull
    private final List<Supplier<QueryInterceptor>> interceptors;
    @Nullable
    private final Long maxConnectionTtl;
    @Nullable
    private final String currentSchema;
    @Nullable
    private final String socketPath;
    @NotNull
    private final Configuration connectionConfiguration;
    @NotNull
    private final PoolConfiguration poolConfiguration;

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName, @NotNull List<? extends Supplier<QueryInterceptor>> interceptors, @Nullable Long maxConnectionTtl, @Nullable String currentSchema, @Nullable String socketPath) {
        long it;
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this.host = host2;
        this.port = port2;
        this.database = database;
        this.username = username;
        this.password = password;
        this.maxActiveConnections = maxActiveConnections;
        this.maxIdleTime = maxIdleTime;
        this.maxPendingQueries = maxPendingQueries;
        this.connectionValidationInterval = connectionValidationInterval;
        this.connectionCreateTimeout = connectionCreateTimeout;
        this.connectionTestTimeout = connectionTestTimeout;
        this.queryTimeout = queryTimeout;
        this.eventLoopGroup = eventLoopGroup;
        this.executionContext = executionContext;
        this.coroutineDispatcher = coroutineDispatcher;
        this.ssl = ssl;
        this.charset = charset;
        this.maximumMessageSize = maximumMessageSize;
        this.allocator = allocator;
        this.applicationName = applicationName;
        this.interceptors = interceptors;
        this.maxConnectionTtl = maxConnectionTtl;
        this.currentSchema = currentSchema;
        this.socketPath = socketPath;
        if (!(this.port > 0)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$92 = false;
            String $i$a$-require-ConnectionPoolConfiguration$92 = "port should be positive: " + this.port;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$92.toString());
        }
        if (!(this.maximumMessageSize > 0)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$102 = false;
            String $i$a$-require-ConnectionPoolConfiguration$102 = "maximumMessageSize should be positive: " + this.maximumMessageSize;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$102.toString());
        }
        if (!(this.maxActiveConnections > 0)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$112 = false;
            String $i$a$-require-ConnectionPoolConfiguration$112 = "maxActiveConnections should be positive: " + this.maxActiveConnections;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$112.toString());
        }
        if (!(this.maxIdleTime >= 0L)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$122 = false;
            String $i$a$-require-ConnectionPoolConfiguration$122 = "maxIdleTime should not be negative: " + this.maxIdleTime;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$122.toString());
        }
        if (!(this.maxPendingQueries >= 0)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$132 = false;
            String $i$a$-require-ConnectionPoolConfiguration$132 = "maxPendingQueries should not be negative: " + this.maxPendingQueries;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$132.toString());
        }
        if (!(this.connectionValidationInterval >= 0L)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$142 = false;
            String $i$a$-require-ConnectionPoolConfiguration$142 = "connectionValidationInterval should not be negative: " + this.connectionValidationInterval;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$142.toString());
        }
        if (!(this.connectionCreateTimeout >= 0L)) {
            boolean $i$a$-require-ConnectionPoolConfiguration$152 = false;
            String $i$a$-require-ConnectionPoolConfiguration$152 = "connectionCreateTimeout should not be negative: " + this.connectionCreateTimeout;
            throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$152.toString());
        }
        if (!(this.connectionTestTimeout >= 0L)) {
            boolean bl = false;
            String string = "connectionTestTimeout should not be negative: " + this.connectionTestTimeout;
            throw new IllegalArgumentException(string.toString());
        }
        Long l = this.queryTimeout;
        if (l != null) {
            it = ((Number)l).longValue();
            boolean bl = false;
            if (!(it >= 0L)) {
                boolean $i$a$-require-ConnectionPoolConfiguration$9$22 = false;
                String $i$a$-require-ConnectionPoolConfiguration$9$22 = "queryTimeout should not be negative: " + it;
                throw new IllegalArgumentException($i$a$-require-ConnectionPoolConfiguration$9$22.toString());
            }
        }
        Long l2 = this.maxConnectionTtl;
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl = false;
            if (!(it >= 0L)) {
                boolean bl2 = false;
                String string = "queryTimeout should not be negative: " + it;
                throw new IllegalArgumentException(string.toString());
            }
        }
        String string = this.username;
        String string2 = this.host;
        int n = this.port;
        Object object = this.password;
        String string3 = this.database;
        SSLConfiguration sSLConfiguration = this.ssl;
        Charset charset2 = this.charset;
        int n2 = this.maximumMessageSize;
        ByteBufAllocator byteBufAllocator = this.allocator;
        int n3 = (int)this.connectionCreateTimeout;
        Duration duration = (Duration)NullableUtilsKt.nullableMap(this.queryTimeout, connectionConfiguration.1.INSTANCE);
        Object object2 = this.applicationName;
        CoroutineDispatcher coroutineDispatcher2 = this.interceptors;
        Executor executor = this.executionContext;
        EventLoopGroup eventLoopGroup2 = this.eventLoopGroup;
        String string4 = this.currentSchema;
        String string5 = this.socketPath;
        this.connectionConfiguration = new Configuration(string, string2, n, (String)object, string3, sSLConfiguration, charset2, n2, byteBufAllocator, n3, duration, (String)object2, (List<? extends Supplier<QueryInterceptor>>)coroutineDispatcher2, eventLoopGroup2, executor, string4, string5);
        int n4 = this.maxActiveConnections;
        long l3 = this.maxIdleTime;
        object = this.maxConnectionTtl;
        int n5 = this.maxPendingQueries;
        long l4 = this.connectionValidationInterval;
        long l5 = this.connectionCreateTimeout * (long)2;
        long l6 = this.connectionTestTimeout;
        object2 = this.queryTimeout;
        coroutineDispatcher2 = this.coroutineDispatcher;
        this.poolConfiguration = new PoolConfiguration(n4, l3, n5, l4, l5, l6, (Long)object2, coroutineDispatcher2, (Long)object);
    }

    public /* synthetic */ ConnectionPoolConfiguration(String string, int n, String string2, String string3, String string4, int n2, long l, int n3, long l2, long l3, long l4, Long l5, EventLoopGroup eventLoopGroup, Executor executor, CoroutineDispatcher coroutineDispatcher, SSLConfiguration sSLConfiguration, Charset charset, int n4, ByteBufAllocator byteBufAllocator, String string5, List list, Long l6, String string6, String string7, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            string = "localhost";
        }
        if ((n5 & 2) != 0) {
            n = 5432;
        }
        if ((n5 & 4) != 0) {
            string2 = null;
        }
        if ((n5 & 8) != 0) {
            string3 = "dbuser";
        }
        if ((n5 & 0x10) != 0) {
            string4 = null;
        }
        if ((n5 & 0x20) != 0) {
            n2 = 1;
        }
        if ((n5 & 0x40) != 0) {
            l = TimeUnit.MINUTES.toMillis(1L);
        }
        if ((n5 & 0x80) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        if ((n5 & 0x100) != 0) {
            l2 = 5000L;
        }
        if ((n5 & 0x200) != 0) {
            l3 = 5000L;
        }
        if ((n5 & 0x400) != 0) {
            l4 = 5000L;
        }
        if ((n5 & 0x800) != 0) {
            l5 = null;
        }
        if ((n5 & 0x1000) != 0) {
            eventLoopGroup = NettyUtils.INSTANCE.getDefaultEventLoopGroup();
        }
        if ((n5 & 0x2000) != 0) {
            executor = ExecutorServiceUtils.INSTANCE.getCommonPool();
        }
        if ((n5 & 0x4000) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        if ((n5 & 0x8000) != 0) {
            sSLConfiguration = new SSLConfiguration(null, null, null, null, 15, null);
        }
        if ((n5 & 0x10000) != 0) {
            Charset charset2 = CharsetUtil.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        if ((n5 & 0x20000) != 0) {
            n4 = 0x1000000;
        }
        if ((n5 & 0x40000) != 0) {
            PooledByteBufAllocator pooledByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)pooledByteBufAllocator, (String)"DEFAULT");
            byteBufAllocator = (ByteBufAllocator)pooledByteBufAllocator;
        }
        if ((n5 & 0x80000) != 0) {
            string5 = null;
        }
        if ((n5 & 0x100000) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n5 & 0x200000) != 0) {
            l6 = null;
        }
        if ((n5 & 0x400000) != 0) {
            string6 = null;
        }
        if ((n5 & 0x800000) != 0) {
            string7 = null;
        }
        this(string, n, string2, string3, string4, n2, l, n3, l2, l3, l4, l5, eventLoopGroup, executor, coroutineDispatcher, sSLConfiguration, charset, n4, byteBufAllocator, string5, list, l6, string6, string7);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getDatabase() {
        return this.database;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final int getMaxActiveConnections() {
        return this.maxActiveConnections;
    }

    public final long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public final int getMaxPendingQueries() {
        return this.maxPendingQueries;
    }

    public final long getConnectionValidationInterval() {
        return this.connectionValidationInterval;
    }

    public final long getConnectionCreateTimeout() {
        return this.connectionCreateTimeout;
    }

    public final long getConnectionTestTimeout() {
        return this.connectionTestTimeout;
    }

    @Nullable
    public final Long getQueryTimeout() {
        return this.queryTimeout;
    }

    @NotNull
    public final EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @NotNull
    public final Executor getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public final CoroutineDispatcher getCoroutineDispatcher() {
        return this.coroutineDispatcher;
    }

    @NotNull
    public final SSLConfiguration getSsl() {
        return this.ssl;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @NotNull
    public final ByteBufAllocator getAllocator() {
        return this.allocator;
    }

    @Nullable
    public final String getApplicationName() {
        return this.applicationName;
    }

    @NotNull
    public final List<Supplier<QueryInterceptor>> getInterceptors() {
        return this.interceptors;
    }

    @Nullable
    public final Long getMaxConnectionTtl() {
        return this.maxConnectionTtl;
    }

    @Nullable
    public final String getCurrentSchema() {
        return this.currentSchema;
    }

    @Nullable
    public final String getSocketPath() {
        return this.socketPath;
    }

    @NotNull
    public final Configuration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    @NotNull
    public final PoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ConnectionPoolConfiguration(host=").append(this.host).append(", port=REDACTED, \n|database=").append(this.database).append(",username=REDACTED, password=REDACTED, socketPath=REDACTED, \n|currentSchema=").append(this.currentSchema).append("\n|maxActiveConnections=").append(this.maxActiveConnections).append(", \n|maxIdleTime=").append(this.maxIdleTime).append(", \n|maxPendingQueries=").append(this.maxPendingQueries).append(", \n|connectionValidationInterval=").append(this.connectionValidationInterval).append(", \n|connectionCreateTimeout=").append(this.connectionCreateTimeout).append(", \n|connectionTestTimeout=").append(this.connectionTestTimeout).append(", \n|queryTimeout=").append(this.queryTimeout).append(",\n|ssl=").append(this.ssl).append(", \n|charset=");
        stringBuilder.append(this.charset).append(", \n|maximumMessageSize=").append(this.maximumMessageSize).append(", \n|allocator=").append(this.allocator).append(", \n|applicationName=").append(this.applicationName).append(", \n|interceptors=").append(this.interceptors).append(", \n|maxConnectionTtl=").append(this.maxConnectionTtl).append("\n|)");
        return StringsKt.trimMargin$default((String)stringBuilder.toString(), null, (int)1, null);
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    public final int component2() {
        return this.port;
    }

    @Nullable
    public final String component3() {
        return this.database;
    }

    @NotNull
    public final String component4() {
        return this.username;
    }

    @Nullable
    public final String component5() {
        return this.password;
    }

    public final int component6() {
        return this.maxActiveConnections;
    }

    public final long component7() {
        return this.maxIdleTime;
    }

    public final int component8() {
        return this.maxPendingQueries;
    }

    public final long component9() {
        return this.connectionValidationInterval;
    }

    public final long component10() {
        return this.connectionCreateTimeout;
    }

    public final long component11() {
        return this.connectionTestTimeout;
    }

    @Nullable
    public final Long component12() {
        return this.queryTimeout;
    }

    @NotNull
    public final EventLoopGroup component13() {
        return this.eventLoopGroup;
    }

    @NotNull
    public final Executor component14() {
        return this.executionContext;
    }

    @NotNull
    public final CoroutineDispatcher component15() {
        return this.coroutineDispatcher;
    }

    @NotNull
    public final SSLConfiguration component16() {
        return this.ssl;
    }

    @NotNull
    public final Charset component17() {
        return this.charset;
    }

    public final int component18() {
        return this.maximumMessageSize;
    }

    @NotNull
    public final ByteBufAllocator component19() {
        return this.allocator;
    }

    @Nullable
    public final String component20() {
        return this.applicationName;
    }

    @NotNull
    public final List<Supplier<QueryInterceptor>> component21() {
        return this.interceptors;
    }

    @Nullable
    public final Long component22() {
        return this.maxConnectionTtl;
    }

    @Nullable
    public final String component23() {
        return this.currentSchema;
    }

    @Nullable
    public final String component24() {
        return this.socketPath;
    }

    @NotNull
    public final ConnectionPoolConfiguration copy(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName, @NotNull List<? extends Supplier<QueryInterceptor>> interceptors, @Nullable Long maxConnectionTtl, @Nullable String currentSchema, @Nullable String socketPath) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        return new ConnectionPoolConfiguration(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, applicationName, interceptors, maxConnectionTtl, currentSchema, socketPath);
    }

    public static /* synthetic */ ConnectionPoolConfiguration copy$default(ConnectionPoolConfiguration connectionPoolConfiguration, String string, int n, String string2, String string3, String string4, int n2, long l, int n3, long l2, long l3, long l4, Long l5, EventLoopGroup eventLoopGroup, Executor executor, CoroutineDispatcher coroutineDispatcher, SSLConfiguration sSLConfiguration, Charset charset, int n4, ByteBufAllocator byteBufAllocator, String string5, List list, Long l6, String string6, String string7, int n5, Object object) {
        if ((n5 & 1) != 0) {
            string = connectionPoolConfiguration.host;
        }
        if ((n5 & 2) != 0) {
            n = connectionPoolConfiguration.port;
        }
        if ((n5 & 4) != 0) {
            string2 = connectionPoolConfiguration.database;
        }
        if ((n5 & 8) != 0) {
            string3 = connectionPoolConfiguration.username;
        }
        if ((n5 & 0x10) != 0) {
            string4 = connectionPoolConfiguration.password;
        }
        if ((n5 & 0x20) != 0) {
            n2 = connectionPoolConfiguration.maxActiveConnections;
        }
        if ((n5 & 0x40) != 0) {
            l = connectionPoolConfiguration.maxIdleTime;
        }
        if ((n5 & 0x80) != 0) {
            n3 = connectionPoolConfiguration.maxPendingQueries;
        }
        if ((n5 & 0x100) != 0) {
            l2 = connectionPoolConfiguration.connectionValidationInterval;
        }
        if ((n5 & 0x200) != 0) {
            l3 = connectionPoolConfiguration.connectionCreateTimeout;
        }
        if ((n5 & 0x400) != 0) {
            l4 = connectionPoolConfiguration.connectionTestTimeout;
        }
        if ((n5 & 0x800) != 0) {
            l5 = connectionPoolConfiguration.queryTimeout;
        }
        if ((n5 & 0x1000) != 0) {
            eventLoopGroup = connectionPoolConfiguration.eventLoopGroup;
        }
        if ((n5 & 0x2000) != 0) {
            executor = connectionPoolConfiguration.executionContext;
        }
        if ((n5 & 0x4000) != 0) {
            coroutineDispatcher = connectionPoolConfiguration.coroutineDispatcher;
        }
        if ((n5 & 0x8000) != 0) {
            sSLConfiguration = connectionPoolConfiguration.ssl;
        }
        if ((n5 & 0x10000) != 0) {
            charset = connectionPoolConfiguration.charset;
        }
        if ((n5 & 0x20000) != 0) {
            n4 = connectionPoolConfiguration.maximumMessageSize;
        }
        if ((n5 & 0x40000) != 0) {
            byteBufAllocator = connectionPoolConfiguration.allocator;
        }
        if ((n5 & 0x80000) != 0) {
            string5 = connectionPoolConfiguration.applicationName;
        }
        if ((n5 & 0x100000) != 0) {
            list = connectionPoolConfiguration.interceptors;
        }
        if ((n5 & 0x200000) != 0) {
            l6 = connectionPoolConfiguration.maxConnectionTtl;
        }
        if ((n5 & 0x400000) != 0) {
            string6 = connectionPoolConfiguration.currentSchema;
        }
        if ((n5 & 0x800000) != 0) {
            string7 = connectionPoolConfiguration.socketPath;
        }
        return connectionPoolConfiguration.copy(string, n, string2, string3, string4, n2, l, n3, l2, l3, l4, l5, eventLoopGroup, executor, coroutineDispatcher, sSLConfiguration, charset, n4, byteBufAllocator, string5, list, l6, string6, string7);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + this.username.hashCode();
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + Integer.hashCode(this.maxActiveConnections);
        result = result * 31 + Long.hashCode(this.maxIdleTime);
        result = result * 31 + Integer.hashCode(this.maxPendingQueries);
        result = result * 31 + Long.hashCode(this.connectionValidationInterval);
        result = result * 31 + Long.hashCode(this.connectionCreateTimeout);
        result = result * 31 + Long.hashCode(this.connectionTestTimeout);
        result = result * 31 + (this.queryTimeout == null ? 0 : ((Object)this.queryTimeout).hashCode());
        result = result * 31 + this.eventLoopGroup.hashCode();
        result = result * 31 + this.executionContext.hashCode();
        result = result * 31 + this.coroutineDispatcher.hashCode();
        result = result * 31 + this.ssl.hashCode();
        result = result * 31 + this.charset.hashCode();
        result = result * 31 + Integer.hashCode(this.maximumMessageSize);
        result = result * 31 + this.allocator.hashCode();
        result = result * 31 + (this.applicationName == null ? 0 : this.applicationName.hashCode());
        result = result * 31 + ((Object)this.interceptors).hashCode();
        result = result * 31 + (this.maxConnectionTtl == null ? 0 : ((Object)this.maxConnectionTtl).hashCode());
        result = result * 31 + (this.currentSchema == null ? 0 : this.currentSchema.hashCode());
        result = result * 31 + (this.socketPath == null ? 0 : this.socketPath.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionPoolConfiguration)) {
            return false;
        }
        ConnectionPoolConfiguration connectionPoolConfiguration = (ConnectionPoolConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)connectionPoolConfiguration.host)) {
            return false;
        }
        if (this.port != connectionPoolConfiguration.port) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.database, (Object)connectionPoolConfiguration.database)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.username, (Object)connectionPoolConfiguration.username)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)connectionPoolConfiguration.password)) {
            return false;
        }
        if (this.maxActiveConnections != connectionPoolConfiguration.maxActiveConnections) {
            return false;
        }
        if (this.maxIdleTime != connectionPoolConfiguration.maxIdleTime) {
            return false;
        }
        if (this.maxPendingQueries != connectionPoolConfiguration.maxPendingQueries) {
            return false;
        }
        if (this.connectionValidationInterval != connectionPoolConfiguration.connectionValidationInterval) {
            return false;
        }
        if (this.connectionCreateTimeout != connectionPoolConfiguration.connectionCreateTimeout) {
            return false;
        }
        if (this.connectionTestTimeout != connectionPoolConfiguration.connectionTestTimeout) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.queryTimeout, (Object)connectionPoolConfiguration.queryTimeout)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.eventLoopGroup, (Object)connectionPoolConfiguration.eventLoopGroup)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.executionContext, (Object)connectionPoolConfiguration.executionContext)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.coroutineDispatcher, (Object)connectionPoolConfiguration.coroutineDispatcher)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ssl, (Object)connectionPoolConfiguration.ssl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.charset, (Object)connectionPoolConfiguration.charset)) {
            return false;
        }
        if (this.maximumMessageSize != connectionPoolConfiguration.maximumMessageSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.allocator, (Object)connectionPoolConfiguration.allocator)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.applicationName, (Object)connectionPoolConfiguration.applicationName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.interceptors, connectionPoolConfiguration.interceptors)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxConnectionTtl, (Object)connectionPoolConfiguration.maxConnectionTtl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentSchema, (Object)connectionPoolConfiguration.currentSchema)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.socketPath, (Object)connectionPoolConfiguration.socketPath);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName, @NotNull List<? extends Supplier<QueryInterceptor>> interceptors, @Nullable Long maxConnectionTtl, @Nullable String currentSchema) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, applicationName, interceptors, maxConnectionTtl, currentSchema, null, 0x800000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName, @NotNull List<? extends Supplier<QueryInterceptor>> interceptors, @Nullable Long maxConnectionTtl) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, applicationName, interceptors, maxConnectionTtl, null, null, 0xC00000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName, @NotNull List<? extends Supplier<QueryInterceptor>> interceptors) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, applicationName, interceptors, null, null, null, 0xE00000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator, @Nullable String applicationName) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, applicationName, null, null, null, null, 0xF00000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)allocator, (String)"allocator");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, allocator, null, null, null, null, null, 0xF80000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset, int maximumMessageSize) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, maximumMessageSize, null, null, null, null, null, null, 0xFC0000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, charset, 0, null, null, null, null, null, null, 0xFE0000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SSLConfiguration ssl) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, ssl, null, 0, null, null, null, null, null, null, 0xFF0000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, coroutineDispatcher, null, null, 0, null, null, null, null, null, null, 0xFF8000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup, @NotNull Executor executionContext) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, executionContext, null, null, null, 0, null, null, null, null, null, null, 0xFFC000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout, @NotNull EventLoopGroup eventLoopGroup) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)eventLoopGroup, (String)"eventLoopGroup");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, eventLoopGroup, null, null, null, null, 0, null, null, null, null, null, null, 0xFFE000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout, @Nullable Long queryTimeout) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, queryTimeout, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFF000, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout, long connectionTestTimeout) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, connectionTestTimeout, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFF800, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval, long connectionCreateTimeout) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, connectionCreateTimeout, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFC00, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries, long connectionValidationInterval) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, connectionValidationInterval, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFE00, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime, int maxPendingQueries) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, maxPendingQueries, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFF00, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections, long maxIdleTime) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, maxIdleTime, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFF80, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password, int maxActiveConnections) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, maxActiveConnections, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFC0, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, password, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFE0, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        this(host2, port2, database, username, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFF0, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2, @Nullable String database) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this(host2, port2, database, null, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFF8, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2, int port2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this(host2, port2, null, null, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFFC, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration(@NotNull String host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this(host2, 0, null, null, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFFE, null);
    }

    @JvmOverloads
    public ConnectionPoolConfiguration() {
        this(null, 0, null, null, null, 0, 0L, 0, 0L, 0L, 0L, null, null, null, null, null, null, 0, null, null, null, null, null, null, 0xFFFFFF, null);
    }
}

