/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db;

import com.github.jasync.sql.db.ConcreteConnection;
import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.interceptor.ConnectionInterceptorHelperKt;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.util.FP;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.Try;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f0\u000fH\u0016J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u001d\u001a\u00020\u001eH&J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0016\u001a\u00020\u0017H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/github/jasync/sql/db/ConcreteConnectionBase;", "Lcom/github/jasync/sql/db/ConcreteConnection;", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "(Lcom/github/jasync/sql/db/Configuration;)V", "getConfiguration", "()Lcom/github/jasync/sql/db/Configuration;", "creationTime", "", "getCreationTime", "()J", "inTransaction", "Ljava/util/concurrent/CompletableFuture;", "A", "f", "Lkotlin/Function1;", "Lcom/github/jasync/sql/db/Connection;", "releaseIfNeeded", "Lcom/github/jasync/sql/db/QueryResult;", "release", "", "promise", "query", "", "sendPreparedStatement", "values", "", "", "sendPreparedStatementDirect", "params", "Lcom/github/jasync/sql/db/interceptor/PreparedStatementParams;", "sendQuery", "sendQueryDirect", "jasync-common"})
public abstract class ConcreteConnectionBase
implements ConcreteConnection {
    @NotNull
    private final Configuration configuration;
    private final long creationTime;

    public ConcreteConnectionBase(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.creationTime = System.currentTimeMillis();
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <A> CompletableFuture<A> inTransaction(@NotNull Function1<? super Connection, ? extends CompletableFuture<A>> f) {
        void $this$flatMapAsync$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        CompletableFuture<QueryResult> completableFuture = this.sendQuery("BEGIN");
        Executor executor$iv = this.configuration.getExecutionContext();
        boolean $i$f$flatMapAsync = false;
        CompletionStage completionStage = $this$flatMapAsync$iv.thenComposeAsync(new Function(f, this){
            final /* synthetic */ Function1 $f$inlined;
            final /* synthetic */ ConcreteConnectionBase this$0;
            {
                this.$f$inlined = function1;
                this.this$0 = concreteConnectionBase;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            @NotNull
            public final CompletableFuture apply(Object it) {
                void $this$onCompleteAsync$iv;
                QueryResult it2 = (QueryResult)it;
                boolean bl = false;
                CompletableFuture<T> p = new CompletableFuture<T>();
                CompletableFuture completableFuture = (CompletableFuture)this.$f$inlined.invoke((Object)this.this$0);
                Executor executor$iv = this.this$0.getConfiguration().getExecutionContext();
                boolean $i$f$onCompleteAsync = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(this.this$0, p){
                    final /* synthetic */ ConcreteConnectionBase this$0;
                    final /* synthetic */ CompletableFuture $p$inlined;
                    {
                        this.this$0 = concreteConnectionBase;
                        this.$p$inlined = completableFuture;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void accept(A a, Throwable t) {
                        void $this$onCompleteAsync$iv;
                        Throwable throwable = t;
                        Try ty1 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                        boolean bl = false;
                        CompletableFuture<QueryResult> completableFuture = this.this$0.sendQuery(ty1.isFailure() ? "ROLLBACK" : "COMMIT");
                        Executor executor$iv = this.this$0.getConfiguration().getExecutionContext();
                        boolean $i$f$onCompleteAsync = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(ty1, this.$p$inlined){
                            final /* synthetic */ Try $ty1$inlined;
                            final /* synthetic */ CompletableFuture $p$inlined;
                            {
                                this.$ty1$inlined = try_;
                                this.$p$inlined = completableFuture;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void accept(Object a, Throwable t) {
                                Throwable throwable = t;
                                Try ty2 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                                boolean bl = false;
                                if (ty2.isFailure() && this.$ty1$inlined.isSuccess()) {
                                    FutureUtilsKt.failed((CompletableFuture)this.$p$inlined, (Throwable)((Failure)ty2).getException());
                                } else {
                                    FutureUtilsKt.complete((CompletableFuture)this.$p$inlined, (Try)this.$ty1$inlined);
                                }
                            }
                        }, executor$iv), (String)"crossinline onCompleteFu\u2026},\n        executor\n    )");
                    }
                }, executor$iv), (String)"crossinline onCompleteFu\u2026},\n        executor\n    )");
                return p;
            }
        }, executor$iv);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A) -> Co\u2026tion { f(it) }, executor)");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final CompletableFuture<QueryResult> releaseIfNeeded(boolean release, @NotNull CompletableFuture<QueryResult> promise, @NotNull String query) {
        CompletableFuture<QueryResult> completableFuture;
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (!release) {
            completableFuture = promise;
        } else {
            void $this$flatten$iv$iv;
            CompletableFuture<QueryResult> $this$flatMapTry$iv = promise;
            boolean $i$f$flatMapTry = false;
            CompletionStage<QueryResult> $this$mapTry$iv$iv = $this$flatMapTry$iv;
            boolean $i$f$mapTry = false;
            CompletionStage completionStage = $this$mapTry$iv$iv.handle(new BiFunction(this, query){
                final /* synthetic */ ConcreteConnectionBase this$0;
                final /* synthetic */ String $query$inlined;
                {
                    this.this$0 = concreteConnectionBase;
                    this.$query$inlined = string;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object apply(Object a, @Nullable Throwable t) {
                    void throwable;
                    Throwable throwable2 = t;
                    QueryResult queryResult = (QueryResult)a;
                    boolean bl = false;
                    CompletableFuture<Boolean> $this$map$iv = this.this$0.releasePreparedStatement(this.$query$inlined);
                    boolean $i$f$map = false;
                    CompletionStage<T> completionStage = $this$map$iv.thenApply(new Function(queryResult){
                        final /* synthetic */ QueryResult $queryResult$inlined;
                        {
                            this.$queryResult$inlined = queryResult;
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final Object apply(Object it) {
                            boolean it2 = (Boolean)it;
                            boolean bl = false;
                            return this.$queryResult$inlined;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A) -> B)\u2026=\n    thenApply { f(it) }");
                    CompletionStage<T> released = completionStage;
                    return throwable != null ? FP.INSTANCE.failed((Throwable)throwable) : released;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A, Throw\u2026: Throwable? -> f(a, t) }");
            $this$mapTry$iv$iv = completionStage;
            boolean $i$f$flatten = false;
            CompletableFuture future$iv$iv = new CompletableFuture();
            void $this$mapTry$iv$iv$iv = $this$flatten$iv$iv;
            boolean $i$f$mapTry2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTry$iv$iv$iv.handle(new BiFunction(future$iv$iv){
                final /* synthetic */ CompletableFuture $future$inlined;
                {
                    this.$future$inlined = completableFuture;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object apply(Object a, @Nullable Throwable t) {
                    Object object;
                    void throwable;
                    Throwable throwable2 = t;
                    CompletableFuture completableFuture = (CompletableFuture)a;
                    boolean bl = false;
                    if (throwable == null) {
                        CompletableFuture $this$mapTry$iv = completableFuture;
                        boolean $i$f$mapTry = false;
                        CompletionStage completionStage = $this$mapTry$iv.handle(new BiFunction(this.$future$inlined){
                            final /* synthetic */ CompletableFuture $future$inlined;
                            {
                                this.$future$inlined = completableFuture;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            public final Object apply(Object a, @Nullable Throwable t) {
                                void throwable2;
                                Throwable throwable = t;
                                Object a2 = a;
                                boolean bl = false;
                                return throwable2 == null ? this.$future$inlined.complete(a2) : this.$future$inlined.completeExceptionally((Throwable)throwable2);
                            }
                        });
                        object = completionStage;
                        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A, Throw\u2026: Throwable? -> f(a, t) }");
                    } else {
                        object = this.$future$inlined.completeExceptionally((Throwable)throwable);
                    }
                    return object;
                }
            }), (String)"crossinline f: (A, Throw\u2026: Throwable? -> f(a, t) }");
            completableFuture = future$iv$iv;
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return ConnectionInterceptorHelperKt.wrapQueryWithInterceptors(query, this.configuration.getInterceptors(), (Function1<? super String, ? extends CompletableFuture<QueryResult>>)((Function1)new Function1<String, CompletableFuture<QueryResult>>(this){
            final /* synthetic */ ConcreteConnectionBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull String q) {
                Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                return this.this$0.sendQueryDirect(q);
            }
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values, boolean release) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return ConnectionInterceptorHelperKt.wrapPreparedStatementWithInterceptors(new PreparedStatementParams(query, values, release), this.configuration.getInterceptors(), (Function1<? super PreparedStatementParams, ? extends CompletableFuture<QueryResult>>)((Function1)new Function1<PreparedStatementParams, CompletableFuture<QueryResult>>(this){
            final /* synthetic */ ConcreteConnectionBase this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<QueryResult> invoke(@NotNull PreparedStatementParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                return this.this$0.sendPreparedStatementDirect(params);
            }
        }));
    }

    @Override
    @NotNull
    public abstract CompletableFuture<QueryResult> sendQueryDirect(@NotNull String var1);

    @Override
    @NotNull
    public abstract CompletableFuture<QueryResult> sendPreparedStatementDirect(@NotNull PreparedStatementParams var1);

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query, @NotNull List<? extends Object> values) {
        return ConcreteConnection.DefaultImpls.sendPreparedStatement(this, query, values);
    }

    @Override
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatement(@NotNull String query) {
        return ConcreteConnection.DefaultImpls.sendPreparedStatement(this, query);
    }
}

