/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.util;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.exceptions.UnableToParseURLException;
import com.github.jasync.sql.db.util.AbstractURIParser;
import com.github.jasync.sql.db.util.AbstractURIParserKt;
import com.github.jasync.sql.db.util.NullableUtilsKt;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0004J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/github/jasync/sql/db/util/AbstractURIParser;", "", "()V", "DEFAULT", "Lcom/github/jasync/sql/db/Configuration;", "getDEFAULT", "()Lcom/github/jasync/sql/db/Configuration;", "SCHEME", "Lkotlin/text/Regex;", "getSCHEME", "()Lkotlin/text/Regex;", "assembleConfiguration", "properties", "", "", "charset", "Ljava/nio/charset/Charset;", "handleJDBC", "uri", "Ljava/net/URI;", "parse", "url", "parseOrDie", "parseUserInfo", "Lkotlin/Pair;", "userInfo", "unwrapIpv6address", "server", "Companion", "jasync-common"})
public abstract class AbstractURIParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PORT = "port";
    @NotNull
    public static final String DBNAME = "database";
    @NotNull
    public static final String HOST = "host";
    @NotNull
    public static final String USERNAME = "user";
    @NotNull
    public static final String PASSWORD = "password";
    @NotNull
    public static final String SCHEMA = "currentSchema";

    @NotNull
    protected final Pair<String, String> parseUserInfo(@Nullable String userInfo) {
        List split2 = (List)NullableUtilsKt.nullableMap(userInfo, parseUserInfo.split.1.INSTANCE);
        return split2 != null && split2.size() >= 2 ? TuplesKt.to(split2.get(0), split2.get(1)) : (split2 != null && split2.size() == 1 ? TuplesKt.to(split2.get(0), null) : TuplesKt.to(null, null));
    }

    @NotNull
    protected abstract Regex getSCHEME();

    @NotNull
    public abstract Configuration getDEFAULT();

    @NotNull
    public final Configuration parseOrDie(@NotNull String url, @NotNull Charset charset) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            URI uRI = new URI(url).parseServerAuthority();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI(url).parseServerAuthority()");
            Map<String, String> properties = this.parse(uRI);
            configuration = this.assembleConfiguration(properties, charset);
        }
        catch (URISyntaxException e) {
            throw new UnableToParseURLException("Failed to parse URL: " + url, e);
        }
        return configuration;
    }

    public static /* synthetic */ Configuration parseOrDie$default(AbstractURIParser abstractURIParser, String string, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseOrDie");
        }
        if ((n & 2) != 0) {
            charset = abstractURIParser.getDEFAULT().getCharset();
        }
        return abstractURIParser.parseOrDie(string, charset);
    }

    @NotNull
    public final Configuration parse(@NotNull String url, @NotNull Charset charset) {
        Configuration configuration;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            configuration = this.parseOrDie(url, charset);
        }
        catch (Exception e) {
            AbstractURIParserKt.access$getLogger$p().warn("Connection url '" + url + "' could not be parsed.", (Throwable)e);
            configuration = this.getDEFAULT();
        }
        return configuration;
    }

    public static /* synthetic */ Configuration parse$default(AbstractURIParser abstractURIParser, String string, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parse");
        }
        if ((n & 2) != 0) {
            charset = abstractURIParser.getDEFAULT().getCharset();
        }
        return abstractURIParser.parse(string, charset);
    }

    @NotNull
    protected Configuration assembleConfiguration(@NotNull Map<String, String> properties, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Configuration configuration = this.getDEFAULT();
        Object object = properties;
        String string = object.get(USERNAME);
        if (string == null) {
            boolean bl = false;
            string = this.getDEFAULT().getUsername();
        }
        String string2 = string;
        object = properties.get(PASSWORD);
        String string3 = properties.get(DBNAME);
        Map<String, String> map2 = properties;
        String string4 = map2.get(HOST);
        if (string4 == null) {
            boolean bl = false;
            string4 = this.getDEFAULT().getHost();
        }
        String string5 = string4;
        String string6 = properties.get(PORT);
        int n = string6 != null ? Integer.parseInt(string6) : this.getDEFAULT().getPort();
        SSLConfiguration sSLConfiguration = new SSLConfiguration(properties);
        return Configuration.copy$default(configuration, string2, string5, n, (String)object, string3, sSLConfiguration, charset, 0, null, 0, null, null, null, null, null, null, null, 130944, null);
    }

    @NotNull
    protected final Map<String, String> parse(@NotNull URI uri) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.scheme");
        CharSequence charSequence = string;
        if (this.getSCHEME().matches(charSequence)) {
            Object object;
            String[] $this$parse_u24lambda_u2d6;
            String string2;
            String string3;
            Object object2;
            Integer n;
            String string4;
            String string5;
            Pair<String, String> userInfo = this.parseUserInfo(uri.getUserInfo());
            Integer port2 = NullableUtilsKt.nullableFilter(uri.getPort(), parse.port.1.INSTANCE);
            String db2 = (String)NullableUtilsKt.nullableFilter(NullableUtilsKt.nullableMap(uri.getPath(), parse.db.1.INSTANCE), parse.db.2.INSTANCE);
            String host2 = (String)NullableUtilsKt.nullableMap(uri.getHost(), parse.host.1.INSTANCE);
            Map map3 = new LinkedHashMap();
            String string6 = (String)userInfo.getFirst();
            if (string6 != null && (string6 = (Pair)NullableUtilsKt.nullableMap(string6, parse.1.INSTANCE)) != null) {
                String $this$parse_u24lambda_u2d2 = string5 = string6;
                boolean bl = false;
                map3.put($this$parse_u24lambda_u2d2.getFirst(), $this$parse_u24lambda_u2d2.getSecond());
            }
            if ((string4 = (String)userInfo.getSecond()) != null && (string4 = (Pair)NullableUtilsKt.nullableMap(string4, parse.3.INSTANCE)) != null) {
                String $this$parse_u24lambda_u2d3 = string5 = string4;
                boolean bl = false;
                map3.put($this$parse_u24lambda_u2d3.getFirst(), $this$parse_u24lambda_u2d3.getSecond());
            }
            if ((n = port2) != null && (n = (Pair)NullableUtilsKt.nullableMap(n, parse.5.INSTANCE)) != null) {
                object2 = n;
                Integer $this$parse_u24lambda_u2d4 = object2;
                boolean bl = false;
                map3.put($this$parse_u24lambda_u2d4.getFirst(), $this$parse_u24lambda_u2d4.getSecond());
            }
            if ((string3 = db2) != null && (string3 = (Pair)NullableUtilsKt.nullableMap(string3, parse.7.INSTANCE)) != null) {
                Object $this$parse_u24lambda_u2d5 = object2 = string3;
                boolean bl = false;
                map3.put($this$parse_u24lambda_u2d5.getFirst(), $this$parse_u24lambda_u2d5.getSecond());
            }
            if ((string2 = host2) != null && (string2 = (Pair)NullableUtilsKt.nullableMap(string2, (Function1)new Function1<String, Pair<? extends String, ? extends String>>(this){
                final /* synthetic */ AbstractURIParser this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Pair<String, String> invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return TuplesKt.to((Object)"host", (Object)this.this$0.unwrapIpv6address(it));
                }
            })) != null) {
                object2 = string2;
                $this$parse_u24lambda_u2d6 = object2;
                boolean bl = false;
                map3.put($this$parse_u24lambda_u2d6.getFirst(), $this$parse_u24lambda_u2d6.getSecond());
            }
            if ((object = uri.getQuery()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])($this$parse_u24lambda_u2d6 = new String[]{"&"}), (boolean)false, (int)0, (int)6, null)) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String keyValue = (String)element$iv;
                    boolean bl = false;
                    Object object3 = new String[]{"="};
                    List split2 = StringsKt.split$default((CharSequence)keyValue, (String[])object3, (boolean)false, (int)0, (int)6, null);
                    if (split2.size() != 2 || !(!StringsKt.isBlank((CharSequence)((CharSequence)split2.get(0)))) || !(!StringsKt.isBlank((CharSequence)((CharSequence)split2.get(1))))) continue;
                    object3 = map3;
                    Pair pair = TuplesKt.to((Object)URLDecoder.decode((String)split2.get(0), "UTF-8"), (Object)URLDecoder.decode((String)split2.get(1), "UTF-8"));
                    object3.put(pair.getFirst(), pair.getSecond());
                }
            }
            map2 = map3;
        } else if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jdbc")) {
            map2 = this.handleJDBC(uri);
        } else {
            throw new UnableToParseURLException("Unrecognized URI scheme");
        }
        return map2;
    }

    @NotNull
    protected Map<String, String> handleJDBC(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.parse(new URI(uri.getSchemeSpecificPart()));
    }

    @NotNull
    protected final String unwrapIpv6address(@NotNull String server) {
        String string;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (StringsKt.startsWith$default((String)server, (String)"<", (boolean)false, (int)2, null)) {
            String string2 = server.substring(1, server.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = server;
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/jasync/sql/db/util/AbstractURIParser$Companion;", "", "()V", "DBNAME", "", "HOST", "PASSWORD", "PORT", "SCHEMA", "USERNAME", "jasync-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

