/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.mysql.binary.BinaryRowEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.BinaryEncoder;
import com.github.jasync.sql.db.mysql.column.ColumnTypes;
import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.message.client.PreparedStatementExecuteMessage;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00062\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/PreparedStatementExecuteEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "rowEncoder", "Lcom/github/jasync/sql/db/mysql/binary/BinaryRowEncoder;", "(Lcom/github/jasync/sql/db/mysql/binary/BinaryRowEncoder;)V", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "encodeValue", "", "parameterTypesBuffer", "parameterValuesBuffer", "value", "", "includeValue", "", "encodeValues", "values", "", "valuesToInclude", "", "", "jasync-mysql"})
public final class PreparedStatementExecuteEncoder
implements MessageEncoder {
    @NotNull
    private final BinaryRowEncoder rowEncoder;

    public PreparedStatementExecuteEncoder(@NotNull BinaryRowEncoder rowEncoder) {
        Intrinsics.checkNotNullParameter((Object)rowEncoder, (String)"rowEncoder");
        this.rowEncoder = rowEncoder;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        ByteBuf byteBuf;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PreparedStatementExecuteMessage m = (PreparedStatementExecuteMessage)message;
        ByteBuf buffer = ByteBufferUtils.packetBuffer();
        buffer.writeByte(m.getKind());
        buffer.writeBytes(m.getStatementId());
        buffer.writeByte(0);
        buffer.writeInt(1);
        if (m.getParameters().isEmpty()) {
            ByteBuf byteBuf2 = buffer;
            byteBuf = byteBuf2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"{\n            buffer\n        }");
        } else {
            ByteBuf[] byteBufArray = new ByteBuf[]{buffer, this.encodeValues(m.getValues(), m.getValuesToInclude())};
            ByteBuf byteBuf3 = Unpooled.wrappedBuffer((ByteBuf[])byteBufArray);
            byteBuf = byteBuf3;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf3, (String)"{\n            Unpooled.w\u2026luesToInclude))\n        }");
        }
        return byteBuf;
    }

    @NotNull
    public final ByteBuf encodeValues(@NotNull List<? extends Object> values, @NotNull Set<Integer> valuesToInclude) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(valuesToInclude, (String)"valuesToInclude");
        int nullBitsCount = (values.size() + 7) / 8;
        byte[] nullBits = new byte[nullBitsCount];
        ByteBuf bitMapBuffer = ByteBufferUtils.mysqlBuffer((int)(1 + nullBitsCount));
        ByteBuf parameterTypesBuffer = ByteBufferUtils.mysqlBuffer((int)(values.size() * 2));
        ByteBuf parameterValuesBuffer = ByteBufferUtils.mysqlBuffer();
        for (int index = 0; index < CollectionsUtilsKt.getLength((Collection)values); ++index) {
            Object value = values.get(index);
            if (value == null) {
                nullBits[index / 8] = (byte)(nullBits[index / 8] | (byte)(1 << (index & 7)));
                parameterTypesBuffer.writeShort(ColumnTypes.INSTANCE.getFIELD_TYPE_NULL());
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)parameterTypesBuffer, (String)"parameterTypesBuffer");
            Intrinsics.checkNotNullExpressionValue((Object)parameterValuesBuffer, (String)"parameterValuesBuffer");
            this.encodeValue(parameterTypesBuffer, parameterValuesBuffer, value, valuesToInclude.contains(index));
        }
        bitMapBuffer.writeBytes(nullBits);
        if (!((Collection)values).isEmpty()) {
            bitMapBuffer.writeByte(1);
        } else {
            bitMapBuffer.writeByte(0);
        }
        ByteBuf[] byteBufArray = new ByteBuf[]{bitMapBuffer, parameterTypesBuffer, parameterValuesBuffer};
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])byteBufArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(bitMapBuff\u2026r, parameterValuesBuffer)");
        return byteBuf;
    }

    public final void encodeValue(@NotNull ByteBuf parameterTypesBuffer, @NotNull ByteBuf parameterValuesBuffer, @NotNull Object value, boolean includeValue) {
        Intrinsics.checkNotNullParameter((Object)parameterTypesBuffer, (String)"parameterTypesBuffer");
        Intrinsics.checkNotNullParameter((Object)parameterValuesBuffer, (String)"parameterValuesBuffer");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BinaryEncoder encoder = this.rowEncoder.encoderFor(value);
        parameterTypesBuffer.writeShort(encoder.encodesTo());
        if (includeValue) {
            encoder.encode(value, parameterValuesBuffer);
        }
    }
}

