/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder.auth;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/auth/AuthenticationScrambler;", "", "()V", "scramble411", "", "algorithm", "", "password", "charset", "Ljava/nio/charset/Charset;", "seed", "seedFirst", "", "jasync-mysql"})
public final class AuthenticationScrambler {
    @NotNull
    public static final AuthenticationScrambler INSTANCE = new AuthenticationScrambler();

    private AuthenticationScrambler() {
    }

    @NotNull
    public final byte[] scramble411(@NotNull String algorithm, @NotNull String password, @NotNull Charset charset, @NotNull byte[] seed, boolean seedFirst) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        byte[] byArray = password.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] initialDigest = messageDigest.digest(byArray);
        messageDigest.reset();
        byte[] finalDigest = messageDigest.digest(initialDigest);
        messageDigest.reset();
        if (seedFirst) {
            messageDigest.update(seed);
            messageDigest.update(finalDigest);
        } else {
            messageDigest.update(finalDigest);
            messageDigest.update(seed);
        }
        byte[] result2 = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        byte[] byArray2 = result2;
        int n = byArray2.length;
        for (int j = 0; j < n; ++j) {
            int index = j;
            byte by = byArray2[j];
            result2[index] = (byte)(by ^ initialDigest[index]);
        }
        return result2;
    }
}

