/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.decoder;

import com.github.jasync.sql.db.mysql.decoder.HandshakeV10DecoderKt;
import com.github.jasync.sql.db.mysql.decoder.MessageDecoder;
import com.github.jasync.sql.db.mysql.message.server.HandshakeMessage;
import com.github.jasync.sql.db.mysql.message.server.ServerMessage;
import com.github.jasync.sql.db.mysql.util.CapabilityFlag;
import com.github.jasync.sql.db.util.ByteBufExtensionsKt;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/github/jasync/sql/db/mysql/decoder/HandshakeV10Decoder;", "Lcom/github/jasync/sql/db/mysql/decoder/MessageDecoder;", "()V", "decode", "Lcom/github/jasync/sql/db/mysql/message/server/ServerMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "Companion", "jasync-mysql"})
public final class HandshakeV10Decoder
implements MessageDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int SeedSize = 8;
    private static final int SeedComplementSize = 12;
    private static final int Padding = 10;
    private static final Charset ASCII = CharsetUtil.US_ASCII;

    @Override
    @NotNull
    public ServerMessage decode(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Charset charset = ASCII;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ASCII");
        String serverVersion = ByteBufExtensionsKt.readCString((ByteBuf)buffer, (Charset)charset);
        long connectionId = buffer.readUnsignedInt();
        byte[] seed = new byte[20];
        buffer.readBytes(seed, 0, 8);
        buffer.readByte();
        int serverCapabilityFlags = buffer.readUnsignedShort();
        byte characterSet = (byte)(buffer.readByte() & 0xFFFFFFFF);
        int statusFlags = buffer.readUnsignedShort();
        byte authPluginDataLength = 0;
        String authenticationMethod = "mysql_native_password";
        if (((serverCapabilityFlags |= buffer.readUnsignedShort() << 16) & CapabilityFlag.CLIENT_PLUGIN_AUTH.getValue()) != 0) {
            authPluginDataLength = (byte)(buffer.readByte() & 0xFFFFFFFF);
        } else {
            buffer.readByte();
        }
        buffer.readerIndex(buffer.readerIndex() + 10);
        HandshakeV10DecoderKt.access$getLogger$p().debug("Auth plugin data length was " + authPluginDataLength);
        if ((serverCapabilityFlags & CapabilityFlag.CLIENT_SECURE_CONNECTION.getValue()) != 0) {
            int complement = authPluginDataLength > 0 ? authPluginDataLength - 1 - 8 : 12;
            buffer.readBytes(seed, 8, complement);
            buffer.readByte();
        }
        if ((serverCapabilityFlags & CapabilityFlag.CLIENT_PLUGIN_AUTH.getValue()) != 0) {
            Charset charset2 = ASCII;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"ASCII");
            authenticationMethod = ByteBufExtensionsKt.readUntilEOF((ByteBuf)buffer, (Charset)charset2);
        }
        HandshakeMessage message = new HandshakeMessage(serverVersion, connectionId, seed, serverCapabilityFlags, characterSet, statusFlags, authenticationMethod);
        HandshakeV10DecoderKt.access$getLogger$p().debug((Function0)new Function0<Object>(message){
            final /* synthetic */ HandshakeMessage $message;
            {
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "handshake message was " + this.$message;
            }
        });
        return message;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/jasync/sql/db/mysql/decoder/HandshakeV10Decoder$Companion;", "", "()V", "ASCII", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "Padding", "", "SeedComplementSize", "SeedSize", "jasync-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

