/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.message.client.QueryMessage;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/QueryMessageEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "jasync-mysql"})
public final class QueryMessageEncoder
implements MessageEncoder {
    @NotNull
    private final Charset charset;

    public QueryMessageEncoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        QueryMessage m = (QueryMessage)message;
        byte[] byArray = m.getQuery().getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] encodedQuery = byArray;
        ByteBuf buffer = ByteBufferUtils.packetBuffer((int)(5 + encodedQuery.length));
        buffer.writeByte(3);
        buffer.writeBytes(encodedQuery);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        return buffer;
    }
}

