/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder.auth;

import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.jasync.sql.db.mysql.encoder.auth.Sha256PasswordAuthenticationKt;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/auth/Sha256PasswordAuthentication;", "Lcom/github/jasync/sql/db/mysql/encoder/auth/AuthenticationMethod;", "()V", "EmptyArray", "", "RsaHeaderRegex", "Lkotlin/text/Regex;", "generateAuthentication", "charset", "Ljava/nio/charset/Charset;", "password", "", "seed", "sslConfiguration", "Lcom/github/jasync/sql/db/SSLConfiguration;", "rsaPublicKey", "Ljava/nio/file/Path;", "getPublicKey", "Ljava/security/PublicKey;", "path", "jasync-mysql"})
public final class Sha256PasswordAuthentication
implements AuthenticationMethod {
    @NotNull
    public static final Sha256PasswordAuthentication INSTANCE = new Sha256PasswordAuthentication();
    @NotNull
    private static final byte[] EmptyArray = new byte[0];
    @NotNull
    private static final Regex RsaHeaderRegex = new Regex("(-+BEGIN PUBLIC KEY-+|-+END PUBLIC KEY-+|\\r?\\n)");

    private Sha256PasswordAuthentication() {
    }

    @Override
    @NotNull
    public byte[] generateAuthentication(@NotNull Charset charset, @Nullable String password, @NotNull byte[] seed, @NotNull SSLConfiguration sslConfiguration, @Nullable Path rsaPublicKey) {
        PublicKey publicKey2;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)sslConfiguration, (String)"sslConfiguration");
        if (password == null) {
            return EmptyArray;
        }
        byte[] byArray = password.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        byte[] result2 = new byte[CollectionsUtilsKt.getLength((byte[])bytes) + 1];
        ArraysKt.copyInto$default((byte[])bytes, (byte[])result2, (int)0, (int)0, (int)0, (int)14, null);
        if (sslConfiguration.getMode() != SSLConfiguration.Mode.Disable) {
            return result2;
        }
        if (rsaPublicKey == null) {
            throw new IllegalStateException("Authentication is not possible over an unsafe connection. Please use SSL or specify 'rsaPublicKey'");
        }
        int n = result2.length;
        for (int j = 0; j < n; ++j) {
            int index = j;
            byte by = result2[j];
            result2[index] = (byte)(by ^ seed[index % CollectionsUtilsKt.getLength((byte[])seed)]);
        }
        try {
            publicKey2 = this.getPublicKey(rsaPublicKey);
        }
        catch (Exception e) {
            Sha256PasswordAuthenticationKt.access$getLogger$p().error((Throwable)e, (Function0)new Function0<Object>(rsaPublicKey){
                final /* synthetic */ Path $rsaPublicKey;
                {
                    this.$rsaPublicKey = $rsaPublicKey;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unable to read the RSA public key at '" + this.$rsaPublicKey + '\'';
                }
            });
            throw e;
        }
        PublicKey publicKey3 = publicKey2;
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(1, publicKey3);
        byte[] byArray2 = cipher.doFinal(result2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(result)");
        return byArray2;
    }

    private final PublicKey getPublicKey(Path path) {
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(path)");
        Object object = byArray;
        Charset charset = Charsets.UTF_8;
        object = new String((byte[])object, charset);
        charset = RsaHeaderRegex;
        String string = "";
        String data = charset.replace((CharSequence)object, string);
        byte[] bytes = Base64.getDecoder().decode(data);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey publicKey2 = factory.generatePublic(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"factory.generatePublic(keySpec)");
        return publicKey2;
    }
}

