/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.pool;

import com.github.jasync.sql.db.pool.ActorBasedObjectPoolKt;
import com.github.jasync.sql.db.pool.ActorObjectPoolMessage;
import com.github.jasync.sql.db.pool.Close;
import com.github.jasync.sql.db.pool.Created;
import com.github.jasync.sql.db.pool.GiveBack;
import com.github.jasync.sql.db.pool.ItemInUseHolder;
import com.github.jasync.sql.db.pool.MaxTtlPassedException;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.pool.ObjectHolder;
import com.github.jasync.sql.db.pool.ObjectPoolActor;
import com.github.jasync.sql.db.pool.PoolAlreadyTerminatedException;
import com.github.jasync.sql.db.pool.PoolConfiguration;
import com.github.jasync.sql.db.pool.PoolExhaustedException;
import com.github.jasync.sql.db.pool.PoolObjectHolder;
import com.github.jasync.sql.db.pool.PooledObject;
import com.github.jasync.sql.db.pool.Take;
import com.github.jasync.sql.db.pool.TestPoolItems;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010<\u001a\u00020 2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0002J\b\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020?H\u0002J\b\u0010A\u001a\u00020?H\u0002J\u0016\u0010B\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000DH\u0002J\u0018\u0010E\u001a\u00020?2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)H\u0002J\u0016\u0010F\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000GH\u0002J\u0016\u0010H\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000IH\u0002J\u0016\u0010J\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000KH\u0002J\u0016\u0010L\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000DH\u0002J\b\u0010M\u001a\u00020?H\u0002J$\u0010N\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020.0\u000bH\u0002J\u0014\u0010P\u001a\u00020?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\rJ\b\u0010Q\u001a\u00020?H\u0002J\b\u0010R\u001a\u00020?H\u0002J\u0015\u0010S\u001a\u00020?2\u0006\u0010T\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010UJ\u0015\u0010V\u001a\u00020?2\u0006\u0010T\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010UJ)\u0010W\u001a\u00020?*\u00028\u00002\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000)2\b\b\u0002\u0010S\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010XJ\u0011\u0010Y\u001a\u00020?*\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010UR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R'\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010&\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000)0(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010*\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0019R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0015R\u0011\u00105\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0019R\u001d\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0\u00138F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0015R\u0011\u00109\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0019R \u0010;\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0(0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lcom/github/jasync/sql/db/pool/ObjectPoolActor;", "T", "Lcom/github/jasync/sql/db/pool/PooledObject;", "", "objectFactory", "Lcom/github/jasync/sql/db/pool/ObjectFactory;", "configuration", "Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "extraTimeForTimeoutCompletion", "", "channelProvider", "Lkotlin/Function0;", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/github/jasync/sql/db/pool/ActorObjectPoolMessage;", "(Lcom/github/jasync/sql/db/pool/ObjectFactory;Lcom/github/jasync/sql/db/pool/PoolConfiguration;JLkotlin/jvm/functions/Function0;)V", "availableItems", "Ljava/util/Queue;", "Lcom/github/jasync/sql/db/pool/PoolObjectHolder;", "availableItemsList", "", "getAvailableItemsList", "()Ljava/util/List;", "availableItemsSize", "", "getAvailableItemsSize", "()I", "channel", "getChannel", "()Lkotlinx/coroutines/channels/SendChannel;", "channel$delegate", "Lkotlin/Lazy;", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "createIndex", "inCreateItems", "", "Lcom/github/jasync/sql/db/pool/ObjectHolder;", "Ljava/util/concurrent/CompletableFuture;", "inUseItems", "Ljava/util/WeakHashMap;", "Lcom/github/jasync/sql/db/pool/ItemInUseHolder;", "poolStatusString", "", "getPoolStatusString", "()Ljava/lang/String;", "totalItems", "getTotalItems", "usedItemsList", "getUsedItemsList", "usedItemsSize", "getUsedItemsSize", "waitingForItemList", "getWaitingForItemList", "waitingForItemSize", "getWaitingForItemSize", "waitingQueue", "borrowFirstAvailableItem", "future", "checkItemsInCreationForTimeout", "", "checkItemsInTestOrQueryForTimeout", "checkWaitingFuturesForTimeout", "createNewItemPutInWaitQueue", "message", "Lcom/github/jasync/sql/db/pool/Take;", "createObject", "handleClose", "Lcom/github/jasync/sql/db/pool/Close;", "handleCreated", "Lcom/github/jasync/sql/db/pool/Created;", "handleGiveBack", "Lcom/github/jasync/sql/db/pool/GiveBack;", "handleTake", "handleTestPoolItems", "offerOrLog", "logMessage", "onReceive", "scheduleNewItemsIfNeeded", "sendAvailableItemsToTest", "validate", "item", "(Lcom/github/jasync/sql/db/pool/PooledObject;)V", "validateTtl", "borrowTo", "(Lcom/github/jasync/sql/db/pool/PooledObject;Ljava/util/concurrent/CompletableFuture;Z)V", "destroy", "jasync-pool"})
final class ObjectPoolActor<T extends PooledObject> {
    @NotNull
    private final ObjectFactory<T> objectFactory;
    @NotNull
    private final PoolConfiguration configuration;
    private final long extraTimeForTimeoutCompletion;
    @NotNull
    private final Function0<SendChannel<ActorObjectPoolMessage<T>>> channelProvider;
    @NotNull
    private final Queue<PoolObjectHolder<T>> availableItems;
    @NotNull
    private final Queue<ObjectHolder<CompletableFuture<T>>> waitingQueue;
    @NotNull
    private final WeakHashMap<T, ItemInUseHolder<T>> inUseItems;
    @NotNull
    private final Map<Integer, ObjectHolder<CompletableFuture<? extends T>>> inCreateItems;
    private int createIndex;
    @NotNull
    private final Lazy channel$delegate;
    private boolean closed;

    public ObjectPoolActor(@NotNull ObjectFactory<T> objectFactory, @NotNull PoolConfiguration configuration, long extraTimeForTimeoutCompletion, @NotNull Function0<? extends SendChannel<? super ActorObjectPoolMessage<T>>> channelProvider) {
        Intrinsics.checkNotNullParameter(objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(channelProvider, (String)"channelProvider");
        this.objectFactory = objectFactory;
        this.configuration = configuration;
        this.extraTimeForTimeoutCompletion = extraTimeForTimeoutCompletion;
        this.channelProvider = channelProvider;
        this.availableItems = new LinkedList();
        this.waitingQueue = new LinkedList();
        this.inUseItems = new WeakHashMap();
        this.inCreateItems = new LinkedHashMap();
        this.channel$delegate = LazyKt.lazy((Function0)new Function0<SendChannel<? super ActorObjectPoolMessage<T>>>(this){
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SendChannel<ActorObjectPoolMessage<T>> invoke() {
                return (SendChannel)ObjectPoolActor.access$getChannelProvider$p(this.this$0).invoke();
            }
        });
    }

    private final SendChannel<ActorObjectPoolMessage<T>> getChannel() {
        Lazy lazy = this.channel$delegate;
        return (SendChannel)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getAvailableItemsList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.availableItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PoolObjectHolder poolObjectHolder = (PoolObjectHolder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getItem());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<T> getUsedItemsList() {
        Set<T> set = this.inUseItems.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"inUseItems.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CompletableFuture<T>> getWaitingForItemList() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)this.waitingQueue);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ObjectHolder objectHolder = (ObjectHolder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletableFuture)it.getItem());
        }
        return (List)destination$iv$iv;
    }

    public final int getUsedItemsSize() {
        return this.inUseItems.size();
    }

    public final int getWaitingForItemSize() {
        return this.waitingQueue.size();
    }

    public final int getAvailableItemsSize() {
        return this.availableItems.size();
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    public final void onReceive(@NotNull ActorObjectPoolMessage<T> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(message, this){
            final /* synthetic */ ActorObjectPoolMessage<T> $message;
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "received message: " + this.$message + " ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
            }
        });
        ActorObjectPoolMessage<T> actorObjectPoolMessage = message;
        if (actorObjectPoolMessage instanceof Take) {
            this.handleTake((Take)message);
        } else if (actorObjectPoolMessage instanceof GiveBack) {
            this.handleGiveBack((GiveBack)message);
        } else if (actorObjectPoolMessage instanceof Created) {
            this.handleCreated((Created)message);
        } else if (actorObjectPoolMessage instanceof TestPoolItems) {
            this.handleTestPoolItems();
        } else if (actorObjectPoolMessage instanceof Close) {
            this.handleClose((Close)message);
        } else {
            String reason$iv = "no handle for message " + message;
            boolean $i$f$XXX = false;
            throw new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        this.scheduleNewItemsIfNeeded();
    }

    private final void scheduleNewItemsIfNeeded() {
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "scheduleNewItemsIfNeeded - " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
            }
        });
        while (this.availableItems.size() > 0 && !((Collection)this.waitingQueue).isEmpty()) {
            ObjectHolder<CompletableFuture<T>> futureHolder = this.waitingQueue.peek();
            boolean wasBorrowed = this.borrowFirstAvailableItem(futureHolder.getItem());
            if (!wasBorrowed) continue;
            this.waitingQueue.remove();
            ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                final /* synthetic */ ObjectPoolActor<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "scheduleNewItemsIfNeeded - borrowed object ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
                }
            });
            return;
        }
        while (this.availableItems.isEmpty() && !((Collection)this.waitingQueue).isEmpty() && this.getTotalItems() < this.configuration.getMaxObjects() && this.waitingQueue.size() > this.inCreateItems.size()) {
            this.createObject(null);
            ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                final /* synthetic */ ObjectPoolActor<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "scheduleNewItemsIfNeeded - creating new object ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
                }
            });
        }
        while (this.configuration.getMinIdleObjects() != null && this.availableItems.size() + this.inCreateItems.size() < this.configuration.getMinIdleObjects() && this.getTotalItems() < this.configuration.getMaxObjects()) {
            this.createObject(null);
            ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                final /* synthetic */ ObjectPoolActor<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "scheduleNewItemsIfNeeded - creating new object to meet minIdleObjects=" + ObjectPoolActor.access$getConfiguration$p(this.this$0).getMinIdleObjects() + " ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
                }
            });
        }
    }

    private final String getPoolStatusString() {
        return "availableItems=" + this.availableItems.size() + " waitingQueue=" + this.waitingQueue.size() + " inUseItems=" + this.inUseItems.size() + " inCreateItems=" + this.inCreateItems.size() + ' ' + this.getChannel();
    }

    private final void handleClose(Close<T> message) {
        try {
            boolean bl;
            Object it;
            this.closed = true;
            SendChannel.DefaultImpls.close$default(this.getChannel(), null, (int)1, null);
            Object $this$forEach$iv = this.availableItems;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                it = (PoolObjectHolder)t;
                bl = false;
                this.destroy(((PoolObjectHolder)it).getItem());
            }
            this.availableItems.clear();
            $this$forEach$iv = this.inUseItems;
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                it = entry;
                bl = false;
                ((ItemInUseHolder)it.getValue()).setCleanedByPool(true);
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                this.destroy((PooledObject)k);
            }
            this.inUseItems.clear();
            $this$forEach$iv = this.waitingQueue;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                it = (ObjectHolder)object;
                bl = false;
                ((CompletableFuture)((ObjectHolder)it).getItem()).completeExceptionally(new PoolAlreadyTerminatedException());
            }
            this.waitingQueue.clear();
            $this$forEach$iv = this.inCreateItems.values();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                it = (ObjectHolder)object;
                bl = false;
                ((CompletableFuture)((ObjectHolder)it).getItem()).completeExceptionally(new PoolAlreadyTerminatedException());
            }
            this.inCreateItems.clear();
            message.getFuture().complete(Unit.INSTANCE);
        }
        catch (Exception e) {
            message.getFuture().completeExceptionally(e);
        }
    }

    private final void handleTestPoolItems() {
        this.sendAvailableItemsToTest();
        this.checkItemsInCreationForTimeout();
        this.checkItemsInTestOrQueryForTimeout();
        this.checkWaitingFuturesForTimeout();
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)handleTestPoolItems.1.INSTANCE);
    }

    private final void checkWaitingFuturesForTimeout() {
        Long l = this.configuration.getQueryTimeout();
        if (l == null) {
            return;
        }
        long queryTimeout = l;
        while (!this.waitingQueue.isEmpty()) {
            ObjectHolder<CompletableFuture<T>> futureHolder = this.waitingQueue.peek();
            if (futureHolder.getTimeElapsed() > queryTimeout) {
                ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(futureHolder){
                    final /* synthetic */ ObjectHolder<CompletableFuture<T>> $futureHolder;
                    {
                        this.$futureHolder = $futureHolder;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "checkWaitingFuturesForTimeout - timeout waiting future after " + this.$futureHolder.getTimeElapsed() + " ms";
                    }
                });
                this.waitingQueue.remove();
                futureHolder.getItem().completeExceptionally(new TimeoutException("timeout while waiting in queue after " + futureHolder.getTimeElapsed() + " ms"));
                continue;
            }
            return;
        }
    }

    private final void checkItemsInTestOrQueryForTimeout() {
        Set<Map.Entry<T, ItemInUseHolder<T>>> set = this.inUseItems.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"inUseItems.entries");
        CollectionsKt.removeAll((Iterable)set, (Function1)new Function1<Map.Entry<T, ItemInUseHolder<T>>, Boolean>(this){
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<T, ItemInUseHolder<T>> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                ItemInUseHolder<T> holder = entry.getValue();
                PooledObject item = (PooledObject)entry.getKey();
                boolean itemWasTimeout = false;
                if (holder.isInTest() && holder.getTimeElapsed() > ObjectPoolActor.access$getConfiguration$p(this.this$0).getTestTimeout()) {
                    ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(item, holder){
                        final /* synthetic */ T $item;
                        final /* synthetic */ ItemInUseHolder<T> $holder;
                        {
                            this.$item = $item;
                            this.$holder = $holder;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "failed to test item " + this.$item.getId() + " after " + this.$holder.getTimeElapsed() + " ms, will destroy it";
                        }
                    });
                    holder.setCleanedByPool(true);
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    ObjectPoolActor.access$destroy(this.this$0, item);
                    CompletableFuture<T> completableFuture = holder.getTestFuture();
                    Intrinsics.checkNotNull(completableFuture);
                    completableFuture.completeExceptionally(new TimeoutException("failed to test item " + item.getId() + " after " + holder.getTimeElapsed() + " ms"));
                    itemWasTimeout = true;
                }
                if (!holder.isInTest() && ObjectPoolActor.access$getConfiguration$p(this.this$0).getQueryTimeout() != null && holder.getTimeElapsed() > ObjectPoolActor.access$getConfiguration$p(this.this$0).getQueryTimeout() + ObjectPoolActor.access$getExtraTimeForTimeoutCompletion$p(this.this$0)) {
                    ActorBasedObjectPoolKt.access$getLogger$p().error((Function0)new Function0<Object>(item, holder, this.this$0){
                        final /* synthetic */ T $item;
                        final /* synthetic */ ItemInUseHolder<T> $holder;
                        final /* synthetic */ ObjectPoolActor<T> this$0;
                        {
                            this.$item = $item;
                            this.$holder = $holder;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "timeout query item " + this.$item.getId() + " after " + this.$holder.getTimeElapsed() + " ms and was not cleaned by connection as it should, will destroy it - timeout is " + ObjectPoolActor.access$getConfiguration$p(this.this$0).getQueryTimeout();
                        }
                    });
                    holder.setCleanedByPool(true);
                    Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                    ObjectPoolActor.access$destroy(this.this$0, item);
                    itemWasTimeout = true;
                }
                return itemWasTimeout;
            }
        });
    }

    private final void checkItemsInCreationForTimeout() {
        CollectionsKt.removeAll((Iterable)this.inCreateItems.entrySet(), (Function1)new Function1<Map.Entry<Integer, ObjectHolder<CompletableFuture<? extends T>>>, Boolean>(this){
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<Integer, ObjectHolder<CompletableFuture<? extends T>>> it) {
                boolean timeout;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean bl = timeout = it.getValue().getTimeElapsed() > ObjectPoolActor.access$getConfiguration$p(this.this$0).getCreateTimeout();
                if (timeout) {
                    ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(it){
                        final /* synthetic */ Map.Entry<Integer, ObjectHolder<CompletableFuture<? extends T>>> $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "failed to create item " + ((Number)this.$it.getKey()).intValue() + " after " + this.$it.getValue().getTimeElapsed() + " ms";
                        }
                    });
                    it.getValue().getItem().completeExceptionally(new TimeoutException("failed to create item " + ((Number)it.getKey()).intValue() + " after " + it.getValue().getTimeElapsed() + " ms"));
                }
                return timeout;
            }
        });
    }

    private final void destroy(T $this$destroy) {
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>($this$destroy){
            final /* synthetic */ T $this_destroy;
            {
                this.$this_destroy = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "destroy item " + this.$this_destroy.getId();
            }
        });
        this.objectFactory.destroy($this$destroy);
    }

    private final void sendAvailableItemsToTest() {
        Iterable $this$forEach$iv = this.availableItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PoolObjectHolder it = (PoolObjectHolder)element$iv;
            boolean bl = false;
            Object item = it.getItem();
            ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(item, it){
                final /* synthetic */ T $item;
                final /* synthetic */ PoolObjectHolder<T> $it;
                {
                    this.$item = $item;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "test: " + this.$item.getId() + " available " + this.$it.getTimeElapsed() + " ms";
                }
            });
            if (it.getTimeElapsed() > this.configuration.getMaxIdle()) {
                ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(item){
                    final /* synthetic */ T $item;
                    {
                        this.$item = $item;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "releasing idle item " + this.$item.getId();
                    }
                });
                this.destroy(item);
                continue;
            }
            if (this.configuration.getMaxObjectTtl() != null && System.currentTimeMillis() - item.getCreationTime() > this.configuration.getMaxObjectTtl()) {
                ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(item){
                    final /* synthetic */ T $item;
                    {
                        this.$item = $item;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "releasing item past ttl " + this.$item.getId();
                    }
                });
                this.destroy(item);
                continue;
            }
            CompletableFuture<T> test = this.objectFactory.test(item);
            ((Map)this.inUseItems).put(item, new ItemInUseHolder(item.getId(), true, test, 0L, false, 24, null));
            CompletableFuture<T> $this$mapTry$iv = test;
            boolean $i$f$mapTry = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTry$iv.handle(new BiFunction(this, (PooledObject)item, it){
                final /* synthetic */ ObjectPoolActor this$0;
                final /* synthetic */ PooledObject $item$inlined;
                final /* synthetic */ PoolObjectHolder $it$inlined;
                {
                    this.this$0 = objectPoolActor;
                    this.$item$inlined = pooledObject;
                    this.$it$inlined = poolObjectHolder;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Unit apply(T a, @Nullable Throwable t) {
                    void t2;
                    Throwable throwable = t;
                    PooledObject cfr_ignored_0 = (PooledObject)a;
                    boolean bl = false;
                    ObjectPoolActor.access$offerOrLog(this.this$0, new GiveBack<PooledObject>(this.$item$inlined, new CompletableFuture<Unit>(), (Throwable)t2, this.$it$inlined.getTime()), sendAvailableItemsToTest.1.4.1.INSTANCE);
                    return Unit.INSTANCE;
                }
            }), (String)"crossinline f: (A, Throw\u2026: Throwable? -> f(a, t) }");
        }
        this.availableItems.clear();
    }

    private final void offerOrLog(ActorObjectPoolMessage<T> message, Function0<String> logMessage) {
        boolean offered = ChannelResult.isSuccess-impl((Object)this.getChannel().trySend-JP2dKIU(message));
        if (!offered) {
            ActorBasedObjectPoolKt.access$getLogger$p().warn((Function0)new Function0<Object>(logMessage){
                final /* synthetic */ Function0<String> $logMessage;
                {
                    this.$logMessage = $logMessage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "failed to offer on " + (String)this.$logMessage.invoke();
                }
            });
        }
    }

    private final void handleCreated(Created<T> message) {
        CompletableFuture<T> future;
        ObjectHolder<CompletableFuture<? extends T>> removed = this.inCreateItems.remove(message.getItemCreateId());
        if (removed == null) {
            ActorBasedObjectPoolKt.access$getLogger$p().warn((Function0)new Function0<Object>(message){
                final /* synthetic */ Created<T> $message;
                {
                    this.$message = $message;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "could not find connection " + this.$message.getItemCreateId();
                }
            });
        }
        if ((future = message.getTakeAskFuture()) == null) {
            Try<T> try_ = message.getItem();
            if (try_ instanceof Failure) {
                ActorBasedObjectPoolKt.access$getLogger$p().debug((Function0)handleCreated.2.INSTANCE);
            } else if (try_ instanceof Success) {
                this.availableItems.add(new PoolObjectHolder((PooledObject)((Success)message.getItem()).getValue(), 0L, 2, null));
            }
        } else {
            Try<T> try_ = message.getItem();
            if (try_ instanceof Failure) {
                future.completeExceptionally(((Failure)message.getItem()).getException());
            } else if (try_ instanceof Success) {
                try {
                    ObjectPoolActor.borrowTo$default(this, (PooledObject)((Success)message.getItem()).getValue(), future, false, 2, null);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        }
    }

    private final void borrowTo(T $this$borrowTo, CompletableFuture<T> future, boolean validate) {
        if (validate) {
            this.validate($this$borrowTo);
        }
        ((Map)this.inUseItems).put($this$borrowTo, new ItemInUseHolder($this$borrowTo.getId(), false, null, 0L, false, 28, null));
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>($this$borrowTo, this){
            final /* synthetic */ T $this_borrowTo;
            final /* synthetic */ ObjectPoolActor<T> this$0;
            {
                this.$this_borrowTo = $receiver;
                this.this$0 = $receiver2;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "borrowed: " + this.$this_borrowTo.getId() + " ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
            }
        });
        future.complete($this$borrowTo);
    }

    static /* synthetic */ void borrowTo$default(ObjectPoolActor objectPoolActor, PooledObject pooledObject, CompletableFuture completableFuture, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        objectPoolActor.borrowTo(pooledObject, completableFuture, bl);
    }

    private final void handleGiveBack(GiveBack<T> message) {
        block19: {
            try {
                ItemInUseHolder<T> removed;
                ItemInUseHolder<T> itemInUseHolder = removed = this.inUseItems.remove(message.getReturnedItem());
                if (itemInUseHolder != null) {
                    ItemInUseHolder<T> itemInUseHolder2;
                    ItemInUseHolder<T> $this$handleGiveBack_u24lambda_u2d8 = itemInUseHolder2 = itemInUseHolder;
                    boolean bl = false;
                    $this$handleGiveBack_u24lambda_u2d8.setCleanedByPool(true);
                }
                if (removed == null) {
                    boolean bl;
                    block17: {
                        Iterable $this$any$iv = this.availableItems;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PoolObjectHolder holder = (PoolObjectHolder)element$iv;
                                boolean bl2 = false;
                                if (!(message.getReturnedItem() == holder.getItem())) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    boolean isFromOurPool = bl;
                    ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(message, isFromOurPool, this){
                        final /* synthetic */ GiveBack<T> $message;
                        final /* synthetic */ boolean $isFromOurPool;
                        final /* synthetic */ ObjectPoolActor<T> this$0;
                        {
                            this.$message = $message;
                            this.$isFromOurPool = $isFromOurPool;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "give back got item not in use: " + this.$message.getReturnedItem().getId() + " isFromOurPool=" + this.$isFromOurPool + " ; " + ObjectPoolActor.access$getPoolStatusString(this.this$0);
                        }
                    });
                    if (isFromOurPool) {
                        FutureUtilsKt.failed(message.getFuture(), new IllegalStateException("This item has already been returned"));
                    } else {
                        FutureUtilsKt.failed(message.getFuture(), new IllegalArgumentException("The returned item did not come from this pool."));
                    }
                    return;
                }
                if (message.getException() != null) {
                    ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(message){
                        final /* synthetic */ GiveBack<T> $message;
                        {
                            this.$message = $message;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "GiveBack got exception, so destroying item " + this.$message.getReturnedItem().getId() + ", exception is " + this.$message.getException().getClass().getSimpleName() + " - " + this.$message.getException().getMessage();
                        }
                    });
                    throw message.getException();
                }
                this.validate(message.getReturnedItem());
                message.getFuture().complete(Unit.INSTANCE);
                if (this.waitingQueue.isEmpty()) {
                    boolean bl;
                    block18: {
                        Iterable $this$any$iv = this.availableItems;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PoolObjectHolder holder = (PoolObjectHolder)element$iv;
                                boolean bl3 = false;
                                if (!(message.getReturnedItem() == holder.getItem())) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        ActorBasedObjectPoolKt.access$getLogger$p().warn((Function0)new Function0<Object>(message){
                            final /* synthetic */ GiveBack<T> $message;
                            {
                                this.$message = $message;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "trying to give back an item to the pool twice " + this.$message.getReturnedItem().getId() + ", will ignore that";
                            }
                        });
                        return;
                    }
                    this.availableItems.add(message.getOriginalTime() == null ? new PoolObjectHolder((PooledObject)message.getReturnedItem(), 0L, 2, null) : new PoolObjectHolder<T>(message.getReturnedItem(), message.getOriginalTime()));
                    ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(message, this){
                        final /* synthetic */ GiveBack<T> $message;
                        final /* synthetic */ ObjectPoolActor<T> this$0;
                        {
                            this.$message = $message;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "add " + this.$message.getReturnedItem().getId() + " to available items, size is " + ObjectPoolActor.access$getAvailableItems$p(this.this$0).size();
                        }
                    });
                    break block19;
                }
                ObjectHolder<CompletableFuture<T>> waitingFuture = this.waitingQueue.remove();
                this.borrowTo(message.getReturnedItem(), waitingFuture.getItem(), false);
            }
            catch (Throwable e) {
                ActorBasedObjectPoolKt.access$getLogger$p().trace(e, (Function0)new Function0<Object>(message){
                    final /* synthetic */ GiveBack<T> $message;
                    {
                        this.$message = $message;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "GiveBack caught exception, so destroying item " + this.$message.getReturnedItem().getId() + ' ';
                    }
                });
                try {
                    this.destroy(message.getReturnedItem());
                }
                catch (Throwable e1) {
                    ActorBasedObjectPoolKt.access$getLogger$p().trace(e1, (Function0)new Function0<Object>(message){
                        final /* synthetic */ GiveBack<T> $message;
                        {
                            this.$message = $message;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "GiveBack caught exception, destroy also caught exception " + this.$message.getReturnedItem().getId() + ' ';
                        }
                    });
                }
                message.getFuture().completeExceptionally(e);
            }
        }
    }

    private final void handleTake(Take<T> message) {
        while (!((Collection)this.availableItems).isEmpty()) {
            CompletableFuture<T> future = message.getFuture();
            boolean wasBorrowed = this.borrowFirstAvailableItem(future);
            if (!wasBorrowed) continue;
            return;
        }
        this.createNewItemPutInWaitQueue(message);
    }

    private final boolean borrowFirstAvailableItem(CompletableFuture<T> future) {
        PoolObjectHolder<T> itemHolder = this.availableItems.remove();
        try {
            this.validateTtl(itemHolder.getItem());
            ObjectPoolActor.borrowTo$default(this, itemHolder.getItem(), future, false, 2, null);
            return true;
        }
        catch (Exception e) {
            ActorBasedObjectPoolKt.access$getLogger$p().debug((Function0)new Function0<Object>(itemHolder, e){
                final /* synthetic */ PoolObjectHolder<T> $itemHolder;
                final /* synthetic */ Exception $e;
                {
                    this.$itemHolder = $itemHolder;
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "validation of object '" + this.$itemHolder.getItem().getId() + "' failed, removing it from pool: " + this.$e.getMessage();
                }
            });
            this.destroy(itemHolder.getItem());
            return false;
        }
    }

    private final void validateTtl(T item) {
        long age = System.currentTimeMillis() - item.getCreationTime();
        if (this.configuration.getMaxObjectTtl() != null && age > this.configuration.getMaxObjectTtl()) {
            throw new MaxTtlPassedException(item.getId(), age, this.configuration.getMaxObjectTtl());
        }
    }

    private final int getTotalItems() {
        return this.inUseItems.size() + this.inCreateItems.size() + this.availableItems.size();
    }

    private final void createNewItemPutInWaitQueue(Take<T> message) {
        try {
            if (this.getTotalItems() < this.configuration.getMaxObjects()) {
                this.createObject(message.getFuture());
            } else if (this.waitingQueue.size() < this.configuration.getMaxQueueSize()) {
                this.waitingQueue.add(new ObjectHolder<CompletableFuture<T>>(message.getFuture()));
                ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                    final /* synthetic */ ObjectPoolActor<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "no items available (" + ObjectPoolActor.access$getInUseItems$p(this.this$0).size() + " used), added to waiting queue (" + ObjectPoolActor.access$getWaitingQueue$p(this.this$0).size() + " waiting)";
                    }
                });
            } else {
                ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                    final /* synthetic */ ObjectPoolActor<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "no items available (" + ObjectPoolActor.access$getInUseItems$p(this.this$0).size() + " used), and the waitQueue is full (" + ObjectPoolActor.access$getWaitingQueue$p(this.this$0).size() + " waiting)";
                    }
                });
                message.getFuture().completeExceptionally(new PoolExhaustedException("There are no objects available and the waitQueue is full"));
            }
        }
        catch (Exception e) {
            message.getFuture().completeExceptionally(e);
        }
    }

    private final void createObject(CompletableFuture<T> future) {
        CompletableFuture<T> created = this.objectFactory.create();
        int itemCreateId = this.createIndex;
        int n = this.createIndex;
        this.createIndex = n + 1;
        Integer n2 = itemCreateId;
        this.inCreateItems.put(n2, new ObjectHolder<CompletableFuture<T>>(created));
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)new Function0<Object>(itemCreateId){
            final /* synthetic */ int $itemCreateId;
            {
                this.$itemCreateId = $itemCreateId;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "createObject createRequest=" + this.$itemCreateId;
            }
        });
        CompletableFuture<T> $this$onComplete$iv = created;
        boolean $i$f$onComplete = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onComplete$iv.whenComplete(new BiConsumer(this, itemCreateId, future){
            final /* synthetic */ ObjectPoolActor this$0;
            final /* synthetic */ int $itemCreateId$inlined;
            final /* synthetic */ CompletableFuture $future$inlined;
            {
                this.this$0 = objectPoolActor;
                this.$itemCreateId$inlined = n;
                this.$future$inlined = completableFuture;
            }

            public final void accept(T a, Throwable t) {
                Throwable throwable = t;
                Try<Object> tried = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                boolean bl = false;
                ObjectPoolActor.access$offerOrLog(this.this$0, new Created<A>(this.$itemCreateId$inlined, tried, this.$future$inlined), (Function0)new Function0<String>(this.$itemCreateId$inlined){
                    final /* synthetic */ int $itemCreateId;
                    {
                        this.$itemCreateId = $itemCreateId;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "failed to offer on created item " + this.$itemCreateId;
                    }
                });
            }
        }), (String)"crossinline onCompleteFu\u2026) else Try.just(a))\n    }");
    }

    private final void validate(T item) {
        Try<T> tried = this.objectFactory.validate(item);
        if (tried instanceof Failure) {
            throw ((Failure)tried).getException();
        }
    }

    public static final /* synthetic */ String access$getPoolStatusString(ObjectPoolActor $this) {
        return $this.getPoolStatusString();
    }

    public static final /* synthetic */ PoolConfiguration access$getConfiguration$p(ObjectPoolActor $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ void access$destroy(ObjectPoolActor $this, PooledObject $receiver) {
        $this.destroy($receiver);
    }

    public static final /* synthetic */ long access$getExtraTimeForTimeoutCompletion$p(ObjectPoolActor $this) {
        return $this.extraTimeForTimeoutCompletion;
    }

    public static final /* synthetic */ Queue access$getAvailableItems$p(ObjectPoolActor $this) {
        return $this.availableItems;
    }

    public static final /* synthetic */ WeakHashMap access$getInUseItems$p(ObjectPoolActor $this) {
        return $this.inUseItems;
    }

    public static final /* synthetic */ Queue access$getWaitingQueue$p(ObjectPoolActor $this) {
        return $this.waitingQueue;
    }

    public static final /* synthetic */ void access$offerOrLog(ObjectPoolActor $this, ActorObjectPoolMessage message, Function0 logMessage) {
        $this.offerOrLog(message, (Function0<String>)logMessage);
    }

    public static final /* synthetic */ Function0 access$getChannelProvider$p(ObjectPoolActor $this) {
        return $this.channelProvider;
    }
}

