/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres;

import java.sql.Connection;
import java.sql.SQLException;
import org.hcjf.errors.Errors;
import org.hcjf.layers.storage.StorageLayer;
import org.hcjf.layers.storage.postgres.PostgresStorageSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.postgresql.ds.PGPoolingDataSource;

public abstract class PostgresStorageLayer<S extends PostgresStorageSession>
extends StorageLayer<S> {
    private PGPoolingDataSource source;

    public PostgresStorageLayer(String implName) {
        super(implName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S begin() {
        PostgresStorageLayer postgresStorageLayer = this;
        synchronized (postgresStorageLayer) {
            if (this.source == null) {
                this.source = new PGPoolingDataSource();
                this.source.setDataSourceName(this.getDataSourceName());
                this.source.setServerName(this.getServerName());
                this.source.setDatabaseName(this.getDatabaseName());
                this.source.setUser(this.getUserName());
                this.source.setPassword(this.getPassword());
                this.source.setInitialConnections(this.getInitialConnections().intValue());
                this.source.setMaxConnections(this.getMaxConnections().intValue());
                this.source.setPortNumber(this.getPortNumber().intValue());
                try {
                    Connection connection = this.source.getConnection();
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            Connection connection = this.source.getConnection();
            connection.setAutoCommit(false);
            return this.getSessionInstance(this.getImplName(), connection);
        }
        catch (SQLException ex) {
            Log.e((String)SystemProperties.get((String)"postgres.storage.layer.log.tag"), (String)Errors.getMessage((String)"postgres.errors.unable.to.create.connection", (Object[])new Object[0]), (Throwable)ex, (Object[])new Object[0]);
            throw new RuntimeException(Errors.getMessage((String)"postgres.errors.unable.to.create.connection", (Object[])new Object[0]), ex);
        }
    }

    protected abstract S getSessionInstance(String var1, Connection var2);

    protected abstract String getDataSourceName();

    protected abstract String getServerName();

    protected abstract String getDatabaseName();

    protected abstract String getUserName();

    protected abstract String getPassword();

    protected abstract Integer getInitialConnections();

    protected abstract Integer getMaxConnections();

    protected abstract Integer getPortNumber();
}

