/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres.actions;

import java.sql.PreparedStatement;
import org.hcjf.layers.query.EvaluatorCollection;
import org.hcjf.layers.query.Join;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.storage.StorageAccessException;
import org.hcjf.layers.storage.StorageSession;
import org.hcjf.layers.storage.actions.ResultSet;
import org.hcjf.layers.storage.actions.Select;
import org.hcjf.layers.storage.postgres.PostgresStorageSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;

public class PostgresSelect
extends Select<PostgresStorageSession> {
    public PostgresSelect(PostgresStorageSession session) {
        super((StorageSession)session);
    }

    public <R extends ResultSet> R execute(Object ... params) throws StorageAccessException {
        try {
            Query query = this.getQuery();
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(SystemProperties.get((String)"hcjf.query.select.reserved.word")).append(" ");
            String argumentSeparatorValue = SystemProperties.get((String)"hcjf.query.argument.separator");
            String argumentSeparator = "";
            if (!query.returnAll()) {
                for (Query.QueryReturnParameter queryField : query.getReturnParameters()) {
                    queryBuilder.append(argumentSeparator);
                    Query.QueryComponent normalizedQueryField = ((PostgresStorageSession)this.getSession()).normalizeApplicationToDataSource((Query.QueryComponent)queryField);
                    queryBuilder.append(normalizedQueryField);
                    if (normalizedQueryField instanceof Query.QueryReturnParameter && ((Query.QueryReturnParameter)normalizedQueryField).getAlias() != null && !((Query.QueryReturnParameter)normalizedQueryField).getAlias().isEmpty()) {
                        queryBuilder.append(" ");
                        queryBuilder.append(SystemProperties.get((String)"hcjf.query.as.reserved.word"));
                        queryBuilder.append(" ");
                        queryBuilder.append(((Query.QueryReturnParameter)normalizedQueryField).getAlias());
                    }
                    queryBuilder.append(" ");
                    argumentSeparator = argumentSeparatorValue;
                }
            } else {
                queryBuilder.append(SystemProperties.get((String)"hcjf.query.return.all.reserved.word"));
                queryBuilder.append(" ");
            }
            queryBuilder.append(SystemProperties.get((String)"hcjf.query.from.reserved.word")).append(" ");
            queryBuilder.append(((PostgresStorageSession)this.getSession()).normalizeApplicationToDataSource((Query.QueryComponent)query.getResource())).append(" ");
            if (query.getJoins() != null && query.getJoins().size() > 0) {
                for (Join join : query.getJoins()) {
                    queryBuilder.append(" ");
                    switch (join.getType()) {
                        case JOIN: {
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.join.reserved.word"));
                            break;
                        }
                        case LEFT: {
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.left.join.reserved.word"));
                            queryBuilder.append(" ");
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.join.reserved.word"));
                            break;
                        }
                        case RIGHT: {
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.right.join.reserved.word"));
                            queryBuilder.append(" ");
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.join.reserved.word"));
                            break;
                        }
                        case INNER: {
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.inner.join.reserved.word"));
                            queryBuilder.append(" ");
                            queryBuilder.append(SystemProperties.get((String)"hcjf.query.join.reserved.word"));
                        }
                    }
                    queryBuilder.append(" ");
                    queryBuilder.append(join.getResourceName());
                    queryBuilder.append(" ");
                    queryBuilder.append(SystemProperties.get((String)"hcjf.query.on.reserved.word"));
                    queryBuilder.append(" ");
                    queryBuilder.append(join.getLeftField().getCompleteFieldName());
                    queryBuilder.append(SystemProperties.get((String)"hcjf.query.equals.reserved.word"));
                    queryBuilder.append(join.getRightField().getCompleteFieldName());
                }
            }
            if (query.getEvaluators().size() > 0) {
                queryBuilder.append(SystemProperties.get((String)"hcjf.query.where.reserved.word"));
                queryBuilder.append(" ");
                queryBuilder = ((PostgresStorageSession)this.getSession()).processEvaluators(queryBuilder, (EvaluatorCollection)query);
                queryBuilder.append(" ");
            }
            if (query.getOrderParameters().size() > 0) {
                queryBuilder.append(SystemProperties.get((String)"hcjf.query.order.by.reserved.word"));
                queryBuilder.append(" ");
                argumentSeparator = "";
                for (Query.QueryOrderParameter orderParameter : query.getOrderParameters()) {
                    queryBuilder.append(((PostgresStorageSession)this.getSession()).normalizeApplicationToDataSource((Query.QueryComponent)orderParameter)).append(argumentSeparator).append(" ");
                    if (orderParameter.isDesc()) {
                        queryBuilder.append(SystemProperties.get((String)"hcjf.query.desc.reserved.word")).append(" ");
                    }
                    argumentSeparator = argumentSeparatorValue;
                }
            }
            if (query.getLimit() != null) {
                queryBuilder.append(SystemProperties.get((String)"hcjf.query.limit.reserved.word")).append(" ").append(query.getLimit());
            }
            PreparedStatement preparedStatement = ((PostgresStorageSession)this.getSession()).getConnection().prepareStatement(queryBuilder.toString());
            preparedStatement = ((PostgresStorageSession)this.getSession()).setValues(preparedStatement, (EvaluatorCollection)query, 1, params);
            Log.d((String)SystemProperties.get((String)"postgres.execute.statement.log.tag"), (String)preparedStatement.toString(), (Object[])new Object[0]);
            return ((PostgresStorageSession)this.getSession()).createResultSet(this.getQuery(), preparedStatement.executeQuery(), this.getResultType());
        }
        catch (Exception ex) {
            ((PostgresStorageSession)this.getSession()).onError(ex);
            throw new StorageAccessException((Throwable)ex);
        }
    }
}

