/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres.actions;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.hcjf.layers.query.EvaluatorCollection;
import org.hcjf.layers.storage.StorageAccessException;
import org.hcjf.layers.storage.StorageSession;
import org.hcjf.layers.storage.actions.ResultSet;
import org.hcjf.layers.storage.actions.Update;
import org.hcjf.layers.storage.postgres.PostgresStorageSession;
import org.hcjf.layers.storage.values.StorageValue;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class PostgresUpdate
extends Update<PostgresStorageSession> {
    private static final String UPDATE_STATEMENT = "UPDATE %s SET %s WHERE %s";

    public PostgresUpdate(PostgresStorageSession session) {
        super((StorageSession)session);
    }

    public <R extends ResultSet> R execute(Object ... params) throws StorageAccessException {
        try {
            String resourceName = this.getResourceName();
            if (this.getQuery() == null) {
                throw new StorageAccessException("Update query conditions not found");
            }
            if (this.getResourceName() == null) {
                resourceName = this.getQuery().getResourceName();
            }
            ArrayList<Object> baseValues = new ArrayList<Object>();
            Strings.Builder setBuilder = new Strings.Builder();
            for (String fieldName : this.getValues().keySet()) {
                setBuilder.append(fieldName).append("=").append(" ");
                setBuilder.append(SystemProperties.get((String)"hcjf.query.replaceable.value.reserved.word"), new String[]{",", " "});
                baseValues.add(((StorageValue)this.getValues().get(fieldName)).getValue());
            }
            StringBuilder whereBuilder = new StringBuilder();
            if (this.getQuery().getEvaluators().size() == 0) {
                throw new StorageAccessException("Update query conditions not found");
            }
            whereBuilder = ((PostgresStorageSession)this.getSession()).processEvaluators(whereBuilder, (EvaluatorCollection)this.getQuery());
            String statement = String.format(UPDATE_STATEMENT, resourceName, setBuilder.toString(), whereBuilder.toString());
            PreparedStatement preparedStatement = ((PostgresStorageSession)this.getSession()).getConnection().prepareStatement(statement);
            int index = 1;
            for (Object e : baseValues) {
                if (e instanceof Date) {
                    preparedStatement.setTimestamp(index++, new Timestamp(((Date)e).getTime()));
                    continue;
                }
                if (Collection.class.isAssignableFrom(e.getClass())) {
                    for (Object object : (Collection)e) {
                        preparedStatement.setObject(index++, object);
                    }
                    continue;
                }
                preparedStatement.setObject(index++, e);
            }
            preparedStatement = ((PostgresStorageSession)this.getSession()).setValues(preparedStatement, (EvaluatorCollection)this.getQuery(), index, params);
            Log.d((String)SystemProperties.get((String)"postgres.execute.statement.log.tag"), (String)preparedStatement.toString(), (Object[])new Object[0]);
            preparedStatement.executeUpdate();
            return null;
        }
        catch (Exception ex) {
            ((PostgresStorageSession)this.getSession()).onError(ex);
            throw new StorageAccessException((Throwable)ex);
        }
    }
}

