/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hcjf.errors.Errors;
import org.hcjf.layers.storage.StorageLayer;
import org.hcjf.layers.storage.postgres.PostgresStorageSession;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.postgresql.ds.PGSimpleDataSource;

public abstract class PostgresStorageLayer<S extends PostgresStorageSession>
extends StorageLayer<S> {
    private DataSource source;

    public PostgresStorageLayer(String implName) {
        super(implName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S begin() {
        PostgresStorageLayer postgresStorageLayer = this;
        synchronized (postgresStorageLayer) {
            if (this.source == null) {
                HikariConfig hikariConfig = new HikariConfig();
                hikariConfig.setDataSourceClassName(PGSimpleDataSource.class.getName());
                hikariConfig.addDataSourceProperty(SystemProperties.get((String)"postgres.storage.layer.pool.server.name.field"), (Object)this.getServerName());
                hikariConfig.addDataSourceProperty(SystemProperties.get((String)"postgres.storage.layer.pool.database.name.field"), (Object)this.getDatabaseName());
                hikariConfig.addDataSourceProperty(SystemProperties.get((String)"postgres.storage.layer.pool.user.field"), (Object)this.getUserName());
                hikariConfig.addDataSourceProperty(SystemProperties.get((String)"postgres.storage.layer.pool.password.field"), (Object)this.getPassword());
                hikariConfig.addDataSourceProperty(SystemProperties.get((String)"postgres.storage.layer.pool.port.number.field"), (Object)this.getPortNumber());
                hikariConfig.setPoolName(this.getDataSourceName());
                hikariConfig.setMaximumPoolSize(this.getMaxConnections().intValue());
                hikariConfig.setMinimumIdle(this.getInitialConnections().intValue());
                hikariConfig.setIdleTimeout(this.getIdleTimeout().longValue());
                hikariConfig.setMaxLifetime(this.getMaxLifeTime().longValue());
                this.source = new HikariDataSource(hikariConfig);
                try {
                    Connection connection = this.source.getConnection();
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            Connection connection = this.source.getConnection();
            connection.setAutoCommit(false);
            return this.getSessionInstance(this.getImplName(), connection);
        }
        catch (SQLException ex) {
            Log.e((String)SystemProperties.get((String)"postgres.storage.layer.log.tag"), (String)Errors.getMessage((String)"postgres.errors.unable.to.create.connection", (Object[])new Object[0]), (Throwable)ex, (Object[])new Object[0]);
            throw new RuntimeException(Errors.getMessage((String)"postgres.errors.unable.to.create.connection", (Object[])new Object[0]), ex);
        }
    }

    protected abstract S getSessionInstance(String var1, Connection var2);

    protected abstract String getDataSourceName();

    protected abstract String getServerName();

    protected abstract String getDatabaseName();

    protected abstract String getUserName();

    protected abstract String getPassword();

    protected Integer getInitialConnections() {
        return SystemProperties.getInteger((String)"postgres.storage.layer.pool.init.connections");
    }

    protected Integer getMaxConnections() {
        return SystemProperties.getInteger((String)"postgres.storage.layer.pool.max.connections");
    }

    protected abstract Integer getPortNumber();

    protected Long getIdleTimeout() {
        return SystemProperties.getLong((String)"postgres.storage.layer.pool.idle.timeout");
    }

    protected Long getMaxLifeTime() {
        return SystemProperties.getLong((String)"postgres.storage.layer.pool.max.life.time");
    }
}

