/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.hcjf.errors.Errors;
import org.hcjf.layers.query.And;
import org.hcjf.layers.query.Distinct;
import org.hcjf.layers.query.Equals;
import org.hcjf.layers.query.Evaluator;
import org.hcjf.layers.query.EvaluatorCollection;
import org.hcjf.layers.query.FieldEvaluator;
import org.hcjf.layers.query.GreaterThan;
import org.hcjf.layers.query.GreaterThanOrEqual;
import org.hcjf.layers.query.In;
import org.hcjf.layers.query.JoinableMap;
import org.hcjf.layers.query.Like;
import org.hcjf.layers.query.NotIn;
import org.hcjf.layers.query.Or;
import org.hcjf.layers.query.Query;
import org.hcjf.layers.query.SmallerThan;
import org.hcjf.layers.query.SmallerThanOrEqual;
import org.hcjf.layers.storage.StorageAccessException;
import org.hcjf.layers.storage.StorageSession;
import org.hcjf.layers.storage.actions.CollectionResultSet;
import org.hcjf.layers.storage.actions.Insert;
import org.hcjf.layers.storage.actions.MapResultSet;
import org.hcjf.layers.storage.actions.ResultSet;
import org.hcjf.layers.storage.actions.Select;
import org.hcjf.layers.storage.actions.Update;
import org.hcjf.layers.storage.postgres.actions.PostgresInsert;
import org.hcjf.layers.storage.postgres.actions.PostgresSelect;
import org.hcjf.layers.storage.postgres.actions.PostgresUpdate;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Introspection;

public class PostgresStorageSession
extends StorageSession {
    private final Connection connection;
    private Throwable throwable;

    public PostgresStorageSession(String implName, Connection connection) {
        super(implName);
        this.connection = connection;
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final void onError(Throwable throwable) {
        this.throwable = throwable;
    }

    public void close() throws IOException {
        try {
            if (this.throwable != null) {
                try {
                    this.getConnection().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.w((String)SystemProperties.get((String)"postgres.storage.layer.log.tag"), (String)Errors.getMessage((String)"postgres.errors.rollback.operation", (Object[])new Object[0]), (Throwable)this.throwable, (Object[])new Object[0]);
            } else {
                try {
                    this.getConnection().commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.getConnection().close();
        }
        catch (SQLException ex) {
            Log.w((String)SystemProperties.get((String)"postgres.storage.layer.log.tag"), (String)Errors.getMessage((String)"postgres.errors.unable.to.close.connection", (Object[])new Object[0]), (Throwable)ex, (Object[])new Object[0]);
            throw new IOException(Errors.getMessage((String)"postgres.errors.unable.to.close.connection", (Object[])new Object[0]), ex);
        }
    }

    public <R extends ResultSet> R createResultSet(Query query, java.sql.ResultSet sqlResultSet, Class resultType) throws SQLException, IllegalAccessException, InstantiationException {
        ResultSetMetaData resultSetMetaData = sqlResultSet.getMetaData();
        MapResultSet resultSet = null;
        if (resultType == null) {
            ArrayList<JoinableMap> collectionResult = new ArrayList<JoinableMap>();
            while (sqlResultSet.next()) {
                JoinableMap mapResult = new JoinableMap(query.getResourceName());
                for (int columnNumber = 1; columnNumber <= resultSetMetaData.getColumnCount(); ++columnNumber) {
                    Query.QueryComponent queryField = this.normalizeDataSourceToApplication((Query.QueryComponent)new Query.QueryField(resultSetMetaData.getTableName(columnNumber) + "." + resultSetMetaData.getColumnLabel(columnNumber)));
                    if (queryField == null) continue;
                    mapResult.put(query.getResourceName() + "." + ((Query.QueryField)queryField).getFieldName(), this.getValueFromColumn(sqlResultSet.getObject(columnNumber)));
                }
                collectionResult.add(mapResult);
            }
            resultSet = new MapResultSet(collectionResult);
        } else {
            ArrayList collectionResult = new ArrayList();
            Map setters = Introspection.getSetters((Class)resultType);
            while (sqlResultSet.next()) {
                Object object = resultType.newInstance();
                for (int columnNumber = 1; columnNumber <= resultSetMetaData.getColumnCount(); ++columnNumber) {
                    try {
                        Query.QueryComponent queryField = this.normalizeDataSourceToApplication((Query.QueryComponent)new Query.QueryField(resultSetMetaData.getTableName(columnNumber) + "." + resultSetMetaData.getColumnLabel(columnNumber)));
                        if (queryField == null || !setters.containsKey(((Query.QueryField)queryField).getFieldName())) continue;
                        ((Introspection.Setter)setters.get(((Query.QueryField)queryField).getFieldName())).invoke(object, new Object[]{this.getValueFromColumn(sqlResultSet.getObject(columnNumber))});
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                collectionResult.add(object);
            }
            resultSet = new CollectionResultSet(collectionResult);
        }
        return (R)resultSet;
    }

    protected Object getValueFromColumn(Object columnValue) throws SQLException {
        Object result = columnValue;
        if (columnValue != null) {
            if (columnValue instanceof Array) {
                result = Arrays.asList((Object[])((Array)((Object)columnValue)).getArray());
            } else if (columnValue instanceof BigDecimal) {
                result = ((BigDecimal)((Object)columnValue)).doubleValue();
            } else if (columnValue instanceof Timestamp) {
                result = new Date(((Timestamp)((Object)columnValue)).getTime());
            }
        }
        return result;
    }

    public StringBuilder processEvaluators(StringBuilder result, EvaluatorCollection collection) {
        String separatorValue = collection instanceof Or ? SystemProperties.get((String)"hcjf.query.or.reserved.word") : SystemProperties.get((String)"hcjf.query.and.reserved.word");
        boolean addSeparator = false;
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (addSeparator) {
                result.append(" ").append(separatorValue).append(" ");
            }
            if (evaluator instanceof Or) {
                result.append("(");
                this.processEvaluators(result, (EvaluatorCollection)((Or)evaluator));
                result.append(")");
            } else if (evaluator instanceof And) {
                result.append("(");
                this.processEvaluators(result, (EvaluatorCollection)((And)evaluator));
                result.append(")");
            } else if (evaluator instanceof FieldEvaluator) {
                result.append(this.normalizeApplicationToDataSource((Query.QueryComponent)((FieldEvaluator)evaluator).getQueryParameter())).append(" ");
                int size = 0;
                if (evaluator instanceof Distinct) {
                    if (((FieldEvaluator)evaluator).getRawValue() == null) {
                        result.append(SystemProperties.get((String)"postgres.storage.layer.is.not.null.operator"));
                        size = -1;
                    } else {
                        result.append(SystemProperties.get((String)"hcjf.query.distinct.reserved.word"));
                    }
                } else if (evaluator instanceof Equals) {
                    if (((FieldEvaluator)evaluator).getRawValue() == null) {
                        result.append(SystemProperties.get((String)"postgres.storage.layer.is.null.operator"));
                        size = -1;
                    } else {
                        result.append(SystemProperties.get((String)"hcjf.query.equals.reserved.word"));
                    }
                } else if (evaluator instanceof GreaterThanOrEqual) {
                    result.append(SystemProperties.get((String)"hcjf.query.greater.than.or.equals.reserved.word"));
                } else if (evaluator instanceof GreaterThan) {
                    result.append(SystemProperties.get((String)"hcjf.query.greater.than.reserved.word"));
                } else if (evaluator instanceof NotIn) {
                    result.append(SystemProperties.get((String)"hcjf.query.not.in.reserved.word"));
                    size = ((FieldEvaluator)evaluator).getRawValue() instanceof Collection ? ((Collection)((FieldEvaluator)evaluator).getRawValue()).size() : 1;
                } else if (evaluator instanceof In) {
                    result.append(SystemProperties.get((String)"hcjf.query.in.reserved.word"));
                    size = ((FieldEvaluator)evaluator).getRawValue() instanceof Collection ? ((Collection)((FieldEvaluator)evaluator).getRawValue()).size() : 1;
                } else if (evaluator instanceof Like) {
                    result.append(SystemProperties.get((String)"postgres.storage.layer.like.operator"));
                } else if (evaluator instanceof SmallerThanOrEqual) {
                    result.append(SystemProperties.get((String)"hcjf.query.smaller.than.or.equals.reserved.word"));
                } else if (evaluator instanceof SmallerThan) {
                    result.append(SystemProperties.get((String)"hcjf.query.smaller.than.reserved.word"));
                }
                if (size > 0) {
                    String argumentSeparatorValue = SystemProperties.get((String)"hcjf.query.argument.separator");
                    String argumentSeparator = "";
                    result.append(" ").append("(");
                    for (int i = 0; i < size; ++i) {
                        result.append(argumentSeparator).append(SystemProperties.get((String)"hcjf.query.replaceable.value.reserved.word"));
                        argumentSeparator = argumentSeparatorValue;
                    }
                    result.append(")").append(" ");
                } else if (size == 0) {
                    result.append(" ").append(SystemProperties.get((String)"hcjf.query.replaceable.value.reserved.word"));
                } else {
                    result.append(" ");
                }
            }
            addSeparator = true;
        }
        return result;
    }

    public PreparedStatement setValues(PreparedStatement statement, EvaluatorCollection collection, Integer index, Object ... params) {
        for (Evaluator evaluator : collection.getEvaluators()) {
            if (evaluator instanceof Or) {
                statement = this.setValues(statement, (EvaluatorCollection)((Or)evaluator), index, params);
                continue;
            }
            if (evaluator instanceof And) {
                statement = this.setValues(statement, (EvaluatorCollection)((And)evaluator), index, params);
                continue;
            }
            if (!(evaluator instanceof FieldEvaluator)) continue;
            try {
                Integer n;
                Object object;
                Object value = ((FieldEvaluator)evaluator).getValue(null, null, params);
                if (value == null) continue;
                if (value instanceof Date) {
                    object = index;
                    n = index = Integer.valueOf(index + 1);
                    statement.setTimestamp((Integer)object, new Timestamp(((Date)value).getTime()));
                    continue;
                }
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    for (Object object2 : (Collection)value) {
                        Integer n2 = index;
                        Integer n3 = index = Integer.valueOf(index + 1);
                        statement.setObject(n2, object2);
                    }
                    continue;
                }
                object = index;
                n = index = Integer.valueOf(index + 1);
                statement.setObject((Integer)object, value);
            }
            catch (SQLException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return statement;
    }

    public Select select(Query query) throws StorageAccessException {
        PostgresSelect select = new PostgresSelect(this);
        select.setQuery(query);
        return select;
    }

    public Update update(Query query, Map<String, Object> values) throws StorageAccessException {
        PostgresUpdate update = new PostgresUpdate(this);
        update.setQuery(query);
        for (String key : values.keySet()) {
            update.add(key, values.get(key));
        }
        return update;
    }

    public Insert insert() throws StorageAccessException {
        return new PostgresInsert(this);
    }
}

