/*
 * Decompiled with CFR 0.152.
 */
package org.hcjf.layers.storage.postgres.actions;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.hcjf.layers.storage.StorageAccessException;
import org.hcjf.layers.storage.StorageSession;
import org.hcjf.layers.storage.actions.Insert;
import org.hcjf.layers.storage.actions.ResultSet;
import org.hcjf.layers.storage.postgres.PostgresStorageSession;
import org.hcjf.layers.storage.values.StorageValue;
import org.hcjf.log.Log;
import org.hcjf.properties.SystemProperties;
import org.hcjf.utils.Strings;

public class PostgresInsert
extends Insert<PostgresStorageSession> {
    private static final String INSERT_STATEMENT = "INSERT INTO %s (%s) VALUES (%s);";

    public PostgresInsert(PostgresStorageSession session) {
        super((StorageSession)session);
    }

    public <R extends ResultSet> R execute(Object ... params) throws StorageAccessException {
        try {
            Strings.Builder valuesBuilder = new Strings.Builder();
            Strings.Builder valuePlacesBuilder = new Strings.Builder();
            ArrayList<Object> values = new ArrayList<Object>();
            Map storageValues = this.getValues();
            for (String storageValueName : storageValues.keySet()) {
                valuesBuilder.append(storageValueName, new String[]{","});
                valuePlacesBuilder.append(SystemProperties.get((String)"hcjf.query.replaceable.value.reserved.word"), new String[]{","});
                values.add(((StorageValue)storageValues.get(storageValueName)).getValue());
            }
            String statement = String.format(INSERT_STATEMENT, this.getResourceName(), valuesBuilder.toString(), valuePlacesBuilder.toString());
            PreparedStatement preparedStatement = ((PostgresStorageSession)this.getSession()).getConnection().prepareStatement(statement);
            int index = 1;
            for (Object e : values) {
                if (e instanceof Date) {
                    preparedStatement.setTimestamp(index++, new Timestamp(((Date)e).getTime()));
                    continue;
                }
                if (Collection.class.isAssignableFrom(e.getClass())) {
                    for (Object object : (Collection)e) {
                        preparedStatement.setObject(index++, object);
                    }
                    continue;
                }
                preparedStatement.setObject(index++, e);
            }
            Log.d((String)SystemProperties.get((String)"postgres.execute.statement.log.tag"), (String)preparedStatement.toString(), (Object[])new Object[0]);
            preparedStatement.executeUpdate();
            return null;
        }
        catch (Exception ex) {
            ((PostgresStorageSession)this.getSession()).onError(ex);
            throw new StorageAccessException((Throwable)ex);
        }
    }
}

