/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.util.Arrays;
import java.util.List;

public class Command {
    private ICommand command;
    private String label;
    private String[] args;

    Command(String raw, String prefix, CommandSettings settings) {
        String[] argsWithoutPrefix = raw.replaceFirst(prefix, "").split(" ");
        String commandLabel = settings.labelIgnoreCase() ? argsWithoutPrefix[0].toLowerCase() : argsWithoutPrefix[0];
        List<String> argList = Arrays.asList(argsWithoutPrefix);
        String[] args = argList.subList(1, argList.size()).toArray(new String[argList.size() - 1]);
        this.args = args;
        this.label = commandLabel;
        if (settings.getCommands().containsKey(commandLabel)) {
            this.command = settings.getCommands().get(commandLabel);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ICommand getExecutor() {
        return this.command;
    }
}

