/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.Command;
import com.github.johnnyjayjay.discord.commandapi.CommandEvent;
import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.core.hooks.ListenerAdapter;

class CommandListener
extends ListenerAdapter {
    private CommandSettings settings;

    public CommandListener(CommandSettings settings) {
        this.settings = settings;
    }

    public void onGuildMessageReceived(GuildMessageReceivedEvent event) {
        String prefix;
        String raw = event.getMessage().getContentRaw();
        if (raw.startsWith(prefix = this.settings.getPrefix(event.getGuild().getIdLong())) && !event.getAuthor().isBot()) {
            Command cmd = new Command(raw, prefix, this.settings);
            if (cmd.getExecutor() != null) {
                cmd.getExecutor().onCommand(new CommandEvent(event.getJDA(), event.getResponseNumber(), event.getMessage(), cmd), event.getMember(), event.getChannel(), cmd.getArgs());
            } else if (this.settings.useHelpCommand() && this.settings.getHelpLabels().contains(cmd.getLabel())) {
                this.sendInfo(event.getChannel(), prefix, cmd.getArgs());
            }
        }
    }

    private void sendInfo(TextChannel channel, String prefix, String[] args) {
        EmbedBuilder builder = new EmbedBuilder().setTitle("Help");
        if (args.length == 0) {
            String helpLabels = String.format("[%s]", String.join((CharSequence)"|", this.settings.getHelpLabels().toArray(new String[this.settings.getHelpLabels().size()])));
            builder.appendDescription((CharSequence)String.format("To learn more about a specific command, just call `%s%s <label>`.\n", prefix, helpLabels)).appendDescription((CharSequence)"The following commands are currently available:\n");
            CharSequence[] commandLabels = this.settings.getCommands().keySet().toArray(new String[this.settings.getCommands().keySet().size()]);
            builder.addField("Commands", String.format("```\n%s%s```", prefix, String.join((CharSequence)String.format("\n%s", prefix), commandLabels)), false);
            channel.sendMessage(builder.build()).queue();
        } else if (args.length == 1 && this.settings.getCommands().containsKey(args[0])) {
            builder.appendDescription((CharSequence)String.format("**Command Info for:** `%s`\n\n", args[0])).appendDescription((CharSequence)this.settings.getCommands().get(args[0]).info());
            channel.sendMessage(builder.build()).queue();
        }
    }
}

