/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class JenaRDFParser
implements RDFParser {
    protected Iterator<String> _ng = new Iterator<String>(){
        final AtomicInteger i = new AtomicInteger(0);

        @Override
        public void remove() {
        }

        @Override
        public String next() {
            return "_:t" + this.i.incrementAndGet();
        }

        @Override
        public boolean hasNext() {
            return true;
        }
    };
    protected Map<String, String> _bns = new LinkedHashMap<String, String>();

    protected String getNameForBlankNode(String node) {
        if (!this._bns.containsKey(node)) {
            this._bns.put(node, this._ng.next());
        }
        return this._bns.get(node);
    }

    public void setPrefix(String fullUri, String prefix) {
    }

    public String getID(Node r) {
        String rval = null;
        rval = r.isBlank() ? this.getNameForBlankNode(r.getBlankNodeLabel()) : r.getURI();
        return rval;
    }

    public String getID(Resource r) {
        String rval = null;
        rval = r.isAnon() ? this.getNameForBlankNode(r.getId().toString()) : r.getURI();
        return rval;
    }

    public void importModel(RDFDataset result, Model model) {
        Map nsPrefixMap = model.getNsPrefixMap();
        for (String prefix : nsPrefixMap.keySet()) {
            result.setNamespace(prefix, (String)nsPrefixMap.get(prefix));
        }
        ResIterator subjects = model.listSubjects();
        while (subjects.hasNext()) {
            Resource subject = (Resource)subjects.next();
            this.importResource(result, subject);
        }
    }

    public void importResource(RDFDataset result, Resource subject) {
        String subj = this.getID(subject);
        StmtIterator statements = subject.getModel().listStatements(subject, (Property)null, (RDFNode)null);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Property predicate = statement.getPredicate();
            RDFNode object = statement.getObject();
            if (object.isLiteral()) {
                Literal literal = object.asLiteral();
                String value = literal.getLexicalForm();
                String datatypeURI = literal.getDatatypeURI();
                String language = literal.getLanguage();
                if ("".equals(language)) {
                    language = null;
                }
                result.addTriple(subj, predicate.getURI(), value, datatypeURI, language);
                continue;
            }
            Resource resource = object.asResource();
            String res = this.getID(resource);
            result.addTriple(subj, predicate.getURI(), res);
        }
    }

    private void importGraph(RDFDataset result, Graph graph, String graphName) {
        ExtendedIterator triples = graph.find(null, null, null);
        while (triples.hasNext()) {
            Triple t = (Triple)triples.next();
            String subj = this.getID(t.getSubject());
            String prop = t.getPredicate().getURI();
            if (t.getObject().isLiteral()) {
                String value = t.getObject().getLiteralLexicalForm();
                String datatypeURI = t.getObject().getLiteralDatatypeURI();
                String language = t.getObject().getLiteralLanguage();
                if ("".equals(language)) {
                    language = null;
                }
                result.addQuad(subj, prop, value, datatypeURI, language, graphName);
                continue;
            }
            result.addQuad(subj, prop, this.getID(t.getObject()), graphName);
        }
    }

    private void importDatasetGraph(RDFDataset result, DatasetGraph input) {
        this.importGraph(result, input.getDefaultGraph(), "@default");
        Iterator graphNodes = input.listGraphNodes();
        while (graphNodes.hasNext()) {
            Node n = (Node)graphNodes.next();
            Graph graph = input.getGraph(n);
            String graphName = n.getURI();
            this.importGraph(result, graph, graphName);
        }
    }

    public RDFDataset parse(Object input) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (input == null) {
            return result;
        }
        if (input instanceof DatasetGraph) {
            this.importDatasetGraph(result, (DatasetGraph)input);
        } else if (input instanceof Resource) {
            this.importResource(result, (Resource)input);
        } else if (input instanceof Model) {
            this.importModel(result, (Model)input);
        } else {
            throw new JsonLdError(JsonLdError.Error.INVALID_INPUT, (Object)"Jena Serializer expects Model or resource input");
        }
        return result;
    }
}

