/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.sesame.SesameJSONLDParser;
import com.github.jsonldjava.sesame.SesameJSONLDWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.rio.AbstractParserHandlingTest;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;

public class SesameJSONLDParserHandlerTest
extends AbstractParserHandlingTest {
    protected InputStream getUnknownDatatypeStream(Model unknownDatatypeStatements) throws Exception {
        return this.writeJSONLD(unknownDatatypeStatements);
    }

    protected InputStream getKnownDatatypeStream(Model knownDatatypeStatements) throws Exception {
        return this.writeJSONLD(knownDatatypeStatements);
    }

    protected InputStream getUnknownLanguageStream(Model unknownLanguageStatements) throws Exception {
        return this.writeJSONLD(unknownLanguageStatements);
    }

    protected InputStream getKnownLanguageStream(Model knownLanguageStatements) throws Exception {
        return this.writeJSONLD(knownLanguageStatements);
    }

    protected RDFParser getParser() {
        return new SesameJSONLDParser();
    }

    private InputStream writeJSONLD(Model statements) throws RDFHandlerException {
        StringWriter writer = new StringWriter();
        SesameJSONLDWriter jsonldWriter = new SesameJSONLDWriter((Writer)writer);
        jsonldWriter.startRDF();
        for (Namespace prefix : statements.getNamespaces()) {
            jsonldWriter.handleNamespace(prefix.getPrefix(), prefix.getName());
        }
        for (Statement nextStatement : statements) {
            jsonldWriter.handleStatement(nextStatement);
        }
        jsonldWriter.endRDF();
        return new ByteArrayInputStream(writer.toString().getBytes(Charset.forName("UTF-8")));
    }
}

