/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.sesame;

import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.sesame.SesameTripleCallback;
import com.github.jsonldjava.utils.JSONUtils;
import java.io.IOException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.ParseErrorCollector;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameTripleCallbackTest {
    @Test
    public void triplesTest() throws JsonLdError, IOException {
        String inputstring = "{ \"@id\":\"http://nonexistent.com/abox#Document1823812\", \"@type\":\"http://nonexistent.com/tbox#Document\" }";
        String expectedString = "(http://nonexistent.com/abox#Document1823812, http://www.w3.org/1999/02/22-rdf-syntax-ns#type, http://nonexistent.com/tbox#Document) [null]";
        Object input = JSONUtils.fromString((String)"{ \"@id\":\"http://nonexistent.com/abox#Document1823812\", \"@type\":\"http://nonexistent.com/tbox#Document\" }");
        LinkedHashModel graph = new LinkedHashModel();
        ParseErrorCollector parseErrorListener = new ParseErrorCollector();
        ParserConfig parserConfig = new ParserConfig();
        SesameTripleCallback callback = new SesameTripleCallback((RDFHandler)new StatementCollector((Collection)graph), (ValueFactory)ValueFactoryImpl.getInstance(), parserConfig, (ParseErrorListener)parseErrorListener);
        JsonLdProcessor.toRDF((Object)input, (JSONLDTripleCallback)callback);
        for (Statement stmt : graph) {
            System.out.println(stmt.toString());
            Assert.assertEquals((String)"Output was not as expected", (Object)stmt.toString(), (Object)"(http://nonexistent.com/abox#Document1823812, http://www.w3.org/1999/02/22-rdf-syntax-ns#type, http://nonexistent.com/tbox#Document) [null]");
        }
        Assert.assertEquals((long)0L, (long)parseErrorListener.getFatalErrors().size());
        Assert.assertEquals((long)0L, (long)parseErrorListener.getErrors().size());
        Assert.assertEquals((long)0L, (long)parseErrorListener.getWarnings().size());
    }
}

