/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.tools;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

class SesameJSONLDRDFParser
implements RDFParser {
    SesameJSONLDRDFParser() {
    }

    public void setPrefix(RDFDataset result, String fullUri, String prefix) {
        result.setNamespace(fullUri, prefix);
    }

    public void handleStatement(RDFDataset result, Statement nextStatement) {
        String subject = this.getResourceValue(nextStatement.getSubject());
        String predicate = this.getResourceValue((Resource)nextStatement.getPredicate());
        Value object = nextStatement.getObject();
        String graphName = this.getResourceValue(nextStatement.getContext());
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            String value = literal.getLabel();
            String language = literal.getLanguage();
            String datatype = this.getResourceValue((Resource)literal.getDatatype());
            if (language != null && datatype == null) {
                datatype = RDF.LANGSTRING.stringValue();
            }
            if (language == null && datatype == null) {
                datatype = XMLSchema.STRING.stringValue();
            }
            result.addQuad(subject, predicate, value, datatype, language, graphName);
        } else {
            result.addQuad(subject, predicate, this.getResourceValue((Resource)object), graphName);
        }
    }

    private String getResourceValue(Resource subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof URI) {
            return subject.stringValue();
        }
        if (subject instanceof BNode) {
            return "_:" + subject.stringValue();
        }
        throw new IllegalStateException("Did not recognise resource type: " + subject.getClass().getName());
    }

    public RDFDataset parse(Object input) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (input instanceof Statement) {
            this.handleStatement(result, (Statement)input);
        } else if (input instanceof Graph) {
            if (input instanceof Model) {
                Set namespaces = ((Model)input).getNamespaces();
                for (Namespace nextNs : namespaces) {
                    result.setNamespace(nextNs.getName(), nextNs.getPrefix());
                }
            }
            for (Statement nextStatement : (Graph)input) {
                this.handleStatement(result, nextStatement);
            }
        }
        return result;
    }
}

