/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.model.homeautomation;

import com.github.kaklakariada.fritzbox.model.homeautomation.Button;
import com.github.kaklakariada.fritzbox.model.homeautomation.ColorControl;
import com.github.kaklakariada.fritzbox.model.homeautomation.EtsiUnitInfo;
import com.github.kaklakariada.fritzbox.model.homeautomation.Hkr;
import com.github.kaklakariada.fritzbox.model.homeautomation.LevelControl;
import com.github.kaklakariada.fritzbox.model.homeautomation.PowerMeter;
import com.github.kaklakariada.fritzbox.model.homeautomation.SimpleOnOffState;
import com.github.kaklakariada.fritzbox.model.homeautomation.SwitchState;
import com.github.kaklakariada.fritzbox.model.homeautomation.Temperature;
import java.util.List;
import java.util.Optional;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="device")
public class Device {
    @Attribute(name="identifier", required=true)
    private String identifier;
    @Attribute(name="id")
    private String id;
    @Attribute(name="functionbitmask")
    private int functionBitmask;
    @Attribute(name="fwversion")
    private String firmwareVersion;
    @Attribute(name="manufacturer")
    private String manufacturer;
    @Attribute(name="productname")
    private String productName;
    @Element(name="present")
    private String present;
    @Element(name="txbusy")
    private String txbusy;
    @Element(name="name")
    private String name;
    @Element(name="batterylow", required=false)
    private Integer batterylow;
    @Element(name="battery", required=false)
    private Integer battery;
    @Element(name="switch", required=false)
    private SwitchState switchState;
    @Element(name="simpleonoff", required=false)
    private SimpleOnOffState simpleOnOff;
    @Element(name="powermeter", required=false)
    private PowerMeter powerMeter;
    @Element(name="temperature", required=false)
    private Temperature temperature;
    @Element(name="hkr", required=false)
    private Hkr hkr;
    @Element(name="levelcontrol", required=false)
    private LevelControl levelControl;
    @Element(name="colorcontrol", required=false)
    private ColorControl colorControl;
    @Element(name="etsiunitinfo", required=false)
    private EtsiUnitInfo etsiUnitInfo;
    @ElementList(name="buttons", required=false, inline=true)
    private List<Button> buttons;

    public String getIdentifier() {
        return this.identifier;
    }

    public String getId() {
        return this.id;
    }

    public int getFunctionBitmask() {
        return this.functionBitmask;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean isPresent() {
        return "1".equals(this.present);
    }

    public boolean isTxBusy() {
        return "1".equals(this.txbusy);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Boolean> isBatterylow() {
        return Optional.ofNullable(this.batterylow).map(value -> 1 == value);
    }

    public Optional<Integer> getBattery() {
        return Optional.ofNullable(this.battery);
    }

    public SwitchState getSwitchState() {
        return this.switchState.isNull() ? null : this.switchState;
    }

    public PowerMeter getPowerMeter() {
        return this.powerMeter;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public Hkr getHkr() {
        return this.hkr;
    }

    public SimpleOnOffState getSimpleOnOff() {
        return this.simpleOnOff;
    }

    public LevelControl getLevelControl() {
        return this.levelControl;
    }

    public ColorControl getColorControl() {
        return this.colorControl;
    }

    public EtsiUnitInfo getEtsiUnitInfo() {
        return this.etsiUnitInfo;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public String toString() {
        return "Device [identifier=" + this.identifier + ", id=" + this.id + ", functionBitmask=" + this.functionBitmask + ", firmwareVersion=" + this.firmwareVersion + ", manufacturer=" + this.manufacturer + ", productName=" + this.productName + ", present=" + this.present + ", txbusy=" + this.txbusy + ", name=" + this.name + ", batterylow=" + this.batterylow + ", battery=" + this.battery + ", switchState=" + this.switchState + ", simpleOnOff=" + this.simpleOnOff + ", powerMeter=" + this.powerMeter + ", temperature=" + this.temperature + ", hkr=" + this.hkr + "]";
    }
}

