/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.FritzBoxException;
import com.github.kaklakariada.fritzbox.LoginFailedException;
import com.github.kaklakariada.fritzbox.Md5Service;
import com.github.kaklakariada.fritzbox.http.HttpTemplate;
import com.github.kaklakariada.fritzbox.http.QueryParameters;
import com.github.kaklakariada.fritzbox.model.SessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FritzBoxSession {
    private static final Logger LOG = LoggerFactory.getLogger(FritzBoxSession.class);
    private static final String LOGIN_PATH = "/login_sid.lua";
    private static final String WEBCM_PATH = "/home/home.lua";
    private static final String EMPTY_SESSION_ID = "0000000000000000";
    private String sid;
    private final HttpTemplate httpTemplate;
    private final Md5Service md5Service;

    FritzBoxSession(String baseUrl) {
        this(new HttpTemplate(baseUrl));
    }

    FritzBoxSession(HttpTemplate httpTemplate) {
        this(httpTemplate, new Md5Service(), null);
    }

    private FritzBoxSession(HttpTemplate httpTemplate, Md5Service md5Service, String sid) {
        this.httpTemplate = httpTemplate;
        this.md5Service = md5Service;
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void login(String username, String password) {
        SessionInfo sessionWithChallenge = this.httpTemplate.get(LOGIN_PATH, SessionInfo.class);
        if (!EMPTY_SESSION_ID.equals(sessionWithChallenge.getSid())) {
            throw new FritzBoxException("Already logged in: " + sessionWithChallenge);
        }
        String response = this.createChallengeResponse(sessionWithChallenge.getChallenge(), password);
        LOG.debug("Got response {} for challenge {}", (Object)response, (Object)sessionWithChallenge.getChallenge());
        QueryParameters arguments = QueryParameters.builder().add("username", username == null ? "" : username).add("response", response).build();
        SessionInfo sessionInfo = this.httpTemplate.get(LOGIN_PATH, arguments, SessionInfo.class);
        if (EMPTY_SESSION_ID.equals(sessionInfo.getSid())) {
            throw new LoginFailedException(sessionInfo);
        }
        LOG.debug("Logged in with session id {} and rights {}", (Object)sessionInfo.getSid(), sessionInfo.getRights());
        this.sid = sessionInfo.getSid();
    }

    private String createChallengeResponse(String challenge, String password) {
        String text = challenge + "-" + password;
        return challenge + "-" + this.md5Service.md5(text);
    }

    public <T> T getAutenticated(String path, QueryParameters parameters, Class<T> resultType) {
        if (this.sid == null) {
            throw new FritzBoxException("Not logged in, session id is null");
        }
        QueryParameters parametersWithSessionId = parameters.newBuilder().add("sid", this.sid).build();
        return this.httpTemplate.get(path, parametersWithSessionId, resultType);
    }

    public void logout() {
        this.httpTemplate.get(WEBCM_PATH, QueryParameters.builder().add("sid", this.sid).add("logout", "1").build(), String.class);
        LOG.debug("Logged out, invalidate sid");
        this.sid = null;
    }
}

