/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.EnergyStatisticsService;
import com.github.kaklakariada.fritzbox.FritzBoxException;
import com.github.kaklakariada.fritzbox.HomeAutomation;
import com.github.kaklakariada.fritzbox.model.homeautomation.Device;
import com.github.kaklakariada.fritzbox.model.homeautomation.DeviceList;
import com.github.kaklakariada.fritzbox.model.homeautomation.PowerMeter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDriver {
    private static final Logger LOG = LoggerFactory.getLogger(TestDriver.class);

    public static void main(String[] args) throws InterruptedException {
        Properties config = TestDriver.readConfig(Paths.get("application.properties", new String[0]));
        String url = config.getProperty("fritzbox.url");
        String username = config.getProperty("fritzbox.username", null);
        String password = config.getProperty("fritzbox.password");
        LOG.info("Logging in to '{}' with username '{}'", (Object)url, (Object)username);
        HomeAutomation homeAutomation = HomeAutomation.connect(url, username, password);
        DeviceList devices = homeAutomation.getDeviceListInfos();
        LOG.info("Found {} devices", (Object)devices.getDevices().size());
        for (Device device : devices.getDevices()) {
            LOG.info("\t{}", (Object)device);
        }
        List<String> ids = homeAutomation.getSwitchList();
        LOG.info("Found {} device ids: {}", (Object)ids.size(), ids);
        if (devices.getDevices().isEmpty()) {
            homeAutomation.logout();
            return;
        }
        String ain = ids.get(0);
        TestDriver.testHomeAutomation(homeAutomation, ain);
    }

    private static void testEnergyStats(HomeAutomation homeAutomation, String deviceId) {
        EnergyStatisticsService service = homeAutomation.getEnergyStatistics();
        for (EnergyStatisticsService.EnergyStatsTimeRange timeRange : EnergyStatisticsService.EnergyStatsTimeRange.values()) {
            String energyStatistics = service.getEnergyStatistics(deviceId, timeRange);
            LOG.debug("Statistics {}: {}", (Object)timeRange, (Object)energyStatistics);
        }
    }

    private static void testHomeAutomation(HomeAutomation homeAutomation, String ain) throws InterruptedException {
        homeAutomation.switchPowerState(ain, false);
        homeAutomation.togglePowerState(ain);
        LOG.info("Switch {} has present state '{}'", (Object)ain, (Object)homeAutomation.getSwitchPresent(ain));
        LOG.info("Switch {} has state '{}'", (Object)ain, (Object)homeAutomation.getSwitchState(ain));
        LOG.info("Switch {} uses {}W", (Object)ain, (Object)homeAutomation.getSwitchPowerWatt(ain));
        LOG.info("Switch {} has used {}Wh", (Object)ain, (Object)homeAutomation.getSwitchEnergyWattHour(ain));
        LOG.info("Switch {} has name '{}'", (Object)ain, (Object)homeAutomation.getSwitchName(ain));
        LOG.info("Switch {} has temperature {}\u00b0C", (Object)ain, (Object)homeAutomation.getTemperature(ain));
        while (true) {
            List<Device> devices;
            if ((devices = homeAutomation.getDeviceListInfos().getDevices()).isEmpty()) {
                LOG.warn("No devices found");
                return;
            }
            devices.forEach(TestDriver::logDeviceDetails);
            Thread.sleep(1000L);
        }
    }

    private static void logDeviceDetails(Device device) {
        PowerMeter powerMeter = device.getPowerMeter();
        if (device.getSwitchState() == null) {
            return;
        }
        String switchState = device.getSwitchState().isOn() ? "on" : "off";
        LOG.debug("State: {}, temp: {}\u00b0C, voltage: {}V, power: {}W, energy: {}Wh", new Object[]{switchState, Float.valueOf(device.getTemperature().getCelsius()), Float.valueOf(powerMeter.getVoltageVolt()), Float.valueOf(powerMeter.getPowerWatt()), powerMeter.getEnergyWattHours()});
    }

    private static Properties readConfig(Path path) {
        Properties config = new Properties();
        Path absolutePath = path.toAbsolutePath();
        LOG.debug("Reading config from file {}", (Object)absolutePath);
        try (InputStream in = Files.newInputStream(absolutePath, new OpenOption[0]);){
            config.load(in);
        }
        catch (IOException e) {
            throw new FritzBoxException("Error loading configuration from " + absolutePath, e);
        }
        return config;
    }
}

