/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox;

import com.github.kaklakariada.fritzbox.FritzBoxSession;
import com.github.kaklakariada.fritzbox.http.QueryParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnergyStatisticsService {
    private static final Logger LOG = LoggerFactory.getLogger(EnergyStatisticsService.class);
    private static final String QUERY_PATH = "/net/home_auto_query.lua";
    private final FritzBoxSession session;

    public EnergyStatisticsService(FritzBoxSession session) {
        this.session = session;
    }

    public String getEnergyStatistics(String deviceId, EnergyStatsTimeRange timeRange) {
        return this.executeDeviceCommand(deviceId, timeRange.command);
    }

    private String executeDeviceCommand(String deviceId, String command) {
        QueryParameters parameters = QueryParameters.builder().add("command", command).add("id", deviceId).add("xhr", "1").build();
        String statisticsJson = this.session.getAutenticated(QUERY_PATH, parameters, String.class);
        LOG.trace("Got statistics json for command '{}': {}", (Object)command, (Object)statisticsJson);
        return statisticsJson;
    }

    public static enum EnergyStatsTimeRange {
        TEN_MINUTES("EnergyStats_10"),
        ONE_HOUR("EnergyStats_hour"),
        ONE_DAY("EnergyStats_24h"),
        ONE_WEEK("EnergyStats_week"),
        ONE_MONTH("EnergyStats_month"),
        ONE_YEAR("EnergyStats_year");

        private final String command;

        private EnergyStatsTimeRange(String command) {
            this.command = command;
        }
    }
}

