/*
 * Decompiled with CFR 0.152.
 */
package com.github.kaklakariada.fritzbox.http;

import com.github.kaklakariada.fritzbox.http.HttpException;
import com.github.kaklakariada.fritzbox.http.NullTrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class TrustSelfSignedCertificates {
    private TrustSelfSignedCertificates() {
    }

    public static SSLSocketFactory getUnsafeSslSocketFactory() {
        SSLContext sslContext = TrustSelfSignedCertificates.getSSLContext("TLS");
        TrustSelfSignedCertificates.initializeSslContext(sslContext);
        return sslContext.getSocketFactory();
    }

    private static void initializeSslContext(SSLContext sslContext) {
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = new TrustManager[]{new NullTrustManager()};
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext1 = sslContext;
        try {
            sslContext1.init(keyManagers, trustManagers, secureRandom);
        }
        catch (KeyManagementException e) {
            throw new HttpException("Error initializing ssl context", e);
        }
    }

    private static SSLContext getSSLContext(String algorithm) {
        try {
            return SSLContext.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("Algorithm " + algorithm + " not found", e);
        }
    }
}

